/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.metadata.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.application.common.services.metadata.internal.DomainSourceModelTypeDescriptor;
import oracle.eclipse.tools.application.common.services.metadata.internal.IDomainSourceModelType2;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class DomainSourceTypesRegistry {
    private static final String EXTENSION_POINT_ID = "domainSourceModelTypes";
    private static DomainSourceTypesRegistry INSTANCE;
    private Map<String, List<DomainSourceModelTypeDescriptor>> domainSourceTypeDescriptors;

    private DomainSourceTypesRegistry() {
        this.init();
    }

    public static synchronized DomainSourceTypesRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DomainSourceTypesRegistry();
        }
        return INSTANCE;
    }

    public List<IDomainSourceModelType2> getDomainSourceTypes(String domain) {
        List list = this.getDomainSourceModelDescriptors(domain);
        ArrayList<IDomainSourceModelType2> types = new ArrayList<IDomainSourceModelType2>();
        for (DomainSourceModelTypeDescriptor d : list) {
            types.add(d.getInstance());
        }
        Collections.sort(types, new Comparator(){

            public int compare(Object o1, Object o2) {
                DomainSourceModelTypeDescriptor.DomainSourceModelTypeImpl desc1 = (DomainSourceModelTypeDescriptor.DomainSourceModelTypeImpl)o1;
                DomainSourceModelTypeDescriptor.DomainSourceModelTypeImpl desc2 = (DomainSourceModelTypeDescriptor.DomainSourceModelTypeImpl)o2;
                if (desc1.getDomainSourceModelTypeDescriptor().getOrdinal() == desc2.getDomainSourceModelTypeDescriptor().getOrdinal()) {
                    return 0;
                }
                if (desc1.getDomainSourceModelTypeDescriptor().getOrdinal() < desc2.getDomainSourceModelTypeDescriptor().getOrdinal()) {
                    return -1;
                }
                return 1;
            }
        });
        return Collections.unmodifiableList(types);
    }

    private List getDomainSourceModelDescriptors(String domain) {
        List<DomainSourceModelTypeDescriptor> ret = this.getDescriptors().get(domain);
        if (ret != null && ret.size() > 0) {
            return ret;
        }
        return this.getDefaultSourceModelDescriptor();
    }

    private List getDefaultSourceModelDescriptor() {
        ArrayList<DomainSourceModelTypeDescriptor> ret = new ArrayList<DomainSourceModelTypeDescriptor>();
        DomainSourceModelTypeDescriptor desc = new DomainSourceModelTypeDescriptor();
        ret.add(desc);
        return ret;
    }

    private synchronized void init() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = extensionRegistry.getExtensionPoint("oracle.eclipse.tools.application.common.services", EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                this.addDomainSourceTypeDescriptor(element);
                ++i;
            }
        }
    }

    private void addDomainSourceTypeDescriptor(IConfigurationElement element) {
        String domainId = element.getAttribute("domainId");
        String srcHdlrId = element.getAttribute("domainSourceModelTypeId");
        String locator = element.getAttribute("locator");
        String ordinalStr = element.getAttribute("ordinal");
        int ordinal = 1;
        if (ordinalStr != null && !ordinalStr.equals("")) {
            ordinal = Integer.parseInt(ordinalStr);
        }
        DomainSourceModelTypeDescriptor d = new DomainSourceModelTypeDescriptor(domainId, srcHdlrId, locator, element.getContributor().getName(), ordinal);
        List<DomainSourceModelTypeDescriptor> descs = this.getDescriptors().get(domainId);
        if (descs == null) {
            descs = new ArrayList<DomainSourceModelTypeDescriptor>();
            this.getDescriptors().put(domainId, descs);
        }
        descs.add(d);
    }

    private Map<String, List<DomainSourceModelTypeDescriptor>> getDescriptors() {
        if (this.domainSourceTypeDescriptors == null) {
            this.domainSourceTypeDescriptors = new HashMap<String, List<DomainSourceModelTypeDescriptor>>();
        }
        return this.domainSourceTypeDescriptors;
    }
}

