/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.metadata.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.TraceOptions;
import oracle.eclipse.tools.application.common.services.metadata.internal.DomainSourceTypesRegistry;
import oracle.eclipse.tools.application.common.services.metadata.internal.IDomainLoadingStrategy2;
import oracle.eclipse.tools.application.common.services.metadata.internal.IDomainSourceModelType2;
import oracle.eclipse.tools.application.common.services.metadata.internal.IMetaDataChangeNotificationEvent2;
import oracle.eclipse.tools.application.common.services.metadata.internal.IMetaDataLocator2;
import oracle.eclipse.tools.application.common.services.metadata.internal.IMetaDataModelMergeAssistant2;
import oracle.eclipse.tools.application.common.services.metadata.internal.IMetaDataObserver2;
import oracle.eclipse.tools.application.common.services.metadata.internal.IMetaDataSourceModelProvider2;
import oracle.eclipse.tools.application.common.services.metadata.internal.IMetaDataTranslator2;
import oracle.eclipse.tools.application.common.services.metadata.internal.IPathSensitiveMetaDataLocator2;
import oracle.eclipse.tools.application.common.services.metadata.internal.MetaDataModel2;
import oracle.eclipse.tools.application.common.services.metadata.internal.MetaDataModelMergeAssistantImpl2;
import oracle.eclipse.tools.application.common.services.metadata.internal.StandardModelFactory2;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.internal.ModelNotSetException;
import org.eclipse.jst.jsf.common.metadata.internal.util.MetadataResourceFactoryImpl;

public class DomainLoadingStrategy2
implements IDomainLoadingStrategy2,
IMetaDataObserver2 {
    protected String domain;
    private MetaDataModel2 _model;
    private List<IDomainSourceModelType2> _sourceTypes;
    private List<IMetaDataSourceModelProvider2> _sources;

    public DomainLoadingStrategy2(String domain) {
        this.domain = domain;
    }

    @Override
    public void load(MetaDataModel2 model) {
        this._model = model;
        this._sourceTypes = this.loadDomainSourceModelTypes();
        this.sortSourceTypes(this._sourceTypes);
        this._sources = this.locateMetaDataSourceInstances(this._sourceTypes, model);
        this.mergeModel(model, this._sources);
    }

    @Override
    public void reload() throws ModelNotSetException {
        if (this._model == null) {
            throw new ModelNotSetException();
        }
        this.removeOldLocatorObservers();
        this._sources = this.locateMetaDataSourceInstances(this._sourceTypes, this._model);
        this.mergeModel(this._model, this._sources);
    }

    protected void mergeModel(MetaDataModel2 model, List<IMetaDataSourceModelProvider2> sources) {
        StandardModelFactory2.debug(">> Begin Merge: " + model.getModelContext() + "(" + sources.size() + " sources)", TraceOptions.MD_LOAD);
        IMetaDataModelMergeAssistant2 assistant = this.createModelMergeAssistant(model);
        for (IMetaDataSourceModelProvider2 mds : sources) {
            for (IMetaDataTranslator2 translator : mds.getLocator2().getDomainSourceModelType().getTranslators()) {
                if (!translator.canTranslate(mds)) continue;
                StandardModelFactory2.debug(">>> Merging: " + model.getModelContext() + "::" + mds, TraceOptions.MD_LOAD);
                try {
                    Model m = translator.translate(mds);
                    assistant.mergeModel(m);
                }
                catch (Exception e) {
                    StandardModelFactory2.debug(">>>> Error during translate/merge of: " + model.getModelContext() + ": " + mds, TraceOptions.MD_LOAD);
                    Activator.log(4, "Error during load of: " + mds, e);
                }
            }
            mds.release();
        }
        assistant.setMergeComplete();
        StandardModelFactory2.debug(">> End Merge: " + model.getModelContext(), TraceOptions.MD_LOAD);
    }

    public void saveModel(Model m, String fileName) throws Exception {
        ResourceSetImpl rs = new ResourceSetImpl();
        MetadataResourceFactoryImpl resF = new MetadataResourceFactoryImpl();
        Resource res = resF.createResource(URI.createFileURI((String)("c:/temp/" + fileName)));
        res.getContents().add((Object)m);
        rs.getResources().add((Object)res);
        res.save(Collections.EMPTY_MAP);
    }

    protected IMetaDataModelMergeAssistant2 createModelMergeAssistant(MetaDataModel2 model) {
        return new MetaDataModelMergeAssistantImpl2(model);
    }

    protected void sortSourceTypes(List<IDomainSourceModelType2> sourceTypes) {
    }

    protected List<IDomainSourceModelType2> loadDomainSourceModelTypes() {
        return DomainSourceTypesRegistry.getInstance().getDomainSourceTypes(this.domain);
    }

    protected List<IMetaDataSourceModelProvider2> locateMetaDataSourceInstances(List<IDomainSourceModelType2> sourceTypes, MetaDataModel2 model) {
        ArrayList<IMetaDataSourceModelProvider2> sources = new ArrayList<IMetaDataSourceModelProvider2>();
        IProject project = this.getProject(model);
        for (IDomainSourceModelType2 sourceType : sourceTypes) {
            IMetaDataLocator2 locator = sourceType.getLocator(project);
            if (locator == null || !this.isLocatorForManager(locator, model)) continue;
            locator.setDomainSourceModelType(sourceType);
            List<IMetaDataSourceModelProvider2> providers = locator.locateMetaDataModelProviders(model.getModelContext().getModelIdentifier());
            if (providers != null && !providers.isEmpty()) {
                for (IMetaDataSourceModelProvider2 provider : providers) {
                    provider.setLocator2(locator);
                    sources.add(provider);
                }
            }
            locator.addObserver(this);
        }
        return sources;
    }

    private boolean isLocatorForManager(IMetaDataLocator2 locator, MetaDataModel2 model) {
        if (locator instanceof IPathSensitiveMetaDataLocator2) {
            return !model.isCommonModelManager();
        }
        return model.isCommonModelManager();
    }

    private IProject getProject(MetaDataModel2 model) {
        return (IProject)model.getModelContext().getAdapter(IProject.class);
    }

    @Override
    public void notifyMetadataChanged(IMetaDataChangeNotificationEvent2 event) {
        this._model.setNeedsRefresh();
    }

    @Override
    public void cleanup() {
        this.removeOldLocatorObservers();
        this._sources = null;
        this._sourceTypes = null;
        this._model = null;
    }

    private void removeOldLocatorObservers() {
        if (this._sources != null) {
            for (IMetaDataSourceModelProvider2 provider : this._sources) {
                IMetaDataLocator2 locator;
                if (provider == null || (locator = provider.getLocator2()) == null) continue;
                locator.removeObserver(this);
                locator.setDomainSourceModelType(null);
                provider.setLocator2(null);
            }
        }
    }
}

