/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.metadata.internal;

import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.application.common.services.metadata.IVersion;
import oracle.eclipse.tools.application.common.services.metadata.internal.IVersionFactory;
import oracle.eclipse.tools.application.common.services.metadata.internal.IVersionRange;
import oracle.eclipse.tools.application.common.services.metadata.internal.Version;
import oracle.eclipse.tools.application.common.services.metadata.internal.VersionRange;

public class DefaultVersionFactory
implements IVersionFactory {
    private Map<String, IVersion> _versionMap = new HashMap<String, IVersion>();
    private Map<String, IVersionRange> _versionRangeMap = new HashMap<String, IVersionRange>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IVersion getVersion(String versionString) throws NumberFormatException, IllegalArgumentException {
        Map<String, IVersion> map = this._versionMap;
        synchronized (map) {
            IVersion version = this._versionMap.get(versionString);
            if (version == null) {
                version = new Version(versionString);
                this._versionMap.put(versionString, version);
            }
            return version;
        }
    }

    @Override
    public boolean isVersionRange(String versionString) {
        return versionString != null && !versionString.trim().equals("") && versionString.trim().contains(",");
    }

    @Override
    public IVersionRange getVersionRange(String versionRangeString) throws NumberFormatException, IllegalArgumentException {
        if (!this.isVersionRange(versionRangeString)) {
            throw new IllegalArgumentException("Not a version range.");
        }
        String standardVersionRangString = this.standardizeRangeString(versionRangeString);
        IVersionRange range = this._versionRangeMap.get(standardVersionRangString);
        if (range == null) {
            int commaPos = standardVersionRangString.indexOf(",");
            boolean minInclusive = standardVersionRangString.substring(0, 1).equals("[");
            String min = standardVersionRangString.substring(1, commaPos);
            String max = standardVersionRangString.substring(commaPos + 1, standardVersionRangString.length() - 1);
            boolean maxInclusive = standardVersionRangString.substring(standardVersionRangString.length() - 1).equals("]");
            range = new VersionRange(this.getVersion(min), minInclusive, this.getVersion(max), maxInclusive);
            this._versionRangeMap.put(standardVersionRangString, range);
        }
        return range;
    }

    private String standardizeRangeString(String versionRangeString) {
        return versionRangeString.replace(" ", "");
    }

    public int getVersionMapSize() {
        return this._versionMap.size();
    }

    public int getVersionRangeMapSize() {
        return this._versionRangeMap.size();
    }
}

