/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.javatypes;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.appservices.IAppClassLoaderProvider;
import oracle.eclipse.tools.application.common.services.javatypes.FindDelta;
import oracle.eclipse.tools.application.common.services.javatypes.JavaDeltaVisitor;
import oracle.eclipse.tools.application.common.services.javatypes.ReflectionUtil;
import oracle.eclipse.tools.application.common.services.techextservices.IDataTypeIntrospector;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.IDataTypeChangeListener;
import oracle.eclipse.tools.application.common.services.variables.JavaDataType;
import oracle.eclipse.tools.application.common.services.variables.MethodInfo;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.util.ObjectUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;

public class JavaTypeIntrospector
implements IDataTypeIntrospector {
    private final Project _project;
    private final IElementChangedListener _javaTypeChangedListener;
    private static boolean mComputedGenericMethods;
    private static Method mGenericReturnTypeMethod;
    private static Method mGenericFieldTypeMethod;
    private Map<String, DataType> mCachedTypes;
    private final CopyOnWriteArrayList<DataTypeListener> _changeListeners = new CopyOnWriteArrayList();

    public JavaTypeIntrospector(Project project) {
        this._project = project;
        if (!mComputedGenericMethods) {
            mComputedGenericMethods = true;
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                mGenericReturnTypeMethod = ReflectionUtil.findMethod(cl, Method.class.getName(), "getGenericReturnType", null);
                mGenericFieldTypeMethod = ReflectionUtil.findMethod(cl, Field.class.getName(), "getGenericType", null);
            }
            catch (Exception exception) {
                mGenericFieldTypeMethod = null;
                mGenericReturnTypeMethod = null;
            }
        }
        this._javaTypeChangedListener = new JavaTypeChangeListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this._javaTypeChangedListener);
    }

    private DataType getDataType(String typeName_) {
        String typeName = typeName_;
        DataType dt = this.getCachedType(typeName);
        if (dt != null) {
            return dt;
        }
        if (typeName != null) {
            if ((typeName = JavaDataType.signatureToJniName(typeName)).equals("Exception")) {
                typeName = "java.lang.Exception";
            } else if (typeName.equals("Throwable")) {
                typeName = "java.lang.Throwable";
            }
        }
        dt = new JavaDataType(this, typeName, this._project);
        if (typeName == null || typeName.length() == 0) {
            dt.setUnknown();
        } else if (!this.checkArrayType(dt)) {
            dt.setLoaded(false);
        }
        return dt;
    }

    private boolean checkArrayType(DataType dt) {
        String typeName = dt.getName();
        int len = typeName.length();
        if (typeName.charAt(0) != '[') {
            return false;
        }
        String componentTypeName = null;
        if (typeName.charAt(len - 1) == ';') {
            if (len > 3 && typeName.charAt(1) == 'L') {
                componentTypeName = typeName.substring(2, len - 1);
            }
        } else if (len == 2) {
            switch (typeName.charAt(1)) {
                case 'Z': {
                    componentTypeName = "boolean";
                    break;
                }
                case 'B': {
                    componentTypeName = "byte";
                    break;
                }
                case 'C': {
                    componentTypeName = "char";
                    break;
                }
                case 'D': {
                    componentTypeName = "double";
                    break;
                }
                case 'F': {
                    componentTypeName = "float";
                    break;
                }
                case 'I': {
                    componentTypeName = "int";
                    break;
                }
                case 'J': {
                    componentTypeName = "long";
                    break;
                }
                case 'S': {
                    componentTypeName = "short";
                }
            }
        }
        if (componentTypeName == null) {
            return false;
        }
        dt.setArray(this.getDataType(componentTypeName));
        return true;
    }

    private PropertyDescriptor[] getClassPropertyDescriptors(Class typeClass, boolean inherit) {
        Class stopClass = this.getStopClass(typeClass, inherit);
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(typeClass, stopClass);
            return beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException introspectionException) {
            return new PropertyDescriptor[0];
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return new PropertyDescriptor[0];
        }
    }

    private PropertyDescriptor[] getInterfacePropertyDescriptors(Class typeClass, boolean inherit) {
        Class<?>[] interfaces = typeClass.getInterfaces();
        if (interfaces.length == 0 || !inherit) {
            return this.getClassPropertyDescriptors(typeClass, inherit);
        }
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i <= interfaces.length) {
            Class<?> interfaze = i != interfaces.length ? interfaces[i] : typeClass;
            PropertyDescriptor[] propsa = this.getClassPropertyDescriptors(interfaze, inherit);
            int j = 0;
            while (j < propsa.length) {
                PropertyDescriptor pd = propsa[j];
                if (!names.contains(pd.getName())) {
                    props.add(pd);
                    names.add(pd.getName());
                }
                ++j;
            }
            ++i;
        }
        return props.toArray(new PropertyDescriptor[props.size()]);
    }

    private void addDataTypeFields(DataType dt, PropertyDescriptor[] properties) {
        int count = properties.length;
        int i = 0;
        while (i < count) {
            IndexedPropertyDescriptor ipd;
            Class<Object> propClass = null;
            PropertyDescriptor pd = properties[i];
            Method readMethod = pd.getReadMethod();
            if (readMethod != null) {
                propClass = pd.getPropertyType();
            } else if (pd instanceof IndexedPropertyDescriptor && (readMethod = (ipd = (IndexedPropertyDescriptor)pd).getIndexedReadMethod()) != null) {
                propClass = Object.class;
            }
            if (propClass != null) {
                DataType genericsComponentType = null;
                if (mGenericReturnTypeMethod != null && JavaDataType.isEnumerableClass(propClass)) {
                    if (readMethod != null) {
                        genericsComponentType = this.getGenericsComponentType(readMethod);
                    } else if (pd instanceof FieldDescriptor) {
                        genericsComponentType = this.getGenericsComponentType(((FieldDescriptor)pd).getField());
                    }
                }
                DataType fieldType = this.getDataType(propClass.getName());
                if (genericsComponentType instanceof JavaDataType) {
                    ((JavaDataType)fieldType).associateClass(propClass, genericsComponentType);
                }
                Method writeMethod = pd.getWriteMethod();
                JavaDataType.JavaField field = new JavaDataType.JavaField(pd.getName(), fieldType, readMethod != null ? readMethod.getName() : null, writeMethod == null ? null : writeMethod.getName());
                if (readMethod != null) {
                    field.setInherited(!readMethod.getDeclaringClass().getName().equals(dt.getName()));
                } else {
                    field.setInherited(!((FieldDescriptor)pd).getField().getDeclaringClass().getName().equals(dt.getName()));
                }
                dt.addField(field);
            }
            ++i;
        }
    }

    private DataType getGenericsComponentType(Method readMethod) {
        try {
            Object t = mGenericReturnTypeMethod.invoke((Object)readMethod, null);
            if (t != null) {
                return this.getGenericsComponentType(t.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private DataType getGenericsComponentType(Field field) {
        try {
            Object t = mGenericFieldTypeMethod.invoke((Object)field, null);
            if (t != null) {
                return this.getGenericsComponentType(t.toString());
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private DataType getGenericsComponentType(String s) {
        String typeName = this.getGenericsComponentTypeName(s);
        return typeName != null ? this.getDataType(typeName) : null;
    }

    private String getGenericsComponentTypeName(String s) {
        int i1 = s.indexOf(60);
        if (i1 < 0) {
            return null;
        }
        int i2 = s.indexOf(62, i1);
        if (i2 < 0) {
            return null;
        }
        String typeName = s.substring(i1 + 1, i2);
        if (typeName.indexOf(44) >= 0) {
            return null;
        }
        return typeName;
    }

    private Class loadClass(String typeName) {
        IAppClassLoaderProvider.IClassLoader appClassLoader = null;
        ClassLoader classLoader = null;
        IAppClassLoaderProvider ext = (IAppClassLoaderProvider)this._project.getAppService(IAppClassLoaderProvider.class);
        if (ext != null) {
            appClassLoader = ext.getAppClassLoader();
            classLoader = appClassLoader.getClassLoader();
        } else {
            IJavaProject jp = JavaCore.create((IProject)this._project.getEclipseProject());
            if (jp != null) {
                classLoader = jp.getClass().getClassLoader();
            }
        }
        if (classLoader == null) {
            return null;
        }
        try {
            Class<?> clazz = classLoader.loadClass(typeName);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            int dotIndex;
            if (typeName.indexOf(36) < 0 && (dotIndex = typeName.lastIndexOf(46)) > 0) {
                Class clazz = this.loadClass(String.valueOf(typeName.substring(0, dotIndex)) + '$' + typeName.substring(dotIndex + 1));
                return clazz;
            }
        }
        catch (Throwable ex2) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)ex2);
        }
        finally {
            if (appClassLoader != null) {
                appClassLoader.close();
            }
        }
        return null;
    }

    private synchronized DataType getCachedType(String typeName) {
        if (this.mCachedTypes == null) {
            this.mCachedTypes = new HashMap<String, DataType>(28);
            String s = Integer.TYPE.getName();
            this.mCachedTypes.put(s, new JavaDataType(s, this._project));
            s = Boolean.TYPE.getName();
            this.mCachedTypes.put(s, new JavaDataType(s, this._project));
            s = Character.TYPE.getName();
            this.mCachedTypes.put(s, new JavaDataType(s, this._project));
            s = Float.TYPE.getName();
            this.mCachedTypes.put(s, new JavaDataType(s, this._project));
            s = Double.TYPE.getName();
            this.mCachedTypes.put(s, new JavaDataType(s, this._project));
            s = Byte.TYPE.getName();
            this.mCachedTypes.put(s, new JavaDataType(s, this._project));
            s = Short.TYPE.getName();
            this.mCachedTypes.put(s, new JavaDataType(s, this._project));
            s = Long.TYPE.getName();
            this.mCachedTypes.put(s, new JavaDataType(s, this._project));
            this.cacheLangType("Integer");
            this.cacheLangType("Boolean");
            this.cacheLangType("Character");
            this.cacheLangType("Float");
            this.cacheLangType("Double");
            this.cacheLangType("Byte");
            this.cacheLangType("Short");
            this.cacheLangType("Long");
            this.cacheLangType("Number");
            this.cacheLangType("String");
            this.cacheLangType("StringBuffer");
            this.cacheLangType("Object");
        }
        return this.mCachedTypes.get(typeName);
    }

    private DataType cacheLangType(String typeName) {
        String fullName = "java.lang." + typeName;
        JavaDataType dt = new JavaDataType(fullName, this._project);
        this.mCachedTypes.put(fullName, dt);
        this.mCachedTypes.put(typeName, dt);
        return dt;
    }

    private Class getStopClass(Class c, boolean inherit) {
        if (c.isInterface()) {
            return null;
        }
        if (!inherit) {
            return c.getSuperclass();
        }
        return Object.class;
    }

    @Override
    public DataType introspect(String typeName, Set<String> importedTypeNames) {
        String realTypeName;
        DataType realType;
        if (typeName == null || typeName.length() == 0) {
            return DataType.getUnspecifiedType();
        }
        String gTypeName = this.getGenericsComponentTypeName(typeName);
        if (gTypeName != null && (realType = this.introspect(realTypeName = typeName.substring(0, typeName.indexOf(60)), importedTypeNames)) != null) {
            if (realType.isEnumerable()) {
                realType.setEnumerable(this.introspect(gTypeName, importedTypeNames));
            }
            return realType;
        }
        DataType type = this.getDataType(typeName);
        if (importedTypeNames == null || typeName.indexOf(46) >= 0 || !type.isUnknown()) {
            return type;
        }
        String dotTypeName = "." + typeName;
        for (String importedName : importedTypeNames) {
            if (importedName.endsWith(".*")) {
                type = this.getDataType(String.valueOf(ObjectUtil.getPackageName((String)importedName)) + dotTypeName);
                if (type.isUnknown()) continue;
                return type;
            }
            if (!importedName.endsWith(dotTypeName)) continue;
            return this.getDataType(importedName);
        }
        return type;
    }

    @Override
    public DataType introspect(String typeName, Set<String> importedTypeNames, Map additionalFields) {
        return this.introspect(typeName, importedTypeNames);
    }

    @Override
    public void load(DataType dt, boolean inherit) {
        Class typeClass = this.loadClass(dt.getName());
        if (typeClass == null) {
            dt.setUnknown();
            return;
        }
        if (dt instanceof JavaDataType) {
            ((JavaDataType)dt).associateClass(typeClass, null);
        }
        if (!typeClass.isArray()) {
            PropertyDescriptor[] pds = null;
            pds = typeClass.isInterface() && !dt.getName().startsWith("java.") ? this.getInterfacePropertyDescriptors(typeClass, inherit) : this.getClassPropertyDescriptors(typeClass, inherit);
            if (pds != null) {
                this.addDataTypeFields(dt, pds);
            }
        }
    }

    @Override
    public List<MethodInfo> getPublicMethods(DataType dt) {
        Class typeClass = this.loadClass(dt.getName());
        if (typeClass != null) {
            ArrayList<MethodInfo> publicMethods = new ArrayList<MethodInfo>();
            try {
                Method[] methods;
                Method[] methodArray = methods = typeClass.getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (method.getModifiers() > 0) {
                        publicMethods.add(new MethodInfo(this, method));
                    }
                    ++n2;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
            return publicMethods;
        }
        return Collections.emptyList();
    }

    public void dispose() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this._javaTypeChangedListener);
        if (this._changeListeners != null) {
            this._changeListeners.clear();
        }
        if (this.mCachedTypes != null) {
            this.mCachedTypes.clear();
        }
    }

    @Override
    public void addChangeListener(IDataTypeChangeListener listener, String typeName) {
        this._changeListeners.addIfAbsent(new DataTypeListener(listener, typeName));
    }

    @Override
    public void removeChangeListener(IDataTypeChangeListener listener, String typeName) {
        this._changeListeners.remove(new DataTypeListener(listener, typeName));
    }

    @Override
    public void removeAllChangeListeners(IDataTypeChangeListener listener) {
        ArrayList<DataTypeListener> tempList = new ArrayList<DataTypeListener>();
        for (DataTypeListener outerListener : this._changeListeners) {
            if (!outerListener.getListener().equals(listener)) continue;
            tempList.add(outerListener);
        }
        if (tempList.size() == 1) {
            this._changeListeners.remove(tempList.get(0));
        } else if (tempList.size() > 1) {
            this._changeListeners.removeAll(tempList);
        }
    }

    private void fireChange(final IDataTypeChangeListener.DataTypeChangeEvent event) {
        WorkspaceJob job = new WorkspaceJob(""){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                String className = event.getTypeName();
                for (DataTypeListener listener : JavaTypeIntrospector.this._changeListeners) {
                    String typeName = listener.getDataType();
                    if (!className.equals(typeName)) continue;
                    listener.getListener().typeChanged(event);
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)this._project.getEclipseProject().getWorkspace().getRoot());
        job.schedule();
    }

    private static final class DataTypeListener {
        private final IDataTypeChangeListener _listener;
        private final String _typeName;

        public DataTypeListener(IDataTypeChangeListener listener, String typeName) {
            this._listener = listener;
            this._typeName = typeName;
        }

        public final IDataTypeChangeListener getListener() {
            return this._listener;
        }

        public final String getDataType() {
            return this._typeName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DataTypeListener)) {
                return false;
            }
            return ((DataTypeListener)obj)._listener.equals(this._listener) && ((DataTypeListener)obj)._typeName.equals(this._typeName);
        }

        public int hashCode() {
            return this._listener.hashCode() ^ this._typeName.hashCode();
        }
    }

    private static class FieldDescriptor
    extends PropertyDescriptor {
        private final Field mField;

        public FieldDescriptor(Field field) throws IntrospectionException {
            super(field.getName(), null, null);
            this.mField = field;
        }

        public Field getField() {
            return this.mField;
        }

        public synchronized Class getPropertyType() {
            return this.mField.getType();
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof FieldDescriptor && super.equals(other)) {
                FieldDescriptor otherFieldDescriptor = (FieldDescriptor)other;
                Field field = this.getField();
                Field otherField = otherFieldDescriptor.getField();
                return field == null ? otherField == null : field.equals(otherField);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            Field field = this.getField();
            result = 37 * result + (field == null ? 0 : field.hashCode());
            return result;
        }
    }

    private final class JavaTypeChangeListener
    implements IElementChangedListener {
        private JavaTypeChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            int type = event.getType();
            if (type == 1) {
                IJavaElementDelta delta = event.getDelta();
                FindDelta findDelta = new FindDelta(){

                    @Override
                    protected boolean matches(IJavaElementDelta delta) {
                        ICompilationUnit compUnit;
                        return delta.getKind() == 4 && (delta.getFlags() & 0x40000) != 0 && (compUnit = (ICompilationUnit)delta.getElement()).getJavaProject().getProject() == JavaTypeIntrospector.this._project.getEclipseProject();
                    }
                };
                findDelta.accept(delta, JavaDeltaVisitor.VisitOrder.PREORDER);
                for (IJavaElementDelta changeDelta : findDelta.getDeltas()) {
                    ICompilationUnit element = (ICompilationUnit)changeDelta.getElement();
                    IType findPrimaryType = element.findPrimaryType();
                    if (findPrimaryType == null) continue;
                    String className = findPrimaryType.getFullyQualifiedName();
                    JavaTypeIntrospector.this.fireChange(new IDataTypeChangeListener.DataTypeChangeEvent(className, this));
                }
            }
        }
    }
}

