/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.javatypes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.TraceOptions;
import oracle.eclipse.tools.application.common.services.javatypes.JavaDeltaVisitor;
import oracle.eclipse.tools.application.common.services.techextservices.IDataTypeIntrospector;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.IDataTypeChangeListener;
import oracle.eclipse.tools.application.common.services.variables.JDTDataType;
import oracle.eclipse.tools.application.common.services.variables.MethodInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class JDTDataTypeIntrospector
implements IDataTypeIntrospector {
    private static final String WILDCARD_START = "?";
    private static final String OBJECT_TYPE = "java.lang.Object";
    private static final String STAR = Character.toString('*');
    private static final String EXTENDS = Character.toString('+');
    private static final String SUPER = Character.toString('-');
    private final IJavaProject jProject;
    private final IElementChangedListener _javaTypeChangedListener;
    private Map<String, IType> mCachedTypes = new HashMap<String, IType>(34, 1.0f);
    private final CopyOnWriteArrayList<DataTypeListener> _changeListeners = new CopyOnWriteArrayList();

    public JDTDataTypeIntrospector(IProject project) {
        this.jProject = JavaCore.create((IProject)project);
        this._javaTypeChangedListener = new JavaTypeChangeListener(project);
        JavaCore.addElementChangedListener((IElementChangedListener)this._javaTypeChangedListener);
    }

    @Override
    public DataType introspect(String typeName, Set<String> importedTypeNames) {
        return this.introspect(typeName, importedTypeNames, Collections.EMPTY_MAP);
    }

    @Override
    public DataType introspect(String typeName, Set<String> importedTypeNames, Map additionalProps) {
        if (typeName == null || typeName.length() == 0) {
            return DataType.getUnspecifiedType();
        }
        String typeSignature = Signature.createTypeSignature((String)typeName, (boolean)false);
        int arrayCount = Signature.getArrayCount((String)typeSignature);
        String normalizedTypeName = arrayCount == 0 ? typeName : Signature.toString((String)Signature.getElementType((String)typeSignature));
        try {
            DataType rawMapType;
            if (JDTDataType.isPrimitive(normalizedTypeName)) {
                JDTDataType jType = JDTDataType.instanceForPrimitive(this, normalizedTypeName, arrayCount, this.jProject);
                return jType != null ? jType : DataType.getUnspecifiedType();
            }
            String[] typeParamters = Signature.getTypeArguments((String)typeSignature);
            DataType componentType = null;
            if (typeParamters.length > 0) {
                DataType mapType;
                normalizedTypeName = Signature.toString((String)Signature.getTypeErasure((String)Signature.getElementType((String)typeSignature)));
                if (this.isMap(normalizedTypeName, typeParamters, importedTypeNames) && (mapType = this.introspectMap(normalizedTypeName, importedTypeNames, typeParamters, arrayCount, additionalProps)) != null) {
                    return mapType;
                }
                componentType = this.introspect(Signature.toString((String)typeParamters[0]), importedTypeNames);
            }
            if (this.isRawMap(normalizedTypeName, importedTypeNames) && (rawMapType = this.introspectRawMap(normalizedTypeName, importedTypeNames, arrayCount, additionalProps)) != null) {
                return rawMapType;
            }
            IType type = this.getJDTType(normalizedTypeName, importedTypeNames);
            if (type != null) {
                JDTDataType jType = JDTDataType.instanceFor(this, type, componentType, arrayCount);
                return jType != null ? jType : DataType.getUnspecifiedType();
            }
            if (this.isWildcard(normalizedTypeName)) {
                String wildcardTypeName = normalizedTypeName;
                IType wildcardType = this.getJDTWildcardType(normalizedTypeName, importedTypeNames);
                if (wildcardType != null) {
                    JDTDataType jType = JDTDataType.instanceForWildcard(this, wildcardType, this.normalizeWildcardType(wildcardTypeName, importedTypeNames), componentType, arrayCount);
                    return jType != null ? jType : DataType.getUnspecifiedType();
                }
            }
            return JDTDataType.instanceFor(this, normalizedTypeName, null, this.jProject.getProject(), arrayCount);
        }
        catch (JavaModelException javaModelException) {
            return JDTDataType.instanceFor(this, typeName, null, this.jProject.getProject(), arrayCount);
        }
    }

    private boolean isMap(String normalizedTypeName, String[] typeParameters, Set<String> importedTypeNames) throws JavaModelException {
        if (typeParameters.length != 2) {
            return false;
        }
        return this.isMap(normalizedTypeName, importedTypeNames, new LinkedHashSet<String>());
    }

    private boolean isRawMap(String normalizedTypeName, Set<String> importedTypeNames) throws JavaModelException {
        return this.isMap(normalizedTypeName, importedTypeNames, new LinkedHashSet<String>());
    }

    private boolean isMap(String normalizedTypeName, Set<String> importedTypeNames, Set<String> normalizedTypeNames) throws JavaModelException {
        if ("java.util.Map".equals(normalizedTypeName)) {
            return true;
        }
        if (OBJECT_TYPE.equals(normalizedTypeName)) {
            return false;
        }
        if (normalizedTypeNames.contains(normalizedTypeName)) {
            if (TraceOptions.APPXRAY_JDT_INTROSPECTOR) {
                Activator.log(1, "Duplicate class/interface found when checking if it's a Map. '" + normalizedTypeName + "' Skipping processing this class again.' Hierarchy: " + normalizedTypeNames);
            }
            return false;
        }
        if (normalizedTypeNames.size() > 300) {
            Activator.log(4, "Error in determing if a given class/interface is a Map. Returning early to prevent stack overflow problem. Hierarchy: " + normalizedTypeNames);
            return false;
        }
        normalizedTypeNames.add(normalizedTypeName);
        IType type = this.getJDTType(normalizedTypeName, importedTypeNames);
        if (type != null) {
            String[] stringArray = type.getSuperInterfaceNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String superInterface = stringArray[n2];
                if (this.isMap(superInterface, importedTypeNames, normalizedTypeNames)) {
                    return true;
                }
                ++n2;
            }
            String superClass = type.getSuperclassName();
            if (superClass != null && this.isMap(superClass, importedTypeNames, normalizedTypeNames)) {
                return true;
            }
        }
        return false;
    }

    private DataType introspectRawMap(String normalizedTypeName, Set<String> importedTypeNames, int arrayDimension, Map additionalProps) throws JavaModelException {
        IType type = this.getJDTType(normalizedTypeName, importedTypeNames);
        if (type == null) {
            return null;
        }
        return JDTDataType.instanceForMap(this, type, null, null, arrayDimension, additionalProps);
    }

    private DataType introspectMap(String normalizedTypeName, Set<String> importedTypeNames, String[] typeParameters, int arrayDimension, Map additionalProps) throws JavaModelException {
        IType type = this.getJDTType(normalizedTypeName, importedTypeNames);
        if (type == null) {
            return null;
        }
        DataType keyType = this.introspect(Signature.toString((String)typeParameters[0]), importedTypeNames);
        DataType valueType = this.introspect(Signature.toString((String)typeParameters[1]), importedTypeNames);
        return JDTDataType.instanceForMap(this, type, keyType, valueType, arrayDimension, additionalProps);
    }

    private boolean isWildcard(String normalizedTypeName) {
        return normalizedTypeName.startsWith(WILDCARD_START);
    }

    private IType getJDTWildcardType(String normalizedTypeName, Set<String> importedTypeNames) throws JavaModelException {
        String typeSignature = Signature.createTypeSignature((String)normalizedTypeName, (boolean)false);
        if (typeSignature.startsWith(STAR)) {
            return this.getJDTType(OBJECT_TYPE, importedTypeNames);
        }
        if (typeSignature.startsWith(EXTENDS) || typeSignature.startsWith(SUPER)) {
            String simpleTypeSig = typeSignature.substring(1);
            String simpleNormalizedTypeName = Signature.toString((String)Signature.getElementType((String)simpleTypeSig));
            return this.getJDTType(simpleNormalizedTypeName, importedTypeNames);
        }
        return null;
    }

    private String normalizeWildcardType(String typeName, Set<String> importedTypeNames) throws JavaModelException {
        String typeSignature = Signature.createTypeSignature((String)typeName, (boolean)false);
        if (typeSignature.startsWith(STAR)) {
            return WILDCARD_START;
        }
        if (typeSignature.startsWith(EXTENDS) || typeSignature.startsWith(SUPER)) {
            String simpleTypeSig = typeSignature.substring(1);
            String simpleNormalizedTypeName = Signature.toString((String)Signature.getElementType((String)simpleTypeSig));
            IType jdtType = this.getJDTType(simpleNormalizedTypeName, importedTypeNames);
            if (jdtType == null) {
                return typeName;
            }
            return typeSignature.startsWith(EXTENDS) ? "? extends " + jdtType.getFullyQualifiedName() : "? super " + jdtType.getFullyQualifiedName();
        }
        return typeName;
    }

    @Override
    public void load(DataType dt, boolean inherit) {
    }

    @Override
    public List<MethodInfo> getPublicMethods(DataType dt) {
        if (dt instanceof JDTDataType) {
            return dt.getPublicMethods();
        }
        return Collections.emptyList();
    }

    public void dispose() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this._javaTypeChangedListener);
        if (this._changeListeners != null) {
            this._changeListeners.clear();
        }
        this.mCachedTypes.clear();
    }

    @Override
    public void addChangeListener(IDataTypeChangeListener listener, String typeName) {
        this._changeListeners.addIfAbsent(new DataTypeListener(listener, typeName));
    }

    @Override
    public void removeChangeListener(IDataTypeChangeListener listener, String typeName) {
        this._changeListeners.remove(new DataTypeListener(listener, typeName));
    }

    @Override
    public void removeAllChangeListeners(IDataTypeChangeListener listener) {
        ArrayList<DataTypeListener> tempList = new ArrayList<DataTypeListener>();
        for (DataTypeListener outerListener : this._changeListeners) {
            if (!outerListener.getListener().equals(listener)) continue;
            tempList.add(outerListener);
        }
        if (tempList.size() == 1) {
            this._changeListeners.remove(tempList.get(0));
        } else if (tempList.size() > 1) {
            this._changeListeners.removeAll(tempList);
        }
    }

    private IType getJDTType(String typeName, Set<String> imports) throws JavaModelException {
        IType cachedType = this.getCachedType(typeName);
        if (cachedType != null) {
            return cachedType;
        }
        IType asIsType = this.getJDTType(typeName);
        if (asIsType != null && asIsType.exists()) {
            return asIsType;
        }
        if (imports != null && !imports.isEmpty()) {
            HashSet<String> wildCardImports = new HashSet<String>(imports.size(), 1.0f);
            for (String importedType : imports) {
                if (importedType.endsWith("*")) {
                    wildCardImports.add(importedType);
                    continue;
                }
                if (!importedType.endsWith(typeName)) continue;
                return this.getJDTType(importedType);
            }
            for (String wildCardImport : wildCardImports) {
                StringBuffer possibleQualifiedName = new StringBuffer(wildCardImport);
                possibleQualifiedName.deleteCharAt(possibleQualifiedName.length() - 1);
                possibleQualifiedName.append('.');
                possibleQualifiedName.append(typeName);
                IType possibleType = this.getJDTType(possibleQualifiedName.toString());
                if (possibleType == null || !possibleType.exists()) continue;
                return possibleType;
            }
        }
        if ("Exception".equals(typeName)) {
            return this.getJDTType("java.lang.Exception");
        }
        if ("Throwable".equals(typeName)) {
            return this.getJDTType("java.lang.Throwable");
        }
        return asIsType;
    }

    private IType getJDTType(String fullyQualifiedName) throws JavaModelException {
        return this.jProject.findType(fullyQualifiedName, (IProgressMonitor)new NullProgressMonitor());
    }

    private synchronized IType getCachedType(String typeName) throws JavaModelException {
        if (this.mCachedTypes.isEmpty()) {
            String cacheTypeName = Integer.TYPE.getName();
            this.mCachedTypes.put(cacheTypeName, this.jProject.findType(cacheTypeName));
            cacheTypeName = Boolean.TYPE.getName();
            this.mCachedTypes.put(cacheTypeName, this.jProject.findType(cacheTypeName));
            cacheTypeName = Character.TYPE.getName();
            this.mCachedTypes.put(cacheTypeName, this.jProject.findType(cacheTypeName));
            cacheTypeName = Float.TYPE.getName();
            this.mCachedTypes.put(cacheTypeName, this.jProject.findType(cacheTypeName));
            cacheTypeName = Double.TYPE.getName();
            this.mCachedTypes.put(cacheTypeName, this.jProject.findType(cacheTypeName));
            cacheTypeName = Byte.TYPE.getName();
            this.mCachedTypes.put(cacheTypeName, this.jProject.findType(cacheTypeName));
            cacheTypeName = Short.TYPE.getName();
            this.mCachedTypes.put(cacheTypeName, this.jProject.findType(cacheTypeName));
            cacheTypeName = Long.TYPE.getName();
            this.mCachedTypes.put(cacheTypeName, this.jProject.findType(cacheTypeName));
            cacheTypeName = Void.TYPE.getName();
            this.mCachedTypes.put(cacheTypeName, this.jProject.findType(Void.class.getName()));
            this.cacheLangType("Integer");
            this.cacheLangType("Boolean");
            this.cacheLangType("Character");
            this.cacheLangType("Float");
            this.cacheLangType("Double");
            this.cacheLangType("Byte");
            this.cacheLangType("Short");
            this.cacheLangType("Long");
            this.cacheLangType("Number");
            this.cacheLangType("String");
            this.cacheLangType("StringBuffer");
            this.cacheLangType("Object");
        }
        return this.mCachedTypes.get(typeName);
    }

    private IType cacheLangType(String typeName) throws JavaModelException {
        String fullName = "java.lang." + typeName;
        IType type = this.jProject.findType(fullName);
        this.mCachedTypes.put(fullName, type);
        this.mCachedTypes.put(typeName, type);
        return type;
    }

    private void fireChange(IDataTypeChangeListener.DataTypeChangeEvent event) {
        String className = event.getTypeName();
        for (DataTypeListener listener : this._changeListeners) {
            String typeName = listener.getDataType();
            if (!className.equals(typeName)) continue;
            listener.getListener().typeChanged(event);
        }
    }

    private static final class DataTypeListener {
        private final IDataTypeChangeListener _listener;
        private final String _typeName;

        public DataTypeListener(IDataTypeChangeListener listener, String typeName) {
            this._listener = listener;
            this._typeName = typeName;
        }

        public final IDataTypeChangeListener getListener() {
            return this._listener;
        }

        public final String getDataType() {
            return this._typeName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DataTypeListener)) {
                return false;
            }
            return ((DataTypeListener)obj)._listener.equals(this._listener) && ((DataTypeListener)obj)._typeName.equals(this._typeName);
        }

        public int hashCode() {
            return this._listener.hashCode() ^ this._typeName.hashCode();
        }
    }

    protected static abstract class FindDelta
    extends JavaDeltaVisitor {
        final List<IJavaElementDelta> _deltas = new ArrayList<IJavaElementDelta>();

        protected FindDelta() {
        }

        @Override
        protected boolean visit(IJavaElementDelta delta) {
            if (this.matches(delta)) {
                this._deltas.add(delta);
            }
            return true;
        }

        public List<IJavaElementDelta> getDeltas() {
            return Collections.unmodifiableList(this._deltas);
        }

        protected abstract boolean matches(IJavaElementDelta var1);
    }

    private final class JavaTypeChangeListener
    implements IElementChangedListener {
        private final IProject project;

        JavaTypeChangeListener(IProject project) {
            this.project = project;
        }

        public void elementChanged(ElementChangedEvent event) {
            int type = event.getType();
            if (type == 1) {
                IJavaElementDelta delta = event.getDelta();
                FindDelta findDelta = new FindDelta(){

                    @Override
                    protected boolean matches(IJavaElementDelta jeDelta) {
                        ICompilationUnit compUnit;
                        return jeDelta.getKind() == 4 && (jeDelta.getFlags() & 0x40000) != 0 && (compUnit = (ICompilationUnit)jeDelta.getElement()).getJavaProject().getProject() == JavaTypeChangeListener.this.project;
                    }
                };
                findDelta.accept(delta, JavaDeltaVisitor.VisitOrder.PREORDER);
                for (IJavaElementDelta changeDelta : findDelta.getDeltas()) {
                    ICompilationUnit element = (ICompilationUnit)changeDelta.getElement();
                    IType findPrimaryType = element.findPrimaryType();
                    if (findPrimaryType == null) continue;
                    String className = findPrimaryType.getFullyQualifiedName();
                    JDTDataTypeIntrospector.this.fireChange(new IDataTypeChangeListener.DataTypeChangeEvent(className, this));
                }
            }
        }
    }
}

