/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.el;

import de.odysseus.el.tree.Node;
import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.impl.TreeVisitor;
import de.odysseus.el.tree.impl.ast.AstBinary;
import de.odysseus.el.tree.impl.ast.AstBoolean;
import de.odysseus.el.tree.impl.ast.AstBracket;
import de.odysseus.el.tree.impl.ast.AstChoice;
import de.odysseus.el.tree.impl.ast.AstDot;
import de.odysseus.el.tree.impl.ast.AstFunction;
import de.odysseus.el.tree.impl.ast.AstIdentifier;
import de.odysseus.el.tree.impl.ast.AstMethod;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstNull;
import de.odysseus.el.tree.impl.ast.AstNumber;
import de.odysseus.el.tree.impl.ast.AstParameters;
import de.odysseus.el.tree.impl.ast.AstString;
import de.odysseus.el.tree.impl.ast.AstText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.ELExpression;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceELParser;

public class ValueReferenceELExprCacheEntry {
    private List<ValueReferenceELParser.ValueReferenceELExpr> valueRefs;
    private Boolean simpleElExpr;
    private String rawElText;
    private ELExpression.EscapeType escapeType;
    private boolean initialized;

    public List<ValueReferenceELParser.ValueReferenceELExpr> getValueRefs() {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        return Collections.unmodifiableList(this.valueRefs);
    }

    public boolean isSimpleElExpr() {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        return this.simpleElExpr;
    }

    public String getRawElText() {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        return this.rawElText;
    }

    public ELExpression.EscapeType getEscapeType() {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
        return this.escapeType;
    }

    public void initialize(Tree tree) {
        if (!this.initialized) {
            if (tree != null) {
                this.doVisiting(tree);
            } else {
                this.valueRefs = Collections.emptyList();
                this.initialized = true;
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void doVisiting(Tree tree) {
        ValRefELVisitor visitor = new ValRefELVisitor();
        visitor.accept(tree);
        this.valueRefs = visitor.getValueRefExprs();
        this.simpleElExpr = visitor.isSimpleElExpr();
        this.rawElText = visitor.getElText();
        this.escapeType = visitor.getEscapeType();
        this.initialized = true;
    }

    private static class ValRefELVisitor
    extends TreeVisitor {
        private final List<ValueReferenceELParser.ValueReferenceELExpr> _valueRefExprs = new ArrayList<ValueReferenceELParser.ValueReferenceELExpr>(2){
            private static final long serialVersionUID = 467566887372648196L;

            @Override
            public void add(int index, ValueReferenceELParser.ValueReferenceELExpr element) {
                if (element == null) {
                    throw new NullPointerException("element cannot be null");
                }
                super.add(index, element);
            }

            @Override
            public boolean add(ValueReferenceELParser.ValueReferenceELExpr element) {
                if (element == null) {
                    throw new NullPointerException("element cannot be null");
                }
                return super.add(element);
            }
        };
        private ValueReferenceELParser.ValueReferenceELExpr _curValueRefExpr;
        private boolean _isSimpleElExpr = true;
        private boolean _isInsideBracket;
        private ELExpression.EscapeType escapeType;
        private String elText;

        public void accept(Tree tree) {
            super.accept(tree);
            this.escapeType = tree.isDeferred() ? ELExpression.EscapeType.HASH_SIGN : ELExpression.EscapeType.DOLLAR_SIGN;
            Node child = tree.getRoot().getChild(0);
            if (child instanceof AstNode) {
                StringBuilder builder = new StringBuilder();
                ((AstNode)child).appendStructure(builder, null);
                this.elText = builder.toString();
            }
        }

        protected void endVisitIdentifier(AstIdentifier node) {
            this._curValueRefExpr = new ValueReferenceELParser.ValueReferenceELExpr(node.getName());
            this._valueRefExprs.add(this._curValueRefExpr);
        }

        protected void endVisitDot(AstDot node) {
            if (this._curValueRefExpr == null) {
                this._curValueRefExpr = new ValueReferenceELParser.ValueReferenceELExpr();
                this._valueRefExprs.add(this._curValueRefExpr);
            }
            this._curValueRefExpr.addPropertyObjectName(node.getPropertyValue());
        }

        protected boolean visitString(AstString node) {
            if (this._isInsideBracket) {
                if (this._curValueRefExpr == null) {
                    this._curValueRefExpr = new ValueReferenceELParser.ValueReferenceELExpr();
                }
                this._curValueRefExpr.addPropertyObjectName(this.stripQuotes(node.getValue()));
            } else {
                this._isSimpleElExpr = false;
            }
            return false;
        }

        protected boolean visitBracket(AstBracket node) {
            this._isInsideBracket = true;
            return true;
        }

        protected void endVisitBracket(AstBracket node) {
            this._isInsideBracket = false;
        }

        protected boolean visitChoice(AstChoice node) {
            this._isSimpleElExpr = false;
            return true;
        }

        protected boolean visitBoolean(AstBoolean node) {
            this._isSimpleElExpr = false;
            return true;
        }

        protected boolean visitMethod(AstMethod node) {
            this._isSimpleElExpr = false;
            return true;
        }

        protected boolean visitBinary(AstBinary node) {
            this._isSimpleElExpr = false;
            return true;
        }

        protected boolean visitOtherNode(Node node) {
            this._isSimpleElExpr = false;
            return false;
        }

        protected boolean visitText(AstText node) {
            this._isSimpleElExpr = false;
            return false;
        }

        protected boolean visitParameters(AstParameters node) {
            this._isSimpleElExpr = false;
            return false;
        }

        protected boolean visitNumber(AstNumber node) {
            this._isSimpleElExpr = false;
            return false;
        }

        protected boolean visitNull(AstNull node) {
            this._isSimpleElExpr = false;
            return false;
        }

        protected boolean visitFunction(AstFunction node) {
            this._isSimpleElExpr = false;
            return true;
        }

        protected final boolean isSimpleElExpr() {
            return this._isSimpleElExpr;
        }

        public List<ValueReferenceELParser.ValueReferenceELExpr> getValueRefExprs() {
            if (this._valueRefExprs.isEmpty()) {
                return Collections.emptyList();
            }
            return this._valueRefExprs;
        }

        public ELExpression.EscapeType getEscapeType() {
            return this.escapeType;
        }

        public String getElText() {
            return this.elText;
        }

        private String stripQuotes(String stringLiteral) {
            if (stringLiteral.startsWith("'") || stringLiteral.startsWith("\"")) {
                if (stringLiteral.length() > 2) {
                    return stringLiteral.substring(1, stringLiteral.length() - 1);
                }
                return "";
            }
            return stringLiteral;
        }
    }
}

