/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.el;

import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.TreeBuilder;
import de.odysseus.el.tree.TreeBuilderException;
import de.odysseus.el.tree.impl.Builder;
import java.util.List;
import oracle.eclipse.tools.application.common.services.el.ASTTreeCacheEntry;
import oracle.eclipse.tools.application.common.services.el.ValueReferenceELExprCacheEntry;
import oracle.eclipse.tools.application.common.services.variables.ELExpression;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceELParser;
import oracle.eclipse.tools.common.util.LRUCache;

public class ELExpressionLRUCache {
    private final Builder treeBuilder;
    private LRUCache<String, ValueReferenceELExprCacheEntry> valueRefCache;
    private LRUCache<String, ASTTreeCacheEntry> treeCache;
    public static final ELExpressionLRUCache INSTANCE = new ELExpressionLRUCache(64, new Builder());

    public ELExpressionLRUCache(int cacheSize, Builder builder) {
        this.treeCache = new ELLRUCache<String, ASTTreeCacheEntry>(cacheSize);
        this.valueRefCache = new ELLRUCache<String, ValueReferenceELExprCacheEntry>(cacheSize * 2);
        this.treeBuilder = builder;
    }

    public synchronized Tree getAstTree(String elText) {
        ASTTreeCacheEntry entry = (ASTTreeCacheEntry)this.treeCache.get((Object)elText);
        if (entry == null) {
            entry = new ASTTreeCacheEntry(elText);
            this.treeCache.put((Object)elText, (Object)entry);
        }
        return entry.getAstTree((TreeBuilder)this.treeBuilder);
    }

    public synchronized TreeBuilderException getExpressionError(String elText) {
        ASTTreeCacheEntry entry = (ASTTreeCacheEntry)this.treeCache.get((Object)elText);
        if (entry == null) {
            entry = new ASTTreeCacheEntry(elText);
            this.treeCache.put((Object)elText, (Object)entry);
        }
        return entry.getError((TreeBuilder)this.treeBuilder);
    }

    public synchronized List<ValueReferenceELParser.ValueReferenceELExpr> getValueRefs(String elText) {
        ValueReferenceELExprCacheEntry entry = (ValueReferenceELExprCacheEntry)this.valueRefCache.get((Object)elText);
        if (entry == null) {
            entry = new ValueReferenceELExprCacheEntry();
            this.valueRefCache.put((Object)elText, (Object)entry);
        }
        if (!entry.isInitialized()) {
            Tree tree = this.getAstTree(elText);
            entry.initialize(tree);
        }
        return entry.getValueRefs();
    }

    public synchronized boolean isSimpleElExpr(String elText) {
        ValueReferenceELExprCacheEntry entry = (ValueReferenceELExprCacheEntry)this.valueRefCache.get((Object)elText);
        if (entry == null) {
            entry = new ValueReferenceELExprCacheEntry();
            this.valueRefCache.put((Object)elText, (Object)entry);
        }
        if (!entry.isInitialized()) {
            Tree tree = this.getAstTree(elText);
            entry.initialize(tree);
        }
        return entry.isSimpleElExpr();
    }

    public synchronized String getRawElText(String elText) {
        ValueReferenceELExprCacheEntry entry = (ValueReferenceELExprCacheEntry)this.valueRefCache.get((Object)elText);
        if (entry == null) {
            entry = new ValueReferenceELExprCacheEntry();
            this.valueRefCache.put((Object)elText, (Object)entry);
        }
        if (!entry.isInitialized()) {
            Tree tree = this.getAstTree(elText);
            entry.initialize(tree);
        }
        return entry.getRawElText();
    }

    public synchronized ELExpression.EscapeType getEscapeType(String elText) {
        ValueReferenceELExprCacheEntry entry = (ValueReferenceELExprCacheEntry)this.valueRefCache.get((Object)elText);
        if (entry == null) {
            entry = new ValueReferenceELExprCacheEntry();
            this.valueRefCache.put((Object)elText, (Object)entry);
        }
        if (!entry.isInitialized()) {
            entry.initialize(this.getAstTree(elText));
        }
        return entry.getEscapeType();
    }

    public synchronized void dumpStats() {
        System.out.println("AST Tree cache");
        this.treeCache.dumpStats();
        System.out.println("ValueReferences EL Expression Cache");
        this.valueRefCache.dumpStats();
    }

    private static class ELLRUCache<KEY, VALUE>
    extends LRUCache<KEY, VALUE> {
        private static final long serialVersionUID = -17193352121165225L;

        public ELLRUCache(int cacheSize) {
            super(cacheSize, new LRUCache.CacheStats());
        }

        public VALUE put(KEY key, VALUE value) {
            Object old = super.put(key, value);
            if (old == null) {
                this._cacheStats.incNumMisses();
            }
            return (VALUE)old;
        }
    }
}

