/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.documentservices;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.appservices.IAppLocalizer;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentContentProvider;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentLocalizationContext;
import oracle.eclipse.tools.application.common.services.documentservices.IExternalVariableProvider;
import oracle.eclipse.tools.application.common.services.documentservices.IImplicitVariableProvider;
import oracle.eclipse.tools.application.common.services.documentservices.ITagVariableDiscoveryService;
import oracle.eclipse.tools.application.common.services.documentservices.IVersionProvider;
import oracle.eclipse.tools.application.common.services.documentservices.LocalizationRangeStore;
import oracle.eclipse.tools.application.common.services.documentservices.internal.IDocumentLocalizationContextWorkingCopy;
import oracle.eclipse.tools.application.common.services.documentservices.internal.ImplicitVariableProvider;
import oracle.eclipse.tools.application.common.services.documentservices.internal.VariableDiscoveryService;
import oracle.eclipse.tools.application.common.services.metadata.IVersion;
import oracle.eclipse.tools.application.common.services.techextservices.EnumVarGenerator;
import oracle.eclipse.tools.application.common.services.techextservices.FieldsGenerator;
import oracle.eclipse.tools.application.common.services.variables.ExternalVariable;
import oracle.eclipse.tools.application.common.services.variables.IFileVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.IFileVariablesCacheProvider;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IStructuredXMLModelVisitor;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.StructuredModelFactory;
import oracle.eclipse.tools.common.services.document.DocumentServiceAdapterFactory;
import oracle.eclipse.tools.common.services.document.HashingComparator;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IVisitableDocument;
import oracle.eclipse.tools.common.services.documentservices.IDocumentBindersProvider;
import oracle.eclipse.tools.common.services.documentservices.TechComposingDocumentService;
import oracle.eclipse.tools.common.services.documentservices.internal.DocumentBindersProvider;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtensionIdentifier;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.xml.model.emfbinding.EStoreFactory;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContextFactory;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INodeReader;
import oracle.eclipse.tools.xml.model.emfbinding.dom.NodeEStoreFactory;
import oracle.eclipse.tools.xml.model.service.IXMLMetadataContext;
import oracle.eclipse.tools.xml.model.service.IXMLSemanticObjectFactory;
import oracle.eclipse.tools.xml.model.service.XMLSemanticObjectFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.IMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory2;
import org.eclipse.jst.jsf.metadataprocessors.IMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.ITypeDescriptor;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataEnabledProcessingFactory;
import org.eclipse.jst.jsf.metadataprocessors.internal.AttributeValueRuntimeTypeFactory;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebtierDocumentServicesFactory
extends DocumentServiceAdapterFactory {
    protected final Object doCreateAdapter(Class<?> adapterType, IDocument document) {
        if (IExternalVariableProvider.class.equals(adapterType)) {
            return this.doCreateExternalVariableProvider(document);
        }
        if (IImplicitVariableProvider.class.equals(adapterType)) {
            return this.doCreateImplicitVariableProvider(document);
        }
        if (ITagVariableDiscoveryService.class.equals(adapterType)) {
            return new VariableDiscoveryService(document);
        }
        if (IXMLSemanticObjectFactory.class.equals(adapterType)) {
            return this.doCreateXMLSemanticObjectFactory(document);
        }
        if (EStoreFactory.class.equals(adapterType)) {
            return this.doCreateEStoreFactory(document);
        }
        if (IDocumentContentProvider.class.equals(adapterType)) {
            return this.doCreateDocumentContentProvider(document);
        }
        if (IDocumentBindersProvider.class.equals(adapterType)) {
            return this.doCreateDocumentBindersProvider(document);
        }
        if (IVisitableDocument.class.equals(adapterType)) {
            return this.doCreateVisitableDocument(document);
        }
        if (IXMLMetadataContext.class.equals(adapterType)) {
            return this.doCreateXMLModelContext(document);
        }
        if (org.eclipse.jface.text.IDocument.class.equals(adapterType)) {
            return this.doCreateJFaceDocument(document);
        }
        if (adapterType == IDocumentLocalizationContext.class || adapterType == IDocumentLocalizationContextWorkingCopy.class) {
            if (JavaAppDocumentLocalizationContext.checkForLocalizer(document)) {
                return new JavaAppDocumentLocalizationContext(document);
            }
            return null;
        }
        if (adapterType == IFileVariablesCacheProvider.class) {
            return this.doCreateFileVariablesCacheProvider(document);
        }
        if (adapterType == IVersionProvider.class) {
            return this.doCreateVersionProvider(document);
        }
        return this.internalDoCreateAdapter(adapterType, document);
    }

    public HashingComparator getHashingComparator(Class<?> adapterType) {
        return new HashingComparator(){

            public boolean equals(Object obj, Object obj2) {
                if (obj instanceof Class && obj2 instanceof Class && ((Class)obj).isAssignableFrom(IDocumentLocalizationContext.class) && ((Class)obj2).isAssignableFrom(IDocumentLocalizationContext.class)) {
                    return true;
                }
                return super.equals(obj, obj2);
            }

            public int hashCode(Class<?> adapterType_) {
                if (adapterType_.isAssignableFrom(IDocumentLocalizationContext.class)) {
                    return IDocumentLocalizationContext.class.hashCode();
                }
                return super.hashCode(adapterType_);
            }
        };
    }

    protected IXMLMetadataContext doCreateXMLModelContext(IDocument document) {
        return new XMLMetadataContext(document);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected org.eclipse.jface.text.IDocument doCreateJFaceDocument(IDocument document) {
        IStructuredModel model = null;
        IStructuredDocument sdoc = null;
        try {
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(document.getFile());
                sdoc = model.getStructuredDocument();
                return sdoc;
            }
            catch (IOException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
                if (model == null) return sdoc;
                model.releaseFromRead();
                return sdoc;
            }
            catch (CoreException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
                if (model == null) return sdoc;
                model.releaseFromRead();
                return sdoc;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    protected IVisitableDocument doCreateVisitableDocument(IDocument document) {
        return new VisitableDocument(document);
    }

    protected IXMLSemanticObjectFactory doCreateXMLSemanticObjectFactory(IDocument document) {
        INamespaceContextFactory factory = (INamespaceContextFactory)document.getAdapter(INamespaceContextFactory.class);
        if (factory == null) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)new Exception("for stack trace only"), (String)("Problem getting namespace context factory for: " + document.toString()));
            return null;
        }
        INamespaceContext namespaceContext = factory.getNamespaceContext(document.getFile());
        if (namespaceContext == null) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)new Exception("for stack trace only"), (String)("Problem getting namespace context for: " + document.toString()));
            return null;
        }
        return new XMLSemanticObjectFactory(namespaceContext, document.getFile());
    }

    protected EStoreFactory<Node> doCreateEStoreFactory(IDocument document) {
        INamespaceContextFactory factory = (INamespaceContextFactory)document.getAdapter(INamespaceContextFactory.class);
        if (factory == null) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)new Exception("for stack trace only"), (String)("Problem getting namespace context factory for: " + document.toString()));
            return null;
        }
        INamespaceContext nsContext = factory.getNamespaceContext(document.getFile());
        if (nsContext == null) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)new Exception("for stack trace only"), (String)("Problem getting namespace context for: " + document.toString()));
            return null;
        }
        return new NodeEStoreFactory(nsContext, document.getFile());
    }

    protected Object internalDoCreateAdapter(Class<?> adapterType, IDocument document) {
        return null;
    }

    protected IImplicitVariableProvider doCreateImplicitVariableProvider(IDocument document) {
        return new ImplicitVariableProvider(document);
    }

    protected IExternalVariableProvider doCreateExternalVariableProvider(IDocument document) {
        return new ExternalVariableProvider(document);
    }

    protected IFileVariablesCacheProvider doCreateFileVariablesCacheProvider(IDocument document) {
        return new FileVariablesCacheProvider(document);
    }

    protected IVersionProvider doCreateVersionProvider(IDocument document) {
        return new VersionProvider(document);
    }

    protected IDocumentContentProvider doCreateDocumentContentProvider(IDocument document) {
        return new DocumentContentProvider(document);
    }

    protected IDocumentBindersProvider doCreateDocumentBindersProvider(IDocument document) {
        return new DocumentBindersProvider(document);
    }

    protected static final class DocumentContentProvider
    extends TechComposingDocumentService<IDocumentContentProvider>
    implements IDocumentContentProvider {
        public DocumentContentProvider(IDocument doc) {
            super(doc);
        }

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public List<EnumVarGenerator> getEnumVarGenerators(ValueReference valRef) {
            ArrayList<EnumVarGenerator> enumVarGenerators = new ArrayList<EnumVarGenerator>();
            List providers = this.createComposedServiceList(IDocumentContentProvider.class);
            this.sort(providers);
            for (IDocumentContentProvider provider : providers) {
                enumVarGenerators.addAll(provider.getEnumVarGenerators(valRef));
            }
            return enumVarGenerators;
        }

        @Override
        public List<FieldsGenerator> getFieldGenerators(ValueReference valRef) {
            ArrayList<FieldsGenerator> fieldGenerators = new ArrayList<FieldsGenerator>();
            List providers = this.createComposedServiceList(IDocumentContentProvider.class);
            this.sort(providers);
            for (IDocumentContentProvider provider : providers) {
                fieldGenerators.addAll(provider.getFieldGenerators(valRef));
            }
            return fieldGenerators;
        }

        private void sort(List<IDocumentContentProvider> providers) {
            Collections.sort(providers, new Comparator<IDocumentContentProvider>(){

                @Override
                public int compare(IDocumentContentProvider o1, IDocumentContentProvider o2) {
                    if (o1.getPriority() > o2.getPriority()) {
                        return -1;
                    }
                    if (o2.getPriority() > o1.getPriority()) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
    }

    protected static final class ExternalVariableProvider
    extends TechComposingDocumentService<IExternalVariableProvider>
    implements IExternalVariableProvider {
        public ExternalVariableProvider(IDocument doc) {
            super(doc);
        }

        @Override
        public List<ExternalVariable> getExternalVariables() {
            ArrayList<ExternalVariable> externalVariables = new ArrayList<ExternalVariable>();
            List providers = this.createComposedServiceList(IExternalVariableProvider.class);
            for (IExternalVariableProvider provider : providers) {
                externalVariables.addAll(provider.getExternalVariables());
            }
            return externalVariables;
        }
    }

    protected static final class FileVariablesCacheProvider
    extends TechComposingDocumentService<IFileVariablesCacheProvider>
    implements IFileVariablesCacheProvider {
        public FileVariablesCacheProvider(IDocument doc) {
            super(doc);
        }

        @Override
        public IFileVariablesCache getCache(boolean useWorkingCopy) {
            List providers = this.createComposedServiceList(IFileVariablesCacheProvider.class);
            for (IFileVariablesCacheProvider provider : providers) {
                IFileVariablesCache cache = provider.getCache(useWorkingCopy);
                if (cache == null) continue;
                return cache;
            }
            return null;
        }
    }

    private static final class JavaAppDocumentLocalizationContext
    extends TechComposingDocumentService<IDocumentLocalizationContext>
    implements IDocumentLocalizationContextWorkingCopy {
        private final IAppLocalizer _localizer;
        private final CopyOnWriteArrayList<IDocumentLocalizationContext.ILocalizationListener> _listeners;
        private final CopyOnWriteArrayList<IDocumentLocalizationContext> _sortedListOfExtensions;
        private final HashMap<IDocumentLocalizationContext, IDocumentLocalizationContext.ILocalizationListener> _extensionListeners;

        static IAppLocalizer getAppLocalizer(IDocument doc) {
            return (IAppLocalizer)doc.getProject().getAppService(IAppLocalizer.class);
        }

        static boolean checkForLocalizer(IDocument doc) {
            return JavaAppDocumentLocalizationContext.getAppLocalizer(doc) != null;
        }

        public JavaAppDocumentLocalizationContext(IDocument doc) {
            super(doc);
            this._localizer = JavaAppDocumentLocalizationContext.getAppLocalizer(doc);
            if (this._localizer == null) {
                throw new IllegalArgumentException("doc doesn't have an app or app localizer");
            }
            this._listeners = new CopyOnWriteArrayList();
            this._extensionListeners = new HashMap();
            this._sortedListOfExtensions = new CopyOnWriteArrayList();
            this.updateSortedExtensions(this._sortedListOfExtensions);
            for (IDocumentLocalizationContext context : this._sortedListOfExtensions) {
                IDocumentLocalizationContext.ILocalizationListener listener = new IDocumentLocalizationContext.ILocalizationListener(){

                    @Override
                    public void changeOccurred(IDocumentLocalizationContext.LocalizationChangeEvent event) {
                        JavaAppDocumentLocalizationContext.this.fireEvent(event);
                    }
                };
                context.addListener(listener);
                this._extensionListeners.put(context, listener);
            }
        }

        @Override
        public IBundleResource resolveBundle(int offset, String baseName, Locale locale) {
            return this._localizer.resolveBundle(baseName, locale);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void updateSortedExtensions(List<IDocumentLocalizationContext> updateThisList) {
            List extensions = this.createComposedServiceList(IDocumentLocalizationContext.class);
            Collections.sort(extensions);
            List<IDocumentLocalizationContext> list = updateThisList;
            synchronized (list) {
                updateThisList.clear();
                updateThisList.addAll(extensions);
            }
        }

        @Override
        public ITechnologyExtensionIdentifier getOwner() {
            throw new UnsupportedOperationException("This is special context that aggregates other technlogies");
        }

        @Override
        public String getImplicitBundleName(int offset) {
            for (IDocumentLocalizationContext context : this._sortedListOfExtensions) {
                String implicitBundleName = context.getImplicitBundleName(offset);
                if (implicitBundleName == null) continue;
                return implicitBundleName;
            }
            return null;
        }

        @Override
        public Locale resolveLocale(int offset, List<Locale> preferredLocales) {
            for (IDocumentLocalizationContext context : this._sortedListOfExtensions) {
                Locale locale = context.resolveLocale(offset, preferredLocales);
                if (locale == null) continue;
                return locale;
            }
            return null;
        }

        @Override
        public Collection<Locale> getAvailableLocale() {
            Set<String> baseNames = this._localizer.getAllBaseNames();
            HashSet<Locale> locales = new HashSet<Locale>();
            for (String baseName : baseNames) {
                Collection<Locale> baseNameLocales = this._localizer.getAvailableLocales(baseName);
                locales.addAll(baseNameLocales);
            }
            return locales;
        }

        @Override
        public void dispose() {
            for (IDocumentLocalizationContext context : this._extensionListeners.keySet()) {
                IDocumentLocalizationContext.ILocalizationListener listener = this._extensionListeners.get(context);
                if (listener == null) continue;
                context.removeListener(listener);
            }
            this._extensionListeners.clear();
            this._listeners.clear();
            this._sortedListOfExtensions.clear();
        }

        @Override
        public LocalizationRangeStore<String> getBundleRangeStore() {
            throw new UnsupportedOperationException("This is special context that aggregates other technlogies");
        }

        @Override
        public LocalizationRangeStore<Locale> getLocaleRangeStore() {
            throw new UnsupportedOperationException("This is special context that aggregates other technlogies");
        }

        @Override
        public void addListener(IDocumentLocalizationContext.ILocalizationListener listener) {
            this._listeners.addIfAbsent(listener);
        }

        @Override
        public void removeListener(IDocumentLocalizationContext.ILocalizationListener listener) {
            this._listeners.remove(listener);
        }

        protected void fireEvent(IDocumentLocalizationContext.LocalizationChangeEvent event) {
            for (IDocumentLocalizationContext.ILocalizationListener listener : this._listeners) {
                listener.changeOccurred(event);
            }
        }

        @Override
        public void flushQueuedEvents() {
            throw new UnsupportedOperationException("This is special context that aggregates other technlogies");
        }
    }

    protected static final class VersionProvider
    extends TechComposingDocumentService<IVersionProvider>
    implements IVersionProvider {
        public VersionProvider(IDocument doc) {
            super(doc);
        }

        @Override
        public IVersion getVersion(String nsId) {
            List providers = this.createComposedServiceList(IVersionProvider.class);
            for (IVersionProvider provider : providers) {
                IVersion versionProv = provider.getVersion(nsId);
                if (versionProv == null) continue;
                return versionProv;
            }
            return null;
        }
    }

    protected static final class VisitableDocument
    implements IVisitableDocument {
        private final IDocument _document;

        public VisitableDocument(IDocument document) {
            this._document = document;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void accept(IStructuredXMLModelVisitor visitor) {
            assert (visitor != null);
            IVisitableDOMModel model = null;
            try {
                try {
                    model = StructuredModelFactory.getVisitableModelForRead((IFile)this._document.getFile());
                    model.accept(visitor);
                    return;
                }
                catch (CoreException e) {
                    LoggingService.logError((Plugin)Activator.getDefault(), (String)e.getMessage());
                    if (model == null) return;
                    model.dispose();
                    return;
                }
                catch (IOException e) {
                    LoggingService.logError((Plugin)Activator.getDefault(), (String)e.getMessage());
                    if (model == null) return;
                    model.dispose();
                    return;
                }
            }
            finally {
                if (model != null) {
                    model.dispose();
                }
            }
        }
    }

    protected static final class XMLMetadataContext
    implements IXMLMetadataContext {
        private final INodeReader _nodeReader = INodeReader.INSTANCE;
        private final IDocument _document;

        private XMLMetadataContext(IDocument document) {
            this._document = document;
        }

        public List<IMetaDataEnabledFeature> getMetaDataFeature(Class<?> adapterType, String uri, String elementName, String attrName, int docOffset, IStructuredModel providedModel) {
            IStructuredModel model = null;
            try {
                model = this.getStructuredModel(providedModel);
                IStructuredDocumentContext sdContext = IStructuredDocumentContextFactory2.INSTANCE.getContext((org.eclipse.jface.text.IDocument)model.getStructuredDocument(), docOffset);
                if (sdContext != null) {
                    List list = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(adapterType, sdContext, uri, elementName, attrName);
                    return list;
                }
            }
            catch (IOException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
            }
            catch (CoreException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
            }
            finally {
                this.releaseStructuredModel(providedModel, model);
            }
            return Collections.emptyList();
        }

        public List<IMetaDataEnabledFeature> getMetaDataFeature(Class<?> adapterType, String uri, String elementName, String attrName, int docOffset) {
            return this.getMetaDataFeature(adapterType, uri, elementName, attrName, docOffset, null);
        }

        public IMetaDataDomainContext getMetaDataDomainContext() {
            return MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(this._document.getFile());
        }

        public ITypeDescriptor getTypeDescriptor(Attr attr) {
            String uri;
            Element ownerElement = attr.getOwnerElement();
            String elementName = this._nodeReader.getElementQName(ownerElement);
            String attributeName = this._nodeReader.getAttributeName((Node)attr);
            if (elementName != null && attributeName != null && (uri = this.getUri(ownerElement)) != null) {
                return this.getTypeDescriptor(uri, elementName, attributeName);
            }
            return null;
        }

        public ITypeDescriptor getTypeDescriptor(String uri, String elementName, String attributeName) {
            Trait trait;
            String entityName = String.valueOf(elementName) + "/" + attributeName;
            IMetaDataQuery query = MetaDataQueryFactory.getInstance().createQuery(this.getMetaDataDomainContext());
            Entity attrEntity = query.getQueryHelper().getEntity(uri, entityName);
            if (attrEntity != null && (trait = query.getQueryHelper().getTrait(attrEntity, "attribute-value-runtime-type")) != null) {
                String typeId = TraitValueHelper.getValueAsString((Trait)trait);
                return AttributeValueRuntimeTypeFactory.getInstance().getType(typeId);
            }
            return null;
        }

        private String getUri(Element element) {
            INamespaceContext nsContext;
            INamespaceContextFactory factory = (INamespaceContextFactory)this._document.getAdapter(INamespaceContextFactory.class);
            if (factory != null && (nsContext = factory.getNamespaceContext(this._document.getFile())) != null && element != null) {
                return nsContext.getNamespace((Node)element);
            }
            return null;
        }

        private IStructuredModel getStructuredModel(IStructuredModel providedModel) throws IOException, CoreException {
            if (providedModel == null) {
                return StructuredModelManager.getModelManager().getModelForRead(this._document.getFile());
            }
            return providedModel;
        }

        private void releaseStructuredModel(IStructuredModel providedModel, IStructuredModel model) {
            if (providedModel == null && model != null) {
                model.releaseFromRead();
            }
        }
    }
}

