/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.documentservices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IDocumentService;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtensionIdentifier;

public interface IDocumentLocalizationContext
extends IDocumentService {
    public String getImplicitBundleName(int var1);

    public ITechnologyExtensionIdentifier getOwner();

    public Locale resolveLocale(int var1, List<Locale> var2);

    public IBundleResource resolveBundle(int var1, String var2, Locale var3);

    public Collection<Locale> getAvailableLocale();

    public void addListener(ILocalizationListener var1);

    public void removeListener(ILocalizationListener var1);

    public static interface ILocalizationListener {
        public void changeOccurred(LocalizationChangeEvent var1);
    }

    public static final class LocalizationChange {
        private final Type _type;
        private final List<Range> _rangesAdded;
        private final List<Range> _rangesRemoved;

        public LocalizationChange(Type type, List<Range> rangesAdded, List<Range> rangesRemoved) {
            this._type = type;
            this._rangesAdded = rangesAdded;
            this._rangesRemoved = rangesRemoved;
        }

        public final Type getType() {
            return this._type;
        }

        public List<Range> getRangesAdded() {
            return this._rangesAdded;
        }

        public List<Range> getRangesRemoved() {
            return this._rangesRemoved;
        }

        public List<Range> getAllRanges() {
            ArrayList<Range> allRanges = new ArrayList<Range>(this.getRangesAdded());
            allRanges.addAll(this.getRangesRemoved());
            return Collections.unmodifiableList(allRanges);
        }

        public static enum Type {
            LOCALE,
            BUNDLE;

        }
    }

    public static final class LocalizationChangeEvent
    extends EventObject {
        private final List<LocalizationChange> _changes;
        private static final long serialVersionUID = 8857457484403454221L;

        public LocalizationChangeEvent(IDocument source, List<LocalizationChange> changes) {
            super(source);
            this._changes = Collections.unmodifiableList(new ArrayList<LocalizationChange>(changes));
        }

        public final List<LocalizationChange> getChanges() {
            return this._changes;
        }

        public IDocument getSource() {
            return (IDocument)super.getSource();
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Document Localization Change Event: \n");
            for (LocalizationChange change : this.getChanges()) {
                builder.append(String.format("\t Change %s", change.getType().toString()));
                builder.append(change.getType().toString());
                for (Range range : change.getRangesAdded()) {
                    builder.append(String.format("Range=[%s]", range.toString()));
                }
                builder.append('\n');
            }
            builder.append('\n');
            return builder.toString();
        }
    }
}

