/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.documentservices;

import java.io.IOException;
import java.util.List;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContextFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.IStructuredDocumentContextResolverFactory2;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class DOMUtil {
    public Node findTagInParents(Node node, NodeQuery matcher) {
        Node nextParent = node.getParentNode();
        while (nextParent != null && !matcher.matches(nextParent)) {
            nextParent = nextParent.getParentNode();
        }
        return nextParent;
    }

    protected String getNamespaceAtContext(IDocument document, int offset) {
        Node node = this.getNodeAtContext(document, offset);
        if (node != null) {
            return this.getNamespaceAtContext(document, node);
        }
        return null;
    }

    public final String getNamespaceAtContext(IDocument document, Node node) {
        INamespaceContext context = this.getNamespaceContext(document);
        if (context != null) {
            return context.getNamespace(node);
        }
        return null;
    }

    public Node getNodeAtContext(IDocument document, int offset) {
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getModelForRead(document.getFile());
        }
        catch (IOException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
        }
        if (model != null) {
            try {
                IDOMContextResolver resolver;
                IStructuredDocumentContext sDocContext = this.getStructuredDocumentContext(document, offset);
                if (sDocContext != null && (resolver = IStructuredDocumentContextResolverFactory2.INSTANCE.getDOMContextResolver(sDocContext)) != null) {
                    Node node = resolver.getNode();
                    return node;
                }
            }
            finally {
                model.releaseFromRead();
            }
        }
        return null;
    }

    public boolean isNamespace(IDocument document, Node node, List<String> matchUris) {
        String uri = this.getNamespaceAtContext(document, node);
        if (uri != null) {
            for (String matchUri : matchUris) {
                if (!uri.equals(matchUri)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNode(IDocument document, Node node, List<String> matchUris, String name) {
        String nodeName = node.getLocalName();
        if (nodeName != null && nodeName.equals(name)) {
            return this.isNamespace(document, node, matchUris);
        }
        return false;
    }

    public String getAttributeValue(Node node, String attrName) {
        Node attr = node.getAttributes().getNamedItem(attrName);
        if (attr instanceof Attr) {
            return ((Attr)attr).getValue();
        }
        return null;
    }

    public IDocument getDocumentForNode(Node node) {
        IStructuredDocument structuredDocument;
        if (node instanceof IDOMNode && (structuredDocument = ((IDOMNode)node).getStructuredDocument()) != null) {
            return this.getDocumentForStructuredDocument(structuredDocument);
        }
        return null;
    }

    public IDocument getDocumentForStructuredDocument(IStructuredDocument structuredDocument) {
        IResource resource;
        IWorkspaceContextResolver resolver;
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((org.eclipse.jface.text.IDocument)structuredDocument, -1);
        if (context != null && (resolver = IStructuredDocumentContextResolverFactory2.INSTANCE.getWorkspaceContextResolver(context)) != null && (resource = resolver.getResource()).getType() == 1) {
            IFile file = (IFile)resource;
            return (IDocument)file.getAdapter(IDocument.class);
        }
        return null;
    }

    public IStructuredDocumentContext getStructuredDocumentContext(IDocument document, int offset) {
        IStructuredDocument sDoc = this.getStructuredDocument(document);
        if (sDoc != null) {
            IStructuredDocumentContext sDocContext = IStructuredDocumentContextFactory.INSTANCE.getContext((org.eclipse.jface.text.IDocument)sDoc, offset);
            return sDocContext;
        }
        return null;
    }

    protected INamespaceContext getNamespaceContext(IDocument document) {
        INamespaceContextFactory factory = (INamespaceContextFactory)document.getAdapter(INamespaceContextFactory.class);
        if (factory != null) {
            return factory.getNamespaceContext(document.getFile());
        }
        return null;
    }

    protected IStructuredDocument getStructuredDocument(IDocument document) {
        org.eclipse.jface.text.IDocument doc = (org.eclipse.jface.text.IDocument)document.getAdapter(org.eclipse.jface.text.IDocument.class);
        if (doc instanceof IStructuredDocument) {
            return (IStructuredDocument)doc;
        }
        return null;
    }

    public static abstract class NodeQuery {
        public abstract boolean matches(Node var1);
    }
}

