/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.documentservices;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.xml.model.service.IXMLMetadataContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsf.common.internal.types.CompositeType;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.IMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.metadataprocessors.IMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.features.ELIsNotValidException;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidELValues;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.MethodBindingType;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMAttributeDeclarationImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;

public final class AttributeTypeAdapter {
    private static final String JSF_LIBRARY = "is-jsf-component-library";
    private static final String DEFERRED_VALUE_DEPENDS_ON_ATTR = "deferred-value-depends-on-attribute";
    private final List<SupportedExpression> _supportedExpressions;

    public AttributeTypeAdapter(IXMLMetadataContext mdContext, IDocument doc, String uri, String elementName, String attrName) {
        this._supportedExpressions = AttributeTypeAdapter.initialize(mdContext, doc, uri, elementName, attrName);
    }

    public List<SupportedExpression> getSupportedExpressions() {
        return this._supportedExpressions;
    }

    public SupportedExpression getSupportedExpressions(ExpressionType exprType) {
        for (SupportedExpression expr : this._supportedExpressions) {
            if (expr.getType() != exprType) continue;
            return expr;
        }
        return null;
    }

    private static List<SupportedExpression> initialize(IXMLMetadataContext mdContext, IDocument doc, String uri, String elementName, String attrName) {
        ArrayList<SupportedExpression> expressionTypes = new ArrayList<SupportedExpression>();
        AttributeTypeAdapter.maybeAddELExpressions(expressionTypes, uri, elementName, attrName, mdContext);
        AttributeTypeAdapter.maybeAddJSPScriptletExpression(expressionTypes, doc, uri, elementName, attrName, mdContext);
        return Collections.unmodifiableList(expressionTypes);
    }

    private static void maybeAddJSPScriptletExpression(List<SupportedExpression> expressionTypes, IDocument doc, String uri, String elementName, String attrName, IXMLMetadataContext mdContext) {
        block10: {
            IStructuredModel model = null;
            try {
                try {
                    IModelManager mgr = StructuredModelManager.getModelManager();
                    model = mgr.getModelForRead(doc.getFile());
                    CMElementDeclaration elem = AttributeTypeAdapter.getTLDElementDeclaration(uri, elementName, (org.eclipse.jface.text.IDocument)model.getStructuredDocument());
                    if (elem == null) break block10;
                    int i = 0;
                    while (i < elem.getAttributes().getLength()) {
                        CMAttributeDeclaration attr = (CMAttributeDeclaration)elem.getAttributes().item(i);
                        if (attr.getAttrName().equals(attrName)) {
                            CMAttributeDeclarationImpl impl = (CMAttributeDeclarationImpl)attr;
                            if (impl.getRtexprvalue() != null && impl.getRtexprvalue().equals("true")) {
                                ArrayList<String> sig = new ArrayList<String>();
                                sig.add("Ljava.lang.Object;");
                                expressionTypes.add(new SupportedJSPScriptletExpression(sig));
                            }
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "oracle.eclipse.tools.application.common.services", "Error occurred while checking for scriptlet support.", (Throwable)e));
                    if (model != null) {
                        model.releaseFromRead();
                    }
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
    }

    private static void maybeAddELExpressions(List<SupportedExpression> list, String uri, String elementName, String attrName, IXMLMetadataContext mdContext) {
        List featureAdapters = mdContext.getMetaDataFeature(IValidELValues.class, uri, elementName, attrName, -1);
        SupportedELExpression methodExpr = null;
        SupportedELExpression valueExpr = null;
        if (featureAdapters != null && featureAdapters.size() > 0) {
            for (IMetaDataEnabledFeature elValue : featureAdapters) {
                try {
                    List<String> signatures;
                    CompositeType expectedRuntimeType;
                    if (elValue instanceof MethodBindingType) {
                        expectedRuntimeType = ((MethodBindingType)elValue).getExpectedRuntimeType();
                        if (expectedRuntimeType == null || expectedRuntimeType.getSignatures() == null) continue;
                        if (methodExpr == null) {
                            methodExpr = new SupportedMethodExpression(ResolutionTime.PAGE_RUN, Arrays.asList(expectedRuntimeType.getSignatures()));
                            list.add(methodExpr);
                            continue;
                        }
                        methodExpr.internalAddToSignatures(Arrays.asList(expectedRuntimeType.getSignatures()));
                        continue;
                    }
                    expectedRuntimeType = ((IValidELValues)elValue).getExpectedRuntimeType();
                    if (expectedRuntimeType != null && expectedRuntimeType.getSignatures() != null) {
                        signatures = Arrays.asList(expectedRuntimeType.getSignatures());
                        signatures = AttributeTypeAdapter.ensureWorkaround(signatures);
                    } else {
                        signatures = AttributeTypeAdapter.ensureWorkaround(Collections.singletonList("Ljava.lang.Object;"));
                    }
                    if (valueExpr == null) {
                        valueExpr = new SupportedValueExpression(AttributeTypeAdapter.inferResolutionTime(mdContext, uri, elementName, attrName), signatures);
                        list.add(valueExpr);
                        continue;
                    }
                    valueExpr.internalAddToSignatures(signatures);
                }
                catch (ELIsNotValidException eLIsNotValidException) {}
            }
        }
    }

    private static ResolutionTime inferResolutionTime(IXMLMetadataContext context, String uri, String elementName, String attrName) {
        IMetaDataQuery query = MetaDataQueryFactory.getInstance().createQuery(context.getMetaDataDomainContext());
        Model model = query.getQueryHelper().getModel(uri);
        Entity tagEntity = query.getQueryHelper().getEntity((Entity)model, elementName);
        boolean isOddBall = AttributeTypeAdapter.isCaseWhereCanBeBoth(query, tagEntity, attrName);
        if (isOddBall) {
            return ResolutionTime.PAGE_RUN_OR_COMPILE;
        }
        Trait t = query.getQueryHelper().getTrait((Entity)model, JSF_LIBRARY);
        return TraitValueHelper.getValueAsBoolean((Trait)t) ? ResolutionTime.PAGE_RUN : ResolutionTime.PAGE_COMPILE;
    }

    private static boolean isCaseWhereCanBeBoth(IMetaDataQuery query, Entity tagEntity, String attrName) {
        int i = 0;
        while (i < tagEntity.getChildEntities().size()) {
            Entity attr = (Entity)tagEntity.getChildEntities().get(i);
            if (!attr.getId().equals(attrName) && AttributeTypeAdapter.attributeIsDepenendentOnThis(query, attr, attrName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean attributeIsDepenendentOnThis(IMetaDataQuery query, Entity attr, String attrName) {
        String dependentAttrName;
        Trait t = query.getQueryHelper().getTrait(attr, DEFERRED_VALUE_DEPENDS_ON_ATTR);
        return t != null && (dependentAttrName = TraitValueHelper.getValueAsString((Trait)t)) != null && dependentAttrName.equals(attrName);
    }

    private static List<String> ensureWorkaround(List<String> inputList) {
        boolean needsStringType = false;
        boolean needsObjectType = false;
        ArrayList<String> newList = new ArrayList<String>(inputList);
        if (newList.contains("Ljava.lang.String;") && !newList.contains("Ljava.lang.Object;")) {
            needsObjectType = true;
        }
        if (newList.contains("Ljava.lang.Object;") && !newList.contains("Ljava.lang.String;")) {
            needsStringType = true;
        }
        if (needsObjectType) {
            newList.add("Ljava.lang.Object;");
        }
        if (needsStringType) {
            newList.add("Ljava.lang.String;");
        }
        return newList;
    }

    private static CMElementDeclaration getTLDElementDeclaration(String uri, String elementName, org.eclipse.jface.text.IDocument document) {
        TLDCMDocumentManager tldmgr = TaglibController.getTLDCMDocumentManager((org.eclipse.jface.text.IDocument)document);
        if (tldmgr != null) {
            for (TaglibTracker tracker : tldmgr.getTaglibTrackers()) {
                if (!tracker.getURI().equals(uri)) continue;
                return (CMElementDeclaration)tracker.getElements().getNamedItem(String.valueOf(tracker.getPrefix()) + ":" + elementName);
            }
        }
        return null;
    }

    public static enum ExpressionType {
        STATIC,
        EL_VALUE_BINDING,
        EL_METHOD_BINDING,
        JSP_EXPRESSION;

    }

    public static abstract class SupportedELExpression
    extends SupportedExpression {
        private final List<String> _signatures;

        private SupportedELExpression(ExpressionType type, ResolutionTime resolutionTime, List<String> signatures) {
            super(type, resolutionTime);
            this._signatures = signatures;
        }

        void internalAddToSignatures(List<String> signatures) {
            this._signatures.addAll(signatures);
        }

        @Override
        public List<String> getValidSignatures() {
            return Collections.unmodifiableList(this._signatures);
        }
    }

    public static abstract class SupportedExpression {
        private final ExpressionType _type;
        private final ResolutionTime _resolutionTime;

        private SupportedExpression(ExpressionType type, ResolutionTime resolutionTime) {
            this._type = type;
            this._resolutionTime = resolutionTime;
        }

        public final ExpressionType getType() {
            return this._type;
        }

        public final ResolutionTime getResolutionTime() {
            return this._resolutionTime;
        }

        public List<String> getValidSignatures() {
            return Collections.emptyList();
        }
    }

    public static class SupportedJSPScriptletExpression
    extends SupportedELExpression {
        private SupportedJSPScriptletExpression(List<String> signature) {
            super(ExpressionType.JSP_EXPRESSION, ResolutionTime.PAGE_COMPILE, signature);
        }
    }

    public static class SupportedMethodExpression
    extends SupportedELExpression {
        private SupportedMethodExpression(ResolutionTime resolutionTime, List<String> signatures) {
            super(ExpressionType.EL_METHOD_BINDING, resolutionTime, signatures);
        }
    }

    public static class SupportedValueExpression
    extends SupportedELExpression {
        private SupportedValueExpression(ResolutionTime resolutionTime, List<String> signatures) {
            super(ExpressionType.EL_VALUE_BINDING, resolutionTime, signatures);
        }
    }
}

