/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.documentservices;

import oracle.eclipse.tools.application.common.services.documentservices.IScriptHandler;
import oracle.eclipse.tools.application.common.services.variables.JavaResourceBundleDataType;
import oracle.eclipse.tools.application.common.services.variables.MethodReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import org.eclipse.jst.jsf.context.IModelContext;

public abstract class AbstractScriptHandler
implements IScriptHandler {
    protected final IModelContext _context;

    public AbstractScriptHandler(IModelContext context) {
        this._context = context;
    }

    @Override
    public String computeExpression(ValueReference valRef) {
        StringBuffer expr = new StringBuffer(this.getScriptPrefix());
        expr.append(this.internalComputeExprStr(valRef));
        expr.append(this.getScriptSuffix());
        return expr.toString();
    }

    @Override
    public String computeExpression(MethodReference methodReference) {
        StringBuffer expr = new StringBuffer(this.getScriptPrefix());
        expr.append(this.doComputeExprStr(methodReference));
        expr.append(this.getScriptSuffix());
        return expr.toString();
    }

    private String internalComputeExprStr(ValueReference valRef) {
        if (valRef.getVariable().getType() instanceof JavaResourceBundleDataType) {
            return this.doComputeBundleExpr(valRef);
        }
        return this.doComputeVarExpr(valRef);
    }

    protected String doComputeBundleExpr(ValueReference valRef) {
        StringBuilder expr = new StringBuilder(valRef.getVariable().getName());
        String fieldName = valRef.getFieldName();
        if (fieldName != null) {
            expr.append("['");
            expr.append(fieldName);
            expr.append("']");
        }
        return expr.toString();
    }

    protected String doComputeVarExpr(ValueReference valRef) {
        StringBuffer expr = new StringBuffer(valRef.getVariable().getName());
        ValueReference.FieldInfo[] fields = valRef.getFieldsInfo(this._context);
        if (fields != null) {
            int i = 0;
            while (i < fields.length) {
                ValueReference.FieldInfo fi = fields[i];
                expr.append('.');
                expr.append(fi.mFieldName);
                ++i;
            }
        }
        return expr.toString();
    }

    protected String doComputeExprStr(MethodReference methodReference) {
        StringBuffer expr = new StringBuffer(this.internalComputeExprStr(methodReference.getValueReference()));
        expr.append('.');
        expr.append(methodReference.getMethodName());
        return expr.toString();
    }
}

