/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.documentservices;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentContentGenerator;
import oracle.eclipse.tools.application.common.services.documentservices.IValueBindableComponentProvider;
import oracle.eclipse.tools.application.common.services.techextservices.IValueBindableComponent;
import oracle.eclipse.tools.application.common.services.variables.ComponentGenerationInfo;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.FieldGenerationInfo;
import oracle.eclipse.tools.application.common.services.variables.IComponentGenerationInfoProvider;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.documentservices.IDocumentBindersProvider;
import oracle.eclipse.tools.xml.model.emfbinding.EStoreFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.jsf.context.IModelContext;
import org.w3c.dom.Node;

public abstract class AbstractDocumentContentGenerator
implements IDocumentContentGenerator,
IComponentGenerationInfoProvider {
    private static final String ATTR_VALUE = "value";
    private IDocument _document;
    private String _displayName;
    private EStoreFactory<Node> _esFactory;
    private IDocumentBindersProvider _binderProvider;
    private List<ValueReference> _fields;
    private List<FieldGenerationInfo> _genFieldInfos;
    private boolean _doHeader;
    private boolean _doFooter;
    private String _validationStyleClassName;
    private boolean _doValidationMsg;

    public boolean doHeader() {
        return this._doHeader;
    }

    public boolean doFooter() {
        return this._doFooter;
    }

    public String getValidationStyleClassName() {
        return this._validationStyleClassName;
    }

    public void setValidationStyleClassName(String validationStyleClassName) {
        this._validationStyleClassName = validationStyleClassName;
    }

    public void setDoValidationMessage(boolean doValidationMsg) {
        this._doValidationMsg = doValidationMsg;
    }

    public boolean doValidationMessage() {
        return this._doValidationMsg;
    }

    protected final List<FieldGenerationInfo> getFieldsGenerationInfos() {
        if (this._genFieldInfos == null) {
            this._genFieldInfos = new ArrayList<FieldGenerationInfo>();
            for (ValueReference valRef : this._fields) {
                this._genFieldInfos.add(new FieldGenerationInfo(valRef, this, this._document.getFile()));
            }
        }
        return this._genFieldInfos;
    }

    public void setFieldGenerationInfos(List<FieldGenerationInfo> fieldGenInfos) {
        this._genFieldInfos = fieldGenInfos;
    }

    public void setFields(List<ValueReference> fields) {
        this._fields = fields;
    }

    public void setDoHeader(boolean doHeader) {
        this._doHeader = doHeader;
    }

    public void setDoFooter(boolean doFooter) {
        this._doFooter = doFooter;
    }

    protected AbstractDocumentContentGenerator(IDocument document, String displayName) {
        this._document = document;
        this._displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        return this._displayName;
    }

    protected IDocument getDocument() {
        return this._document;
    }

    protected EStoreFactory<Node> getEStoreFactory() {
        if (this._esFactory == null) {
            this._esFactory = (EStoreFactory)this._document.getAdapter(EStoreFactory.class);
        }
        return this._esFactory;
    }

    public String generateId(FieldGenerationInfo fldInfo) {
        FilePositionContext context = new FilePositionContext(this._document.getFile());
        if (fldInfo.getValueReference().getFieldPath((IModelContext)context) != null) {
            int len = fldInfo.getValueReference().getFieldPath((IModelContext)context).length;
            String id = null;
            int i = 0;
            while (i < len) {
                String tmp = fldInfo.getValueReference().getFieldPath((IModelContext)context)[i].getName();
                id = id != null ? String.valueOf(id) + tmp : tmp;
                if (i != len - 1) {
                    id = String.valueOf(id) + "_";
                }
                ++i;
            }
            return id;
        }
        return null;
    }

    protected IDocumentBindersProvider getDocumentBinderProvider() {
        if (this._binderProvider == null) {
            this._binderProvider = (IDocumentBindersProvider)this._document.getAdapter(IDocumentBindersProvider.class);
        }
        return this._binderProvider;
    }

    public EStructuralFeature getDefaultBindableFeature(EClass tagEClass) {
        if (tagEClass.getEStructuralFeature(ATTR_VALUE) != null) {
            return tagEClass.getEStructuralFeature(ATTR_VALUE);
        }
        return null;
    }

    protected IValueBindableComponent getValueBindableComponent(FieldGenerationInfo fieldGenInfo) {
        return this.getValueBindableComponentProvider().getValueBindableComponent(fieldGenInfo.getComponentGenerationInfo().getComponentType());
    }

    protected abstract IValueBindableComponentProvider getValueBindableComponentProvider();

    @Override
    public List<ComponentGenerationInfo.ComponentType> getAvailableComponentTypes(DataType.Field field) {
        ArrayList<ComponentGenerationInfo.ComponentType> ret = new ArrayList<ComponentGenerationInfo.ComponentType>();
        boolean isMulti = field.getType().isEnumerable();
        ComponentGenerationInfo.ComponentType[] componentTypeArray = ComponentGenerationInfo.ComponentType.values();
        int n = componentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentGenerationInfo.ComponentType c = componentTypeArray[n2];
            if (isMulti && c.isMultiValueType()) {
                ret.add(c);
            } else if (!isMulti && !c.isMultiValueType()) {
                ret.add(c);
            }
            ++n2;
        }
        return ret;
    }

    @Override
    public ComponentGenerationInfo getComponentGenerationInfo(DataType.Field field, ComponentGenerationInfo.ComponentType c) {
        return new ComponentGenerationInfo(c);
    }

    @Override
    public ComponentGenerationInfo.ComponentType getDefaultComponentType(DataType.Field field) {
        return ComponentGenerationInfo.ComponentType.Label;
    }
}

