/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.document.variable;

import java.util.ArrayList;
import oracle.eclipse.tools.application.common.services.document.XPathResolver;
import oracle.eclipse.tools.application.common.services.document.variable.DOMDocumentTemplateContext;
import oracle.eclipse.tools.application.common.services.document.variable.XPathExpressionVariable;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.jst.jsf.common.sets.AxiomaticSet;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XPathExpressionVariableResolver
extends TemplateVariableResolver {
    public XPathExpressionVariableResolver() {
        this(XPathExpressionVariable.DEFAULT_TYPE, XPathExpressionVariable.DEFAULT_TYPE);
    }

    public XPathExpressionVariableResolver(String type, String description) {
        super(type, description);
    }

    public void resolve(TemplateVariable variable, TemplateContext context) {
        if (context instanceof DOMDocumentTemplateContext && variable instanceof XPathExpressionVariable) {
            IDOMDocument document = ((DOMDocumentTemplateContext)context).getDocument();
            XPathExpressionVariable xpathVariable = (XPathExpressionVariable)variable;
            this.resolve(xpathVariable, document);
        }
    }

    private void resolve(XPathExpressionVariable variable, IDOMDocument document) {
        if (variable != null) {
            XPathExpressionVariable dependentVariable = variable.getDependentVariable();
            this.resolve(dependentVariable, document);
            if (dependentVariable != null) {
                String[] dependentValues = dependentVariable.getValues();
                String xPathExpression = variable.getXPathExpression().replaceAll("\\$" + dependentVariable.getName(), "\\\"" + dependentValues[0] + "\\\"");
                XPathResolver resolver = new XPathResolver((Node)document, xPathExpression, variable.getNamespaceContext());
                AxiomaticSet set = resolver.getAxiomaticSet();
                if (this.isResolved(set)) {
                    variable.setValues(this.convert(set));
                }
            } else {
                String[] convert;
                XPathResolver resolver = new XPathResolver((Node)document, variable.getXPathExpression(), variable.getNamespaceContext());
                AxiomaticSet set = resolver.getAxiomaticSet();
                if (this.isResolved(set) && (convert = this.convert(set)) != null && convert.length > 0) {
                    variable.setValues(convert);
                }
                variable.setResolved(this.isResolved(set));
            }
        }
    }

    protected String[] convert(AxiomaticSet set) {
        ArrayList<String> values = new ArrayList<String>();
        block0: for (Object object : set) {
            NodeList list;
            if (!(object instanceof Node) || (list = ((Node)object).getChildNodes()) == null || list.getLength() <= 0) continue;
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node instanceof Text) {
                    String text = ((Text)node).getData();
                    values.add(text);
                    continue block0;
                }
                ++i;
            }
        }
        return values.toArray(new String[values.size()]);
    }

    protected boolean isResolved(AxiomaticSet set) {
        if (set != null) {
            return set.size() > 0;
        }
        return false;
    }
}

