/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.document.validator;

import java.util.List;
import oracle.eclipse.tools.application.common.services.document.ExpressionBuilder;
import oracle.eclipse.tools.application.common.services.document.MapNamespaceContext;
import oracle.eclipse.tools.application.common.services.document.XPathResolver;
import oracle.eclipse.tools.application.common.services.document.validator.AbstractValidate;
import oracle.eclipse.tools.common.services.catalogue.message.CataloguedMessage;
import oracle.eclipse.tools.common.services.catalogue.problem.ProblemCatalogueIndex;
import org.eclipse.core.resources.IFile;
import org.w3c.dom.Document;

public class ValidateRequiredBlock
extends AbstractValidate {
    private final ExpressionBuilder _expression;

    public ValidateRequiredBlock(ExpressionBuilder builder, ProblemCatalogueIndex index) {
        super(index);
        this._expression = builder;
    }

    @Override
    public boolean validate(IFile targetFile, Document document, List<CataloguedMessage> reporter) {
        MapNamespaceContext namespaceContext = this._expression.getNamespaceContext();
        XPathResolver resolver = new XPathResolver(document, this._expression.getResolvedExpression(), namespaceContext);
        boolean foundProblems = false;
        if (!resolver.exists()) {
            CataloguedMessage message = this.createMessage(targetFile);
            message.setLineNo(1);
            reporter.add(message);
            foundProblems = true;
        }
        return foundProblems;
    }
}

