/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.document.validator;

import oracle.eclipse.tools.application.common.services.document.validator.Condition;
import org.eclipse.core.resources.IFile;
import org.w3c.dom.Document;

public abstract class AbstractCondition
implements Condition {
    @Override
    public abstract boolean evaluate(IFile var1, Document var2);

    @Override
    public Condition and(Condition condition) {
        return new ChainedCondition(this, condition){

            @Override
            protected boolean operate(boolean firstArg, boolean secondArg) {
                return firstArg && secondArg;
            }
        };
    }

    public Condition not() {
        return new ChainedCondition(this, null){

            @Override
            protected boolean operate(boolean firstArg, boolean secondArg) {
                return !firstArg;
            }
        };
    }

    protected static abstract class ChainedCondition
    extends AbstractCondition {
        private Condition current;
        private Condition next;

        public ChainedCondition(Condition current, Condition next) {
            this.current = current;
            this.next = next;
        }

        @Override
        public boolean evaluate(IFile targetFile, Document document) {
            boolean firstArg = this.current.evaluate(targetFile, document);
            boolean secondArg = this.next != null ? this.next.evaluate(targetFile, document) : true;
            return this.operate(firstArg, secondArg);
        }

        protected abstract boolean operate(boolean var1, boolean var2);
    }
}

