/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.document.configuration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.document.EditContext;
import oracle.eclipse.tools.application.common.services.document.EditManager;
import oracle.eclipse.tools.application.common.services.document.XMerge;
import oracle.eclipse.tools.application.common.services.document.configuration.AbstractConfiguration;
import oracle.eclipse.tools.common.operations.AbstractBasicOperation;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.xml.model.emfbinding.dom.StructuredModelXMLDocumentProvider;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.OperationStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jst.jsf.common.internal.componentcore.AbstractVirtualComponentQuery;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public abstract class AbstractConfigurationOperation<OpType extends AbstractConfiguration<T>, T extends Enum<?>>
extends AbstractBasicOperation {
    protected final IProject project;
    protected final AbstractVirtualComponentQuery _query;
    protected final StructuredModelXMLDocumentProvider _docProvider;
    protected final List<T> configTypes;

    public AbstractConfigurationOperation(String label, IProject project) {
        this(label, project, (AbstractVirtualComponentQuery)new AbstractVirtualComponentQuery.DefaultVirtualComponentQuery(), new StructuredModelXMLDocumentProvider(StructuredModelXMLDocumentProvider.ModelRequestType.SHARED_WRITE));
    }

    public AbstractConfigurationOperation(String label, IProject project, AbstractVirtualComponentQuery query, StructuredModelXMLDocumentProvider docProvider) {
        super(label);
        this.project = project;
        this._query = query;
        this._docProvider = docProvider;
        this.configTypes = new ArrayList<T>();
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            IFile file = this.createFile(this.getFilePath());
            EditContext context = EditManager.startEdit(this._docProvider, file, IWorkspace.VALIDATE_PROMPT, true);
            XMerge merge = context.getDocumentRewriter();
            OpType config = this.createNewConfiguration();
            for (Enum type : this.configTypes) {
                ((AbstractConfiguration)config).performUpdate((Enum)type, merge);
            }
            context.setFormat(true);
            IStatus status = EditManager.endEdit(context);
            if (status != null && !status.isOK()) {
                return status;
            }
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
        }
        catch (BadLocationException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
        }
        catch (IOException e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
        }
        return new OperationStatus(0, "oracle.eclipse.tools.application.common.services", 0, null, null);
    }

    public void stagingAddConfigTypes(T type) {
        this.configTypes.add(type);
    }

    protected abstract OpType createNewConfiguration();

    protected abstract IPath getFilePath();

    protected IFile createFile(IPath path) {
        IFile file;
        IVirtualFile vf;
        IResource resource;
        IVirtualFolder webContentFolder = this._query.getWebContentFolder(this.project);
        if (webContentFolder != null && (resource = (vf = webContentFolder.getFile(path)).getUnderlyingResource()).exists() && (file = vf.getUnderlyingFile()) != null && file.exists()) {
            return file;
        }
        return null;
    }
}

