/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.document;

import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.eclipse.tools.application.common.services.document.XPathVariableResolverImpl;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.jst.jsf.common.sets.AxiomaticSet;
import org.eclipse.jst.jsf.common.sets.ConcreteAxiomaticSet;
import org.eclipse.jst.jsf.common.sets.NodeSet;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathResolver {
    private final AxiomaticSet _axiomaticSet;

    public XPathResolver(Node document, String xPathExpression, NamespaceContext namespaceContext) {
        this._axiomaticSet = XPathResolver.initialize(document, xPathExpression, null, namespaceContext);
    }

    public XPathResolver(Node document, String xPathExpression, XPathVariableResolverImpl resolver, NamespaceContext namespaceContext) {
        this._axiomaticSet = XPathResolver.initialize(document, xPathExpression, resolver, namespaceContext);
    }

    private static AxiomaticSet initialize(Node document, String xPathExpression, XPathVariableResolverImpl resolver, NamespaceContext namespaceContext) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        if (namespaceContext != null) {
            xPath.setNamespaceContext(namespaceContext);
        }
        if (resolver != null) {
            resolver.setDocument(document);
            xPath.setXPathVariableResolver(resolver);
        }
        try {
            NodeList nodeList = (NodeList)xPath.evaluate(xPathExpression, document, XPathConstants.NODESET);
            return new NodeSet(nodeList);
        }
        catch (XPathExpressionException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (Throwable)e);
            return new ConcreteAxiomaticSet();
        }
    }

    public boolean exists() {
        if (this._axiomaticSet != null && !this._axiomaticSet.isEmpty()) {
            return this._axiomaticSet.size() > 0;
        }
        return false;
    }

    public AxiomaticSet getAxiomaticSet() {
        return this._axiomaticSet;
    }
}

