/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.document;

import java.util.List;
import oracle.eclipse.tools.application.common.services.document.ExpressionBuilder;
import oracle.eclipse.tools.application.common.services.document.MapNamespaceContext;
import oracle.eclipse.tools.application.common.services.document.MergePositionLocator;
import oracle.eclipse.tools.application.common.services.document.XPathResolver;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Node;

public class XMerge {
    private IDOMDocument _targetDocument;
    private TextEdit edit;

    public static XMerge create(IDOMDocument document) {
        return new XMerge(document);
    }

    protected XMerge(IDOMDocument targetDocument) {
        this._targetDocument = targetDocument;
        this.edit = new MultiTextEdit();
    }

    public TextEdit textEdit() {
        return this.edit;
    }

    public int getOffset() {
        return this.edit.getOffset();
    }

    public int getLength() {
        return this.edit.getLength();
    }

    public IDOMDocument getTargetDocument() {
        return this._targetDocument;
    }

    public boolean isDefined() {
        return this.edit.hasChildren();
    }

    public void merge(String mergeContent, MergePositionLocator mergeLocator) {
        int positionOffset = mergeLocator.calculateOffset(this._targetDocument);
        if (mergeLocator.isValid()) {
            InsertEdit insertEdit = new InsertEdit(positionOffset, mergeContent);
            this.edit.addChild((TextEdit)insertEdit);
        }
    }

    public boolean notExist(List<ExpressionBuilder> validationExpressions) {
        for (ExpressionBuilder expression : validationExpressions) {
            MapNamespaceContext context = expression.getNamespaceContext();
            XPathResolver validation = new XPathResolver((Node)this._targetDocument, expression.getExpression(), context);
            if (!validation.exists()) continue;
            return false;
        }
        return true;
    }
}

