/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.discovery.internal;

import java.util.Collections;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.variables.IFileVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IResourceDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class VariablesCacheClearDiscoveryParticipant
implements IDiscoveryParticipant {
    public void startDiscovery(IDiscoveryContext context, IProgressMonitor monitor) {
        Set changedResource = context.getChangedResources();
        VariablesController controller = VariablesController.getInstance();
        for (IResource resource : changedResource) {
            IFileVariablesCache cache;
            if (!(resource instanceof IFile) || (cache = controller.getFileCacheIfExists((IFile)resource, context.isWorkingCopy())) == null) continue;
            cache.clear();
        }
    }

    public IStatus stopDiscovery(IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public void discover(IResourceDiscoveryContext context, IProgressMonitor monitor) {
    }

    public void discoverFromExistingModel(IResourceDiscoveryContext context, IVisitableDOMModel model, IProgressMonitor monitor) {
    }

    public Set<IResource> getDependentResources(IProject project, Set<IResource> changedResources, IProgressMonitor monitor) {
        return Collections.emptySet();
    }

    public static class FACTORY {
        private static final VariablesCacheClearDiscoveryParticipant sPARTICIPANT = new VariablesCacheClearDiscoveryParticipant();

        public static IDiscoveryParticipant getParticipant() {
            return sPARTICIPANT;
        }
    }
}

