/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.discovery.internal;

import java.util.Set;
import oracle.eclipse.tools.application.common.services.collection.StructuredDocumentResourceLocationFactory;
import oracle.eclipse.tools.application.common.services.discovery.IStructuredDocumentDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StructuredDocumentDiscoveryContextImpl
implements IStructuredDocumentDiscoveryContext {
    private final IDiscoveryContext context;

    @Override
    public ResourceLocation getLocationOfNode(IResource resource, IDOMNode structuredNode) {
        if (resource.getType() == 1) {
            StructuredDocumentResourceLocationFactory locationFactory = new StructuredDocumentResourceLocationFactory((IFile)resource);
            if (structuredNode instanceof IDOMAttr) {
                return locationFactory.createForAttributeValue((IDOMAttr)structuredNode);
            }
            if (structuredNode instanceof IDOMElement) {
                return locationFactory.createForEntireElement((IDOMElement)structuredNode);
            }
        }
        return new ResourceLocation(resource, null);
    }

    @Override
    public String getNodeText(Node parent) {
        NodeList children = parent.getChildNodes();
        if (children.getLength() == 1) {
            return children.item(0).getNodeValue().trim();
        }
        StringBuffer s = new StringBuffer();
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 5) {
                String reference = ((EntityReference)child).getNodeValue();
                if (reference == null && child.getNodeName() != null) {
                    reference = "&" + child.getNodeName() + ";";
                }
                if (reference != null) {
                    s.append(reference.trim());
                }
            } else {
                s.append(child.getNodeValue().trim());
            }
            child = child.getNextSibling();
        }
        return s.toString().trim();
    }

    public IProject getProject() {
        return this.context.getProject();
    }

    public StructuredDocumentDiscoveryContextImpl(IDiscoveryContext context) {
        this.context = context;
    }

    public Set<IResource> getChangedResources() {
        return this.context.getChangedResources();
    }

    public Object getAdapter(Class adapter) {
        return this.context.getAdapter(adapter);
    }

    public boolean isWorkingCopy() {
        return this.context.isWorkingCopy();
    }
}

