/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.discovery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.eclipse.tools.application.common.services.appservices.IDatatypeProvider;
import oracle.eclipse.tools.application.common.services.collection.StructuredDocumentRangeFactory;
import oracle.eclipse.tools.application.common.services.collection.StructuredDocumentResourceLocationFactory;
import oracle.eclipse.tools.application.common.services.discovery.AbstractTagDiscoveryParticipant;
import oracle.eclipse.tools.application.common.services.discovery.IStructuredDocumentResourceDiscoveryContext;
import oracle.eclipse.tools.application.common.services.include.model.IMergedModelNode;
import oracle.eclipse.tools.application.common.services.tagsupport.ITypedSymbol;
import oracle.eclipse.tools.application.common.services.tagsupport.TypedComponentSymbolDelegate;
import oracle.eclipse.tools.application.common.services.variables.ArtificialVariable;
import oracle.eclipse.tools.application.common.services.variables.ELExpression;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceELParser;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IResourceDiscoveryContext;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import oracle.eclipse.tools.xml.model.emfbinding.dom.FeatureData;
import oracle.eclipse.tools.xml.model.emfbinding.dom.IFeatureData;
import oracle.eclipse.tools.xml.model.metadata.tlei.SubTypes;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.context.IDocumentContext;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.source.AbstractContextSymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.IAdditionalContextSymbolInfo;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractSMTagDiscoveryParticipant
extends AbstractTagDiscoveryParticipant {
    boolean _isUnifiedELJSFActive;
    private static final Pattern DEFERRED_EL_PATTERN = Pattern.compile("#\\{(.*)\\}");
    protected final StructuredDocumentRangeFactory rangeFactory = new StructuredDocumentRangeFactory();
    protected final ValueReferenceELParser parser = new ValueReferenceELParser();

    @Override
    public void startDiscovery(IDiscoveryContext context, IProgressMonitor monitor) {
        super.startDiscovery(context, monitor);
        this._isUnifiedELJSFActive = this.isUnifiedELJSFActive(this.getOepeProject());
    }

    public boolean visit(IDOMAttr attribute) {
        Element owningTag = attribute.getOwnerElement();
        if (this.resourceData.getTaglibResolver().hasTag((Node)owningTag)) {
            String uri = this.resourceData.getTaglibResolver().getTagURIForNodeName((Node)owningTag);
            String elementName = owningTag.getLocalName();
            this.processSymbolContrib(uri, elementName, attribute);
        }
        this.findELVarReferences(attribute);
        return false;
    }

    public boolean visit(IDOMDocument doc) {
        return this.resourceData.getCache() != null;
    }

    public boolean visit(IDOMElement element) {
        this.findVarReferences(element);
        return true;
    }

    public boolean visit(IDOMNode node) {
        if (node.getNodeType() == 8) {
            Matcher matcher;
            String commentString;
            String string = commentString = node.getNodeValue() == null ? null : node.getNodeValue().trim();
            if (commentString != null && (matcher = VAR_PATTERN.matcher(commentString)).matches() && matcher.groupCount() == 4) {
                String name = null;
                String type = null;
                if ("name".equals(matcher.group(1))) {
                    name = matcher.group(2);
                } else {
                    type = matcher.group(2);
                }
                if ("name".equals(matcher.group(3))) {
                    name = matcher.group(4);
                } else {
                    type = matcher.group(4);
                }
                if (name == null || type == null) {
                    return false;
                }
                IMergedModelNode mmNode = (IMergedModelNode)node.getAdapterFor(IMergedModelNode.class);
                if (mmNode == null || !mmNode.isRuntimeIncluded()) {
                    ResourceLocation loc = null;
                    ResourceLocation locInBaseSourceFile = null;
                    IStructuredDocumentRegion startRegion = node.getStartStructuredDocumentRegion();
                    if (startRegion != null) {
                        int start = startRegion.getStartOffset();
                        int end = startRegion.getEndOffset();
                        if (mmNode != null) {
                            loc = mmNode.getResourceLocation(end - start);
                            locInBaseSourceFile = mmNode.isExternal() ? mmNode.getLocationInBaseSourceFile() : loc;
                        } else {
                            loc = new ResourceLocation((IResource)this.resourceData.getFile(), new Range((long)start, (long)(end - start)));
                        }
                    }
                    ArtificialVariable var = new ArtificialVariable(name, this.dataTypeProvider.getDataType(type, this.resourceData.getImports()), loc, locInBaseSourceFile);
                    this.resourceData.getCache().add(var);
                }
            }
        }
        return false;
    }

    protected String getJavaText(IDOMElement element) {
        StringBuilder sb = new StringBuilder();
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 3 || child.getNodeType() == 4) {
                sb.append(child.getNodeValue());
            }
            ++i;
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    protected void processSymbolContrib(String uri, String elementName, IDOMAttr attribute) {
        AbstractTagDiscoveryParticipant.SymbolContribAggregator aggregator = AbstractTagDiscoveryParticipant.SymbolContribAggregator.create(new SMSymbolContribAggregatorData(this.resourceData.getFile(), uri, elementName, attribute.getLocalName(), attribute, this.getResourceContext()));
        String symbolName = attribute.getNodeValue();
        if (aggregator != null && symbolName != null && !"".equals(symbolName.trim())) {
            this.processSymbolContrib(uri, aggregator, symbolName);
        }
    }

    protected void findVarReferences(IDOMElement element) {
        List featuresWithVarNameSubtype = this.resourceData.getTagMetadata().findFeaturesWithSubtype((Node)element, Collections.singletonList(SubTypes.VAR_NAME_SUBTYPE));
        for (IFeatureData varFeatureData : featuresWithVarNameSubtype) {
            for (FeatureData.ValueHolder varValueHolder : varFeatureData.getValues()) {
                if (!(varValueHolder.getValue() instanceof String)) continue;
                String varName = (String)varValueHolder.getValue();
                String fieldName = null;
                List featuresWithFieldNameSubtype = this.resourceData.getTagMetadata().findFeaturesWithSubtype((Node)element, Collections.singletonList(SubTypes.FIELD_NAME_SUBTYPE));
                for (IFeatureData fieldFeatureData : featuresWithFieldNameSubtype) {
                    for (FeatureData.ValueHolder fieldValueHolder : fieldFeatureData.getValues()) {
                        if (!(fieldValueHolder.getValue() instanceof String)) continue;
                        fieldName = (String)fieldValueHolder.getValue();
                        break;
                    }
                    if (fieldName != null) break;
                }
                Range range = null;
                IMergedModelNode mmNode = (IMergedModelNode)element.getAdapterFor(IMergedModelNode.class);
                if (mmNode != null) {
                    ResourceLocation loc = mmNode.getResourceLocation();
                    if (loc != null) {
                        range = loc.getRange();
                    }
                } else {
                    range = this.rangeFactory.createRange(element);
                }
                this.reportVarReference(varName, fieldName, range);
            }
        }
    }

    protected final void findELVarReferences(IDOMAttr attribute) {
        String elText;
        ELExpression expression;
        String attributeValue = attribute.getValue();
        if (attributeValue != null && attributeValue.length() > 0 && (expression = this.parser.getELExpression(attributeValue)) != null && (elText = expression.getElText()) != null && !"".equals(elText)) {
            Range range = null;
            Element owningElement = attribute.getOwnerElement();
            if (owningElement instanceof IDOMElement) {
                IMergedModelNode mmNode = (IMergedModelNode)attribute.getAdapterFor(IMergedModelNode.class);
                if (mmNode != null) {
                    ResourceLocation loc = mmNode.getResourceLocation();
                    if (loc != null) {
                        range = loc.getRange();
                    }
                } else {
                    range = this.rangeFactory.createRangeForAttributeValue(attribute);
                }
            } else {
                range = this.rangeFactory.createRangeForAttributeValue(attribute);
            }
            this.reportELVarReference(elText, range);
        }
    }

    @Override
    protected boolean isUnifiedELJSFActive() {
        return this._isUnifiedELJSFActive;
    }

    @Override
    protected boolean isDeferredEvaluationEL(String expression) {
        Matcher matcher = DEFERRED_EL_PATTERN.matcher(expression.trim());
        return matcher.matches();
    }

    protected final IStructuredDocumentResourceDiscoveryContext getResourceContext() {
        return ((SMResourceData)this.resourceData).getResourceContext();
    }

    @Override
    protected boolean isUnifiedELJSFActive(Project prj) {
        JSFVersion jsfVersion = null;
        ITechnologyExtension techExt = prj.getTechnologyExtensionById("jsf");
        if (techExt != null) {
            String versionStr = techExt.getVersion();
            jsfVersion = JSFVersion.valueOfString((String)versionStr);
        }
        if (jsfVersion != null) {
            return jsfVersion.compareTo((Enum)JSFVersion.V1_2) >= 0;
        }
        return false;
    }

    protected abstract class SMResourceData
    extends AbstractTagDiscoveryParticipant.ResourceData {
        public SMResourceData(IStructuredDocumentResourceDiscoveryContext resourceContext) {
            super(AbstractSMTagDiscoveryParticipant.this, resourceContext);
        }

        @Override
        public IDocumentContext getDocumentContext(IResourceDiscoveryContext resourceContext) {
            return IStructuredDocumentContextFactory.INSTANCE.getContext(this.getResourceContext().getDocument(), -1);
        }

        @Override
        public IStructuredDocumentResourceDiscoveryContext getResourceContext() {
            return (IStructuredDocumentResourceDiscoveryContext)super.getResourceContext();
        }
    }

    protected static class SMSymbolContribAggregatorData
    extends AbstractTagDiscoveryParticipant.SymbolContribAggregatorData {
        private IDOMAttr attribute;
        private IStructuredDocumentResourceDiscoveryContext context;

        public SMSymbolContribAggregatorData(IFile file, String uri, String elementName, String attributeName, IDOMAttr attribute, IStructuredDocumentResourceDiscoveryContext context) {
            super(file, uri, elementName, attributeName);
            this.attribute = attribute;
            this.context = context;
        }

        @Override
        public String getAttributeValue(String attributeName) {
            Element ownerElement = this.attribute.getOwnerElement();
            if (ownerElement != null) {
                return ownerElement.getAttribute(attributeName);
            }
            return null;
        }

        @Override
        public IModelContext getDocumentContext() {
            return IStructuredDocumentContextFactory.INSTANCE.getContext(this.context.getDocument(), (Node)this.attribute);
        }

        @Override
        public ResourceLocation getLocation(ISymbol symbol) {
            ResourceLocation loc = null;
            Node locationNode = this.getSymbolNode(symbol);
            if (locationNode instanceof IDOMNode) {
                IMergedModelNode mmNode = null;
                mmNode = this.getMergedModelNode((IDOMNode)locationNode);
                if (mmNode != null) {
                    loc = mmNode.getResourceLocation();
                } else if (locationNode instanceof IDOMElement) {
                    loc = ResourceLocation.fromDOMElement((IFile)this.getFile(), (IDOMElement)((IDOMElement)locationNode));
                } else if (locationNode instanceof IDOMAttr) {
                    StructuredDocumentResourceLocationFactory sdrlf = new StructuredDocumentResourceLocationFactory(this.getFile());
                    loc = sdrlf.createForAttributeValue((IDOMAttr)locationNode);
                }
            }
            return loc;
        }

        private IMergedModelNode getMergedModelNode(IDOMNode locationNode) {
            IMergedModelNode mmNode = (IMergedModelNode)locationNode.getAdapterFor(IMergedModelNode.class);
            return mmNode;
        }

        @Override
        public ResourceLocation getLocationInBaseSourceFile(ISymbol symbol) {
            ResourceLocation locInBaseSourceFile = null;
            Node locationNode = this.getSymbolNode(symbol);
            if (locationNode instanceof IDOMNode) {
                IMergedModelNode mmNode = null;
                mmNode = this.getMergedModelNode((IDOMNode)locationNode);
                if (mmNode != null) {
                    locInBaseSourceFile = mmNode.isExternal() ? mmNode.getLocationInBaseSourceFile() : mmNode.getResourceLocation();
                } else if (locationNode instanceof IDOMElement) {
                    locInBaseSourceFile = ResourceLocation.fromDOMElement((IFile)this.getFile(), (IDOMElement)((IDOMElement)locationNode));
                } else if (locationNode instanceof IDOMAttr) {
                    StructuredDocumentResourceLocationFactory sdrlf = new StructuredDocumentResourceLocationFactory(this.getFile());
                    locInBaseSourceFile = sdrlf.createForAttributeValue((IDOMAttr)locationNode);
                }
            }
            return locInBaseSourceFile;
        }

        @Override
        public boolean isRuntimeIncludedNode(ISymbol symbol) {
            Node node = this.getSymbolNode(symbol);
            if (node instanceof IDOMNode) {
                IMergedModelNode mergedModelNode = this.getMergedModelNode((IDOMNode)node);
                return mergedModelNode != null && mergedModelNode.isRuntimeIncluded();
            }
            return false;
        }

        @Override
        public boolean isRuntimeIncludeNode() {
            Element owningElement = this.attribute.getOwnerElement();
            if (owningElement instanceof IDOMNode) {
                IMergedModelNode mergedModelNode = this.getMergedModelNode((IDOMNode)owningElement);
                return mergedModelNode != null && mergedModelNode.isRuntimeIncluded();
            }
            return false;
        }

        private Node getSymbolNode(ISymbol symbol) {
            IDOMNode adapter;
            IAdaptable locNodeAdapter;
            Element locationNode = this.attribute.getOwnerElement();
            if (symbol instanceof ITypedSymbol && (locNodeAdapter = ((ITypedSymbol)symbol).getDOMNode()) != null && (adapter = (IDOMNode)locNodeAdapter.getAdapter(IDOMNode.class)) != null) {
                locationNode = adapter;
            }
            return locationNode;
        }

        @Override
        public ResourceLocation getElementLocation() {
            Element owningElem = this.attribute.getOwnerElement();
            IMergedModelNode mmNode = null;
            ResourceLocation loc = null;
            if (owningElem instanceof IDOMElement) {
                mmNode = (IMergedModelNode)((IDOMElement)owningElem).getAdapterFor(IMergedModelNode.class);
                IStructuredDocumentRegion startRegion = ((IDOMElement)owningElem).getStartStructuredDocumentRegion();
                IStructuredDocumentRegion endRegion = ((IDOMElement)owningElem).getEndStructuredDocumentRegion();
                if (startRegion != null && endRegion != null) {
                    if (mmNode != null) {
                        loc = mmNode.getResourceLocation();
                    } else {
                        int start = startRegion.getStartOffset();
                        int end = endRegion.getEndOffset();
                        loc = new ResourceLocation((IResource)this.getFile(), new Range((long)start, (long)(end - start)));
                    }
                }
            }
            return loc;
        }

        @Override
        public ResourceLocation getElementLocationInBaseSource() {
            Element owningElem = this.attribute.getOwnerElement();
            ResourceLocation locInBaseSourceFile = null;
            if (owningElem instanceof IDOMElement) {
                IMergedModelNode mmNode = this.getMergedModelNode((IDOMNode)owningElem);
                IStructuredDocumentRegion startRegion = ((IDOMElement)owningElem).getStartStructuredDocumentRegion();
                IStructuredDocumentRegion endRegion = ((IDOMElement)owningElem).getEndStructuredDocumentRegion();
                if (startRegion != null && endRegion != null) {
                    if (mmNode != null) {
                        locInBaseSourceFile = mmNode.getResourceLocation();
                        if (mmNode.isExternal()) {
                            locInBaseSourceFile = mmNode.getLocationInBaseSourceFile();
                        }
                    } else {
                        int start = startRegion.getStartOffset();
                        int end = endRegion.getEndOffset();
                        locInBaseSourceFile = new ResourceLocation((IResource)this.getFile(), new Range((long)start, (long)(end - start)));
                    }
                }
            }
            return locInBaseSourceFile;
        }

        @Override
        public ISymbol createFromHints(ISymbol symbol, IDatatypeProvider dataTypeProvider, Set<String> importedNames) {
            TypedComponentSymbolDelegate typedSymbol = null;
            Element owningElement = this.attribute.getOwnerElement();
            if (owningElement != null) {
                NodeList children = owningElement.getChildNodes();
                int i = 0;
                while (i < children.getLength()) {
                    String nodeValue;
                    Node child = children.item(i);
                    if (child.getNodeType() == 8 && child.getNodeValue() != null && (nodeValue = child.getNodeValue().trim()).startsWith("oepe:varType=\"") && nodeValue.endsWith("\"") && nodeValue.length() >= 16) {
                        TypedComponentSymbolDelegate typedSymbolDelegate = new TypedComponentSymbolDelegate((IComponentSymbol)symbol);
                        typedSymbolDelegate.setTypeName(nodeValue.substring(14, nodeValue.length() - 1));
                        typedSymbolDelegate.setDataTypeProvider(dataTypeProvider);
                        typedSymbolDelegate.setImportedTypeNames(importedNames);
                        typedSymbol = typedSymbolDelegate;
                        break;
                    }
                    ++i;
                }
            }
            return typedSymbol;
        }

        @Override
        public ISymbol createSymbol(String symbolName) {
            ArrayList problems = new ArrayList();
            return this.getFactory().create(symbolName, 1, (IAdaptable)this.getDocumentContext(), problems, (IAdditionalContextSymbolInfo)new AbstractTagDiscoveryParticipant.AdditionalContextSymbolInfo(this.getStaticType(), this.getValueExprAttr()));
        }

        @Override
        public boolean hasFactory() {
            return this.getFactory() != null && this.getFactory().supports((IAdaptable)this.getDocumentContext());
        }

        public AbstractContextSymbolFactory getFactory() {
            return (AbstractContextSymbolFactory)JSFCommonPlugin.getSymbolFactories().get(this.symbolFactory);
        }
    }
}

