/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.collection.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.collection.IStructuredModelCollectionVisitor;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.Preferences;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class StructuredModelCollectionVisitorBuilder {
    private String modelVisitorClassName = null;
    private String modelVisitorFactoryClassName = null;
    private Expression expression = null;
    private List<String> dependentTechnologies = null;
    private final String pluginID;

    public StructuredModelCollectionVisitorBuilder(String pluginID) {
        this.pluginID = pluginID;
    }

    public IStructuredModelCollectionVisitor build() {
        if (this.modelVisitorClassName == null && this.modelVisitorFactoryClassName == null) {
            throw new IllegalStateException("Exactly one of model-visitor-class or model-visitor-factory is allowed");
        }
        IStructuredModelCollectionVisitor smv = null;
        if (this.modelVisitorClassName != null) {
            smv = (IStructuredModelCollectionVisitor)PluginUtil.instantiate((String)this.pluginID, (String)this.modelVisitorClassName, IStructuredModelCollectionVisitor.class);
            if (smv == null) {
                LoggingService.logError((String)"oracle.eclipse.tools.common.services", (String)("Unable to instantiate " + this.modelVisitorClassName + " for plugin " + this.pluginID));
            }
        } else {
            Class modelVisitorFactoryClass = PluginUtil.loadClass((String)this.pluginID, (String)this.modelVisitorFactoryClassName);
            if (modelVisitorFactoryClass != null) {
                try {
                    Method getModelVisitorMethod = modelVisitorFactoryClass.getMethod("getModelVisitor", null);
                    Object modelVisitor = getModelVisitorMethod.invoke(null, null);
                    if (modelVisitor instanceof IStructuredModelCollectionVisitor) {
                        smv = (IStructuredModelCollectionVisitor)modelVisitor;
                    } else {
                        LoggingService.logError((String)"oracle.eclipse.tools.common.services", (String)(String.valueOf(this.modelVisitorFactoryClassName) + "#getModelVisitor() did not return an instance of IStructuredModelCollectionVisitor"));
                    }
                }
                catch (NoSuchMethodException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
            }
        }
        return smv;
    }

    public StructuredModelCollectionVisitorBuilder setModelVisitorClass(String modelVisitorClassName) {
        if (this.modelVisitorFactoryClassName != null) {
            throw new IllegalStateException("Exactly one of modelVisitor-class or modelVisitor-factory is allowed");
        }
        this.modelVisitorClassName = modelVisitorClassName;
        return this;
    }

    public StructuredModelCollectionVisitorBuilder setModelVisitorFactoryClass(String modelVisitorFactoryClassName) {
        if (this.modelVisitorClassName != null) {
            throw new IllegalStateException("Exactly one of model-visitor-class or model-visitor-factory is allowed");
        }
        this.modelVisitorFactoryClassName = modelVisitorFactoryClassName;
        return this;
    }

    public StructuredModelCollectionVisitorBuilder setEnablementExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    public StructuredModelCollectionVisitorBuilder setDependentTechnologies(String technologies) {
        if (technologies != null && !technologies.equals("")) {
            this.dependentTechnologies = StringUtil.split((String)technologies, (char)',');
        }
        return this;
    }

    public boolean isEnabledFor(IProject project) throws CoreException {
        boolean isEnabled = true;
        if (this.expression != null) {
            EvaluationContext evalContext = new EvaluationContext(null, (Object)project);
            evalContext.setAllowPluginActivation(true);
            boolean bl = isEnabled = EvaluationResult.TRUE == this.expression.evaluate((IEvaluationContext)evalContext);
        }
        if (!isEnabled) {
            return false;
        }
        Project prj = (Project)project.getAdapter(Project.class);
        if (prj == null) {
            return false;
        }
        Set activeExtensions = prj.getTechnologyExtensions();
        HashMap<String, HashSet<String>> techMap = new HashMap<String, HashSet<String>>(activeExtensions.size(), 1.0f);
        for (ITechnologyExtension ite : activeExtensions) {
            HashSet<String> versionSet = (HashSet<String>)techMap.get(ite.getId());
            if (versionSet == null) {
                versionSet = new HashSet<String>();
                techMap.put(ite.getId(), versionSet);
            }
            versionSet.add(ite.getVersion());
        }
        if (this.dependentTechnologies != null) {
            Preferences prefs = Activator.getDefault().getPreferences().getProjectPreferences(project);
            for (String dependentTechStr : this.dependentTechnologies) {
                List techStrs = StringUtil.split((String)dependentTechStr, (char)'|');
                boolean isTechStrEnabled = false;
                for (String technology : techStrs) {
                    technology = technology.trim();
                    int colonIndex = technology.indexOf(58);
                    String tech = null;
                    String version = null;
                    if (colonIndex != -1) {
                        tech = technology.substring(0, colonIndex);
                        version = technology.substring(colonIndex + 1);
                    } else {
                        tech = technology;
                    }
                    Set activeVersions = (Set)techMap.get(tech);
                    if (activeVersions == null) continue;
                    if (version == null) {
                        boolean hasAnyEnabledVersion = false;
                        for (String activeVersion : activeVersions) {
                            if (!prefs.isTechnologyExtensionActiveForCollection(tech, activeVersion)) continue;
                            hasAnyEnabledVersion = true;
                            break;
                        }
                        isTechStrEnabled = hasAnyEnabledVersion;
                    } else if (activeVersions.contains(version)) {
                        isTechStrEnabled = prefs.isTechnologyExtensionActiveForCollection(tech, version);
                    }
                    if (isTechStrEnabled) break;
                }
                if (!(isEnabled &= isTechStrEnabled)) break;
            }
        }
        return isEnabled;
    }

    public String toString() {
        return this.modelVisitorClassName != null ? this.modelVisitorClassName : this.modelVisitorFactoryClassName;
    }
}

