/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.collection;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.collection.AbstractTagCollector;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentCollectionContext;
import oracle.eclipse.tools.application.common.services.collection.StringElValueExpressionToResourceBundleKeyPairConverter;
import oracle.eclipse.tools.application.common.services.collection.StructuredDocumentResourceLocationFactory;
import oracle.eclipse.tools.application.common.services.include.model.IMergedModelNode;
import oracle.eclipse.tools.application.common.services.resource.ResourceBundleKeyPair;
import oracle.eclipse.tools.application.common.services.util.UrlUtil;
import oracle.eclipse.tools.application.common.services.variables.DocumentVariableQuery;
import oracle.eclipse.tools.application.common.services.variables.ELExpression;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceELParser;
import oracle.eclipse.tools.application.common.services.webapp.WebAppFolderMapper;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ArtifactException;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceReference;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.URLReference;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IFilePositionContext;
import oracle.eclipse.tools.common.util.wtp.webxml.WebXmlUtils;
import oracle.eclipse.tools.xml.model.emfbinding.dom.FeatureData;
import oracle.eclipse.tools.xml.model.emfbinding.dom.IFeatureData;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.metadata.TleiAccess;
import oracle.eclipse.tools.xml.model.metadata.tlei.DependencyType;
import oracle.eclipse.tools.xml.model.metadata.tlei.SubTypes;
import oracle.eclipse.tools.xml.model.service.IXMLMetadataContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class TagCollector
extends AbstractTagCollector {
    private static final List<SubTypes> ALL_INTERESTING_TYPES;

    static {
        ArrayList<SubTypes> types = new ArrayList<SubTypes>(3);
        types.add(SubTypes.URI_SUBTYPE);
        types.add(SubTypes.IMAGE_URI_SUBTYPE);
        types.add(SubTypes.XML_URI_SUBTYPE);
        ALL_INTERESTING_TYPES = Collections.unmodifiableList(types);
    }

    public TagCollector(INamespaceContext namespaceContext, IXMLMetadataContext mdContext, IStructuredDocumentCollectionContext collectionContext, AbstractTagCollector.AbstractTagContextUriResolver contextUriResolver, StructuredDocumentResourceLocationFactory locationFactory, IFile baseFile, String collectorID) {
        super(namespaceContext, mdContext, collectionContext, contextUriResolver, locationFactory, baseFile, collectorID);
    }

    public void collectArtifacts(IDOMElement element, IFile targetFile, IProgressMonitor monitor) throws ArtifactException {
        IMergedModelNode mmNode = (IMergedModelNode)element.getAdapterFor(IMergedModelNode.class);
        if (mmNode == null || !mmNode.isRuntimeIncluded()) {
            ResourceArtifact fileArtifact = this.getCollectionContext().ensureResourceArtifact((IResource)targetFile);
            List featuresWithSubtype = this.getTagMetadata().findFeaturesWithSubtype((Node)element, ALL_INTERESTING_TYPES);
            for (IFeatureData featureData : featuresWithSubtype) {
                this.collectUri(targetFile, element, (IFeatureData<Object>)featureData, (IArtifact)fileArtifact);
            }
        }
    }

    private final void collectUri(IFile referringResource, IDOMElement docElem, IFeatureData<Object> tagAttr, IArtifact artifact) {
        for (FeatureData.ValueHolder valueHolder : tagAttr.getValues()) {
            Node valueSourceNode;
            Object value = valueHolder.getValue();
            if (!(value instanceof String) || !((valueSourceNode = valueHolder.getNode()) instanceof IDOMNode)) continue;
            if (DependencyType.FILE_REFERENCE == TleiAccess.INSTANCE.getDependencyType(this.getMetadataContext(), (IStructuredModel)((IDOMNode)valueSourceNode).getModel(), tagAttr.getFeature())) {
                this.collectReferencedResources(referringResource, docElem, (IDOMNode)valueSourceNode, (String)value, artifact);
            }
            if (DependencyType.FILE_DEPENDENCY != TleiAccess.INSTANCE.getDependencyType(this.getMetadataContext(), (IStructuredModel)((IDOMNode)valueSourceNode).getModel(), tagAttr.getFeature())) continue;
            this.collectDependencies(referringResource, docElem, (IDOMNode)valueSourceNode, (String)value, artifact);
        }
    }

    private void collectDependencies(IFile referringResource, IDOMElement owningElement, IDOMNode referringNode, String originalUri, IArtifact referantArtifact) {
        IPath resolvedPath = this.getTagContextUriResolver().resolve(referringResource, owningElement, referringNode, originalUri);
        if (resolvedPath == null) {
            return;
        }
        ResourceLocation location = this.createLocation(referringNode, this.getLocationFactory());
        if (location != null) {
            IFile resourceDependedOn = ResourcesPlugin.getWorkspace().getRoot().getFile(resolvedPath);
            this.getCollectionContext().addDocumentToResourceDependancy((IResource)resourceDependedOn, location, (byte)0, this.getID());
        }
    }

    private void collectReferencedResources(IFile referringResource, IDOMElement owningElement, IDOMNode referringNode, String originalUri, IArtifact referantArtifact) {
        ResourceLocation location = this.createLocation(referringNode, this.getLocationFactory());
        if (location == null) {
            return;
        }
        IPath resolvedPath = this.getTagContextUriResolver().resolve(referringResource, owningElement, referringNode, originalUri);
        if (resolvedPath == null) {
            ELExpression expression = this.parseElExpression(originalUri);
            if (expression != null) {
                IDocument doc = (IDocument)referringResource.getAdapter(IDocument.class);
                DocumentVariableQuery bundleVarQuery = new DocumentVariableQuery(doc, (int)location.getRange().getOffset());
                FilePositionContext positionContext = new FilePositionContext((int)location.getRange().getOffset(), (IFile)location.getResource());
                StringElValueExpressionToResourceBundleKeyPairConverter converter = new StringElValueExpressionToResourceBundleKeyPairConverter((IFilePositionContext)positionContext, bundleVarQuery);
                ResourceBundleKeyPair keyPair = (ResourceBundleKeyPair)converter.convert(originalUri);
                if (keyPair != null && keyPair.getValue() != null) {
                    IPath resolvedValue = this.getTagContextUriResolver().resolve(referringResource, owningElement, referringNode, keyPair.getValue().trim());
                    IFile referencedFile = ResourcesPlugin.getWorkspace().getRoot().getFile(resolvedValue);
                    ResourceReference reference = new ResourceReference(referantArtifact, location, (IResource)referencedFile, this.getID());
                    this.getCollectionContext().addReferencedArtifact(referantArtifact, (IArtifactReference)reference, true, (byte)0);
                }
            } else {
                URL url = null;
                try {
                    URI uri = UrlUtil.getURI(originalUri);
                    if (uri != null && uri.isAbsolute()) {
                        url = uri.toURL();
                    }
                }
                catch (MalformedURLException malformedURLException) {}
                if (url != null && (UrlUtil.looksLikeWebUri(originalUri) || UrlUtil.looksLikeWebUri(url.getHost()))) {
                    URLReference reference = new URLReference(url, referantArtifact);
                    reference.addLocation((IArtifactReferenceLocation)new ArtifactReferenceLocation(location, true, this.getID()));
                    this.getCollectionContext().addReferencedArtifact(referantArtifact, (IArtifactReference)reference, true, (byte)0);
                }
            }
            return;
        }
        IFile referencedFile = ResourcesPlugin.getWorkspace().getRoot().getFile(resolvedPath);
        this.getCollectionContext().addReferencedResource(referantArtifact, (IResource)referencedFile, true, location, (byte)0, this.getID());
    }

    private ELExpression parseElExpression(String expressionString) {
        ValueReferenceELParser parser = new ValueReferenceELParser();
        ELExpression expression = parser.getELExpression(expressionString.trim());
        return expression;
    }

    public static class DefaultTagContextUriResolver
    extends AbstractTagCollector.AbstractTagContextUriResolver {
        @Override
        public IPath resolve(IFile referringResource, IDOMElement owningElement, IDOMNode referringNode, String originalUri) {
            IProject project;
            URI uri = UrlUtil.getURI(originalUri);
            if (referringResource == null) {
                return null;
            }
            if (uri == null) {
                try {
                    if (!(originalUri.contains("#{") || originalUri.contains("\n") || originalUri.contains("\r"))) {
                        uri = URIUtil.fromString((String)originalUri);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {}
                if (uri == null) {
                    return null;
                }
            }
            if (WebXmlUtils.isMappedUri((IProject)(project = referringResource.getProject()), (String)uri.toString())) {
                return null;
            }
            if (uri.isAbsolute() || UrlUtil.looksLikeWebUri(uri.toString())) {
                return null;
            }
            WebAppFolderMapper mapper = new WebAppFolderMapper(project);
            IPath resolvedPath = mapper.resolveUri((IResource)referringResource, uri.toString());
            return resolvedPath;
        }
    }
}

