/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.collection;

import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public final class StructuredDocumentRangeFactory {
    public final Range createRange(IDOMElement element) {
        IStructuredDocumentRegion startRegion = element.getStartStructuredDocumentRegion();
        IStructuredDocumentRegion endRegion = element.getEndStructuredDocumentRegion();
        endRegion = endRegion != null ? endRegion : startRegion;
        int startOffset = startRegion.getStartOffset();
        int end = endRegion.getEndOffset();
        return new Range((long)startOffset, (long)(end - startOffset + 1));
    }

    public final Range createRangeToEndOfDoc(IDOMElement element) {
        IStructuredDocumentRegion startRegion = element.getStartStructuredDocumentRegion();
        int end = ((IDOMDocument)element.getOwnerDocument()).getEndOffset();
        int startOffset = startRegion.getStartOffset();
        return new Range((long)startOffset, (long)(end - startOffset + 1));
    }

    public Range createRangeForAttributeValue(IDOMAttr domAttr) {
        int startOffset = domAttr.getValueRegionStartOffset();
        String attrText = domAttr.getValueRegionText();
        int length = attrText == null ? 0 : attrText.length();
        return new Range((long)startOffset, (long)length);
    }
}

