/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.collection;

import java.util.Collection;
import java.util.List;
import oracle.eclipse.tools.application.common.services.resource.IResourceBundleExt;
import oracle.eclipse.tools.application.common.services.resource.ResourceBundleExtFactory;
import oracle.eclipse.tools.application.common.services.resource.ResourceBundleKeyPair;
import oracle.eclipse.tools.application.common.services.variables.ELExpression;
import oracle.eclipse.tools.application.common.services.variables.JavaResourceBundleDataType;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceELParser;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.document.IFilePositionContext;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.runtime.Plugin;

public class StringElValueExpressionToResourceBundleKeyPairConverter
extends Converter {
    private final VariableQuery _varQuery;
    private final IFilePositionContext _context;

    public StringElValueExpressionToResourceBundleKeyPairConverter(IFilePositionContext context, VariableQuery varQuery) {
        super(String.class, ResourceBundleKeyPair.class);
        this._varQuery = varQuery;
        this._context = context;
    }

    public Object convert(Object fromObject) {
        if (!(fromObject instanceof String)) {
            return null;
        }
        ValueReferenceELParser parser = new ValueReferenceELParser();
        ELExpression expression = parser.getELExpression(((String)fromObject).trim());
        if (expression != null) {
            ValueReferenceELParser elParser = new ValueReferenceELParser();
            List<ValueReferenceELParser.ValueReferenceELExpr> expressions = elParser.getExpressions(expression.getElText());
            if (expressions.size() == 0) {
                return null;
            }
            if (expressions.size() > 1) {
                LoggingService.logDebug((Plugin)Activator.getDefault(), (String)"Found more than one expression");
            }
            ValueReferenceELParser.ValueReferenceELExpr expr = expressions.get(0);
            String variableName = expr.getModelObjectName();
            List<String> fields = expr.getPropertyObjectNames();
            return this.resolveToResourceBundleKeyPair(variableName, fields);
        }
        return null;
    }

    public ResourceBundleKeyPair resolveToResourceBundleKeyPair(String variableName, List<String> fields) {
        if (fields.size() == 0) {
            return null;
        }
        if (fields.size() > 1) {
            LoggingService.logDebug((Plugin)Activator.getDefault(), (String)"Found more than one field");
        }
        String key = fields.get(0);
        NameMatcherForResourceBundleVar matcher = new NameMatcherForResourceBundleVar(variableName, ResolutionTime.RUNTIME_VISIBLE_TYPES);
        List<Variable> variables = this._varQuery.findVariable(matcher);
        if (variables.size() == 0) {
            return null;
        }
        if (variables.size() > 1) {
            LoggingService.logDebug((Plugin)Activator.getDefault(), (String)"Found more than one variable");
        }
        Variable var = variables.get(0);
        IResourceBundleExt bundleExt = ResourceBundleExtFactory.INSTANCE.create(this._context, (JavaResourceBundleDataType)var.getType(), var);
        return new ResourceBundleKeyPair(bundleExt, key);
    }

    public static class NameMatcherForResourceBundleVar
    extends VariableQuery.NameMatcher {
        private final Collection<ResolutionTime> _rt;

        public NameMatcherForResourceBundleVar(String name, Collection<ResolutionTime> rt) {
            super(name);
            this._rt = rt;
        }

        @Override
        public boolean matches(Variable variable) {
            return super.matches(variable) && variable.getType() instanceof JavaResourceBundleDataType && this._rt.contains((Object)variable.getResolutionType());
        }
    }
}

