/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.collection;

import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentCollectionContext;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentResourceCollectionContext;
import oracle.eclipse.tools.application.common.services.collection.IStructuredModelCollectionVisitor;
import oracle.eclipse.tools.common.services.dependency.artifact.IResourceContext;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ContentTypeCollectionFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.IResourceCollectionContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.NodeList;

public abstract class AbstractXpathCollector
implements IStructuredModelCollectionVisitor {
    private XPathFactory xpathFactory = XPathFactory.newInstance();
    private NamespaceContext namespaceContext;
    private IStructuredDocumentCollectionContext collectionContext;
    private IStructuredDocumentResourceCollectionContext resourceContext;

    public final boolean visit(IDOMNode node) {
        return false;
    }

    public final boolean visit(IDOMElement element) {
        return false;
    }

    public final boolean visit(IDOMDocument document) {
        this.collectDocument(document);
        return false;
    }

    public final boolean visit(IDOMAttr attribute) {
        return false;
    }

    @Override
    public void startCollecting(IStructuredDocumentCollectionContext context, IProgressMonitor monitor) {
        this.namespaceContext = this.getNamespaceContext();
        this.collectionContext = context;
    }

    @Override
    public IStatus stopCollecting(IProgressMonitor monitor) {
        this.namespaceContext = null;
        this.collectionContext = null;
        return null;
    }

    @Override
    public void beginResource(IStructuredDocumentResourceCollectionContext structuredResourceContext, IProgressMonitor monitor) {
        this.resourceContext = structuredResourceContext;
        this.resourceContext.resetCollection(this.getID());
    }

    @Override
    public void endResource(IStructuredDocumentResourceCollectionContext structuredResourceContext, IProgressMonitor monitor) {
        this.resourceContext = null;
    }

    @Override
    public Set<IResource> getDependentResources(Set<IResource> changedResources, IProgressMonitor monitor) {
        return Collections.emptySet();
    }

    public IStructuredDocumentCollectionContext getCollectionContext() {
        return this.collectionContext;
    }

    public IStructuredDocumentResourceCollectionContext getResourceContext() {
        return this.resourceContext;
    }

    protected NodeList getNodes(IDOMNode parent, String xpathExpression) {
        XPath xpath = this.xpathFactory.newXPath();
        xpath.setNamespaceContext(this.namespaceContext);
        try {
            return (NodeList)xpath.evaluate(xpathExpression, parent, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            Activator.log("Evaluating xpath expression", e);
            return null;
        }
    }

    @Override
    public final boolean match(IResourceCollectionContext context) {
        ContentTypeCollectionFilter filter = new ContentTypeCollectionFilter(this.getDocumentContentTypes());
        boolean isMatchingType = filter.match((IResourceContext)context);
        if (isMatchingType && !this.collectDerivedResources()) {
            IResource res = context.getResource();
            return !res.isDerived();
        }
        return isMatchingType;
    }

    protected boolean collectDerivedResources() {
        return true;
    }

    protected abstract void collectDocument(IDOMDocument var1);

    protected abstract NamespaceContext getNamespaceContext();

    protected abstract Set<String> getDocumentContentTypes();
}

