/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.collection;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.TraceOptions;
import oracle.eclipse.tools.common.services.dependency.artifact.IResourceContext;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ContentTypeCollectionFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ICollectionFilter;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.AbstractSimpleDiscoveryParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IResourceDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IStructuredXMLModelVisitor;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.StructuredModelFactory;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public abstract class AbstractWebDiscoveryParticipant
extends AbstractSimpleDiscoveryParticipant
implements IDiscoveryParticipant {
    private static final String CTYPE_JSPSOURCE = "org.eclipse.jst.jsp.core.jspsource";
    private static final String CTYPE_JSPFRAGMENTSOURCE = "org.eclipse.jst.jsp.core.jspfragmentsource";
    private static final Set<String> CONTENT_TYPE;
    protected static final ICollectionFilter JSP_FILTER;
    private final String _id;
    private final InjectableDependencies _dependencies;
    private boolean _wasInitForFileCalled = false;

    static {
        LinkedHashSet<String> types = new LinkedHashSet<String>(2, 1.0f);
        types.add(CTYPE_JSPSOURCE);
        types.add(CTYPE_JSPFRAGMENTSOURCE);
        CONTENT_TYPE = Collections.unmodifiableSet(types);
        JSP_FILTER = new ContentTypeCollectionFilter(CONTENT_TYPE);
    }

    public AbstractWebDiscoveryParticipant(String id, InjectableDependencies dependencies) {
        this._id = id;
        this._dependencies = dependencies;
    }

    protected InjectableDependencies getDependencies() {
        return this._dependencies;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void discover(IResourceDiscoveryContext context, IProgressMonitor monitor) {
        if (!this.getDependencies().isInitialized() && !this.doPreDiscoverInit(context)) {
            return;
        }
        IFile file = this.getDependencies().getFile();
        IVisitableDOMModel model = null;
        try {
            try {
                long timestamp = 0L;
                String participantName = null;
                if (TraceOptions.APPXRAY_PERF) {
                    timestamp = System.nanoTime();
                }
                model = StructuredModelFactory.getVisitableModelForRead((IFile)file);
                if (TraceOptions.APPXRAY_PERF && model != null) {
                    participantName = ((Object)((Object)this)).getClass().getSimpleName();
                    TraceOptions.log(String.valueOf(participantName) + " get structured model (" + file.getName() + ") time ns, " + (System.nanoTime() - timestamp));
                    timestamp = System.nanoTime();
                }
                if (model == null) {
                    LoggingService.logError((Plugin)Activator.getDefault(), (String)"Unable to discover from null model.");
                } else {
                    this.doDiscover(model);
                }
                if (!TraceOptions.APPXRAY_PERF) return;
                TraceOptions.log(String.valueOf(participantName) + " process the model (" + file.getName() + ") time ns, " + (System.nanoTime() - timestamp));
                return;
            }
            catch (CoreException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
                if (model == null) return;
                model.dispose();
                this.getDependencies().clear();
                return;
            }
            catch (IOException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
                if (model == null) return;
                model.dispose();
                this.getDependencies().clear();
                return;
            }
        }
        finally {
            if (model != null) {
                model.dispose();
                this.getDependencies().clear();
            }
        }
    }

    private boolean doPreDiscoverInit(IResourceDiscoveryContext context) throws IllegalStateException {
        this._wasInitForFileCalled = false;
        if (!JSP_FILTER.match((IResourceContext)context)) {
            return false;
        }
        IFile file = (IFile)context.getResource();
        if (!this.initForFile(file)) {
            return false;
        }
        if (!this._wasInitForFileCalled) {
            throw new IllegalStateException("AbstractWebDiscoveryParticipant must get called");
        }
        this.getDependencies().setInitialized();
        return true;
    }

    protected IStructuredXMLModelVisitor doDiscover(IVisitableDOMModel model) {
        IStructuredXMLModelVisitor visitor = this.createVisitor();
        model.accept(visitor);
        return visitor;
    }

    protected abstract IStructuredXMLModelVisitor createVisitor();

    public final void discoverFromExistingModel(IResourceDiscoveryContext context, IVisitableDOMModel model, IProgressMonitor monitor) {
        if (this.doPreDiscoverInit(context)) {
            this.doDiscover(model);
        }
    }

    public final String getID() {
        return this._id;
    }

    public final void startDiscovery(IDiscoveryContext context, IProgressMonitor monitor) {
        this.doStartDiscovery(context);
    }

    protected void doStartDiscovery(IDiscoveryContext context) {
    }

    protected boolean initForFile(IFile file) {
        this._wasInitForFileCalled = true;
        this.getDependencies().setFile(file);
        IDocument document = (IDocument)file.getAdapter(IDocument.class);
        if (document != null) {
            this.getDependencies().setDocument(document);
            return true;
        }
        return false;
    }

    public IStatus stopDiscovery(IProgressMonitor monitor) {
        return this.doStopDiscovery();
    }

    protected IStatus doStopDiscovery() {
        return Status.OK_STATUS;
    }

    public static class InjectableDependencies {
        private IFile _file;
        private IDocument _document;
        private boolean _debugEnabled;
        private boolean _isInitialized;

        public InjectableDependencies() {
        }

        public void setInitialized() {
            this._isInitialized = true;
        }

        protected boolean isInitialized() {
            return this._isInitialized;
        }

        public InjectableDependencies(IDocument document) {
            this();
            this._document = document;
            this._file = document.getFile();
        }

        public void clear() {
            this._file = null;
            this._document = null;
            this._isInitialized = false;
        }

        public final IFile getFile() {
            return this._file;
        }

        public final void setFile(IFile file) {
            this._file = file;
        }

        public final IDocument getDocument() {
            return this._document;
        }

        public final void setDocument(IDocument document) {
            this._document = document;
        }

        public void setDebugEnabled(boolean debugEnabled) {
            this._debugEnabled = debugEnabled;
        }

        public boolean isDebugEnabled() {
            return this._debugEnabled;
        }
    }
}

