/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.appservices;

import java.util.EventObject;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.eclipse.tools.common.services.project.app.services.IAppService;
import org.eclipse.core.resources.IProject;

public interface IDesignTimeLocaleService
extends IAppService {
    public Locale getCurrentLocale();

    public Boolean storeCurrentLocale(Locale var1);

    public void addCurrentLocaleListener(ICurrentLocaleListener var1);

    public void removeCurrentLocaleListener(ICurrentLocaleListener var1);

    public static final class CurrentLocaleUpdateEvent
    extends EventObject {
        private static final long serialVersionUID = 2389396545228989944L;
        private final Locale _oldLocale;
        private final Locale _newLocale;
        private final IProject _affectedProject;

        public CurrentLocaleUpdateEvent(IDesignTimeLocaleService source, Locale oldLocale, Locale newLocale, IProject affectedProject) {
            super(source);
            this._oldLocale = oldLocale;
            this._newLocale = newLocale;
            this._affectedProject = affectedProject;
        }

        public final Locale getOldLocale() {
            return this._oldLocale;
        }

        public final Locale getNewLocale() {
            return this._newLocale;
        }

        public final IProject getAffectedProject() {
            return this._affectedProject;
        }
    }

    public static class GlobalLocaleListeners {
        protected static final CopyOnWriteArrayList<ICurrentLocaleListener> _GLOBAL_LISTENERS = new CopyOnWriteArrayList();

        public static void addGlobalLocaleListener(ICurrentLocaleListener listener) {
            _GLOBAL_LISTENERS.addIfAbsent(listener);
        }

        public static void removeGlobalLocaleListener(ICurrentLocaleListener listener) {
            _GLOBAL_LISTENERS.remove(listener);
        }
    }

    public static interface ICurrentLocaleListener {
        public void localeChanged(CurrentLocaleUpdateEvent var1);
    }
}

