/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services;

import java.io.Serializable;
import java.net.URL;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.ObjectUtil;

public class FileMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int WANNABE_ERROR = 2;
    public static final int INFORMATION = 3;
    private String mMessage;
    private int mType;
    private URL mUrl;
    private int mOffset;
    private int mLen;

    public FileMessage(String message, int type, URL url, int offset, int len) {
        this(message, type);
        this.mUrl = url;
        this.mOffset = offset;
        this.mLen = len;
    }

    protected FileMessage(String message, int type) {
        this.mMessage = message;
        this.mType = type;
    }

    public void setUrl(URL url, int offset, int len) {
        this.mUrl = url;
        this.mOffset = offset;
        this.mLen = len;
    }

    public int getType() {
        return this.mType;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public URL getUrl() {
        return this.mUrl;
    }

    public int getRangeOffset() {
        return this.mOffset;
    }

    public int getRangeLen() {
        return this.mLen;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileMessage)) {
            return false;
        }
        FileMessage other = (FileMessage)obj;
        if (ObjectUtil.equalObjects((Object)this.getUrl(), (Object)other.getUrl())) {
            return this.getType() == other.getType() && ObjectUtil.equalObjects((Object)this.mMessage, (Object)other.mMessage);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        HashCodeUtil hcu = HashCodeUtil.newInstance();
        return hcu.hash((Object)this.getUrl()).hash(this.getType()).hash((Object)this.mMessage).getHashCode();
    }
}

