/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.refactoring.PDERenameParticipant;

public class ManifestTypeRenameParticipant
extends PDERenameParticipant {
    protected boolean initialize(Object element) {
        IType type;
        IJavaProject javaProject;
        IProject project;
        if (element instanceof IType && WorkspaceModelManager.isPluginProject((IProject)(project = (javaProject = (IJavaProject)(type = (IType)element).getAncestor(2)).getProject()))) {
            this.fProject = javaProject.getProject();
            this.fElements = new HashMap();
            this.fElements.put(type, this.getArguments().getNewName());
            return true;
        }
        return false;
    }

    protected String[] getOldNames() {
        String[] result = new String[this.fElements.size()];
        Iterator iter = this.fElements.keySet().iterator();
        int i = 0;
        while (i < this.fElements.size()) {
            result[i] = ((IType)iter.next()).getFullyQualifiedName('$');
            ++i;
        }
        return result;
    }

    @Override
    protected String[] getNewNames() {
        String[] result = new String[this.fElements.size()];
        Iterator iter = this.fElements.keySet().iterator();
        int i = 0;
        while (i < this.fElements.size()) {
            IType type = (IType)iter.next();
            String oldName = type.getFullyQualifiedName('$');
            int index = oldName.lastIndexOf(type.getElementName());
            StringBuffer buffer = new StringBuffer(oldName.substring(0, index));
            buffer.append((String)this.fElements.get(type));
            result[i] = buffer.toString();
            ++i;
        }
        return result;
    }

    public String getName() {
        return PDEUIMessages.ManifestTypeRenameParticipant_composite;
    }
}

