/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.workspace.internal;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FileName;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.services.FileExtensionsService;
import org.eclipse.sapphire.services.InitialValueService;
import org.eclipse.sapphire.services.InitialValueServiceData;
import org.eclipse.sapphire.services.ReferenceService;
import org.eclipse.sapphire.services.RelativePathService;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.sapphire.workspace.CreateWorkspaceFileOp;

public final class CreateWorkspaceFileOpServices {
    @Text(value="Folder must be specified")
    private static LocalizableText folderMustBeSpecified;
    @Text(value="Project \"{0}\" does not exist or is not accessible")
    private static LocalizableText projectDoesNotExist;
    @Text(value="File \"{0}\" already exists")
    private static LocalizableText fileExists;
    @Text(value="File extension should be \"{0}\"")
    private static LocalizableText invalidFileExtensionOne;
    @Text(value="File extension should be \"{0}\" or \"{1}\"")
    private static LocalizableText invalidFileExtensionTwo;
    @Text(value="File extension should be one of \"{0}\"")
    private static LocalizableText invalidFileExtensionMultiple;

    static {
        LocalizableText.init(CreateWorkspaceFileOpServices.class);
    }

    public static final class FileReferenceService
    extends ReferenceService {
        protected void init() {
            super.init();
            FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    FileReferenceService.this.broadcast();
                }
            };
            CreateWorkspaceFileOp op = (CreateWorkspaceFileOp)this.context(CreateWorkspaceFileOp.class);
            op.getRoot().attach((Listener)listener);
            op.getFolder().attach((Listener)listener);
        }

        public Object resolve(String reference) {
            CreateWorkspaceFileOp op = (CreateWorkspaceFileOp)this.context(CreateWorkspaceFileOp.class);
            IContainer folder = (IContainer)op.getFolder().resolve();
            if (reference == null || folder == null || folder instanceof IWorkspaceRoot) {
                return null;
            }
            return folder.getFile((IPath)new Path(reference));
        }
    }

    public static final class FileValidationService
    extends ValidationService {
        protected void initValidationService() {
            Value value = (Value)this.context(Value.class);
            CreateWorkspaceFileOp op = (CreateWorkspaceFileOp)value.nearest(CreateWorkspaceFileOp.class);
            FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    FileValidationService.this.refresh();
                }
            };
            op.getFolder().attach((Listener)listener);
            op.getOverwriteExistingFile().attach((Listener)listener);
            FileExtensionsService fileExtensionsService = (FileExtensionsService)value.service(FileExtensionsService.class);
            if (fileExtensionsService != null) {
                fileExtensionsService.attach(new Listener(){

                    public void handle(Event event) {
                        FileValidationService.this.refresh();
                    }
                });
            }
        }

        protected Status compute() {
            Value value = (Value)this.context(Value.class);
            CreateWorkspaceFileOp op = (CreateWorkspaceFileOp)value.nearest(CreateWorkspaceFileOp.class);
            FileName fileName = (FileName)value.content();
            if (fileName != null) {
                IFile fileHandle;
                List extensions;
                int count;
                FileExtensionsService fileExtensionsService;
                String extension = fileName.extension();
                if (extension != null && (fileExtensionsService = (FileExtensionsService)value.service(FileExtensionsService.class)) != null && (count = (extensions = fileExtensionsService.extensions()).size()) > 0) {
                    boolean match = false;
                    for (String ext : extensions) {
                        if (!extension.equalsIgnoreCase(ext)) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        String message;
                        if (count == 1) {
                            message = invalidFileExtensionOne.format(new Object[]{extensions.get(0)});
                        } else if (count == 2) {
                            message = invalidFileExtensionTwo.format(new Object[]{extensions.get(0), extensions.get(1)});
                        } else {
                            StringBuilder buf = new StringBuilder();
                            for (String ext : extensions) {
                                if (buf.length() != 0) {
                                    buf.append(", ");
                                }
                                buf.append(ext);
                            }
                            message = invalidFileExtensionMultiple.format(new Object[]{buf.toString()});
                        }
                        return Status.createWarningStatus((String)message);
                    }
                }
                if ((fileHandle = (IFile)op.getFile().resolve()) != null && fileHandle.exists() && !((Boolean)op.getOverwriteExistingFile().content()).booleanValue()) {
                    String msg = fileExists.format(new Object[]{fileName});
                    return Status.factoryForLeaf().severity(Status.Severity.ERROR).type("Sapphire.Workspace.CreateFileOp.FileExists").message(msg).create();
                }
            }
            return Status.createOkStatus();
        }
    }

    public static final class FolderInitialValueService
    extends InitialValueService {
        protected void initInitialValueService() {
            FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    FolderInitialValueService.this.refresh();
                }
            };
            ((CreateWorkspaceFileOp)this.context(CreateWorkspaceFileOp.class)).getContext().attach((Listener)listener);
        }

        protected InitialValueServiceData compute() {
            CreateWorkspaceFileOp op = (CreateWorkspaceFileOp)this.context(CreateWorkspaceFileOp.class);
            IResource resource = (IResource)op.getContext().content();
            if (resource instanceof IFile) {
                resource = resource.getParent();
            }
            return new InitialValueServiceData(resource == null ? null : resource.getFullPath().makeRelative().toPortableString());
        }
    }

    public static final class FolderReferenceService
    extends ReferenceService {
        protected void init() {
            super.init();
            ((CreateWorkspaceFileOp)this.context(CreateWorkspaceFileOp.class)).getRoot().attach((Listener)new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    FolderReferenceService.this.broadcast();
                }
            });
        }

        public Object resolve(String reference) {
            CreateWorkspaceFileOp op = (CreateWorkspaceFileOp)this.context(CreateWorkspaceFileOp.class);
            IContainer root = (IContainer)op.getRoot().resolve();
            if (reference == null) {
                return root;
            }
            Path path = new Path(reference);
            if (root instanceof IWorkspaceRoot && path.segmentCount() == 1) {
                return ((IWorkspaceRoot)root).getProject(path.segment(0));
            }
            return root.getFolder((IPath)path);
        }
    }

    public static final class FolderRelativePathService
    extends RelativePathService {
        public List<org.eclipse.sapphire.modeling.Path> roots() {
            CreateWorkspaceFileOp op = (CreateWorkspaceFileOp)this.context(CreateWorkspaceFileOp.class);
            IContainer root = (IContainer)op.getRoot().resolve();
            if (root == null) {
                return ListFactory.empty();
            }
            return ListFactory.singleton((Object)new org.eclipse.sapphire.modeling.Path(root.getLocation().toString()));
        }

        public org.eclipse.sapphire.modeling.Path convertToRelative(org.eclipse.sapphire.modeling.Path path) {
            CreateWorkspaceFileOp op = (CreateWorkspaceFileOp)this.context(CreateWorkspaceFileOp.class);
            IContainer root = (IContainer)op.getRoot().resolve();
            if (root instanceof IWorkspaceRoot) {
                IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    org.eclipse.sapphire.modeling.Path location = new org.eclipse.sapphire.modeling.Path(project.getLocation().toPortableString());
                    if (location.isPrefixOf(path)) {
                        return new org.eclipse.sapphire.modeling.Path(project.getName()).append(path.makeRelativeTo(location));
                    }
                    ++n2;
                }
            } else {
                super.convertToRelative(path);
            }
            return null;
        }

        public org.eclipse.sapphire.modeling.Path convertToAbsolute(org.eclipse.sapphire.modeling.Path path) {
            CreateWorkspaceFileOp op = (CreateWorkspaceFileOp)this.context(CreateWorkspaceFileOp.class);
            IContainer root = (IContainer)op.getRoot().resolve();
            if (root instanceof IWorkspaceRoot) {
                if (path.segmentCount() > 0) {
                    IProject project = ((IWorkspaceRoot)root).getProject(path.segment(0));
                    return new org.eclipse.sapphire.modeling.Path(project.getLocation().toString()).append(path.removeFirstSegments(1));
                }
            } else {
                super.convertToAbsolute(path);
            }
            return null;
        }
    }

    public static final class FolderValidationService
    extends ValidationService {
        protected void initValidationService() {
            ((CreateWorkspaceFileOp)this.context(CreateWorkspaceFileOp.class)).getRoot().attach((Listener)new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    FolderValidationService.this.broadcast();
                }
            });
        }

        protected Status compute() {
            IProject project;
            ReferenceValue value = (ReferenceValue)this.context(ReferenceValue.of(org.eclipse.sapphire.modeling.Path.class, IContainer.class));
            CreateWorkspaceFileOp op = (CreateWorkspaceFileOp)value.nearest(CreateWorkspaceFileOp.class);
            if (value.empty() && op.getRoot().empty()) {
                return Status.createErrorStatus((String)folderMustBeSpecified.text());
            }
            IContainer folder = (IContainer)((ReferenceValue)this.context(ReferenceValue.of(org.eclipse.sapphire.modeling.Path.class, IContainer.class))).resolve();
            if (folder != null && (project = folder.getProject()) != null && !project.isAccessible()) {
                String msg = projectDoesNotExist.format(new Object[]{project.getName()});
                return Status.createErrorStatus((String)msg);
            }
            return Status.createOkStatus();
        }
    }

    public static final class RootReferenceService
    extends ReferenceService {
        public Object resolve(String reference) {
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            if (reference == null) {
                return wsroot;
            }
            org.eclipse.sapphire.modeling.Path root = new org.eclipse.sapphire.modeling.Path(reference);
            if (root.segmentCount() == 1) {
                return wsroot.getProject(root.segment(0));
            }
            return wsroot.getFolder(PathBridge.create((org.eclipse.sapphire.modeling.Path)root));
        }
    }
}

