/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.variables;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.jsp.variables.EclipseTypeUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class EclipseJavaTypeRetriever {
    private IJavaProject mJavaProject;
    private IType mJavaType;
    private ICompilationUnit mCompilationUnit;
    private CompilationUnit mCompilationUnitNode;
    private TypeDeclaration mTypeDeclaration;

    public EclipseJavaTypeRetriever(String className, IProject project) {
        className = className.replace('$', '.');
        this.mJavaProject = JavaCore.create((IProject)project);
        if (this.mJavaProject == null) {
            return;
        }
        try {
            this.mJavaType = this.mJavaProject.findType(className);
            if (this.mJavaType == null) {
                return;
            }
            if (this.mJavaType.isBinary() && this.mJavaType.getClassFile() != null) {
                IClassFile classFile = this.mJavaType.getClassFile();
                if (classFile.getSource() != null) {
                    ASTParser c = ASTParser.newParser((int)3);
                    c.setSource(classFile);
                    c.setResolveBindings(true);
                    this.mCompilationUnitNode = (CompilationUnit)c.createAST(null);
                }
            } else if (this.mJavaType.getCompilationUnit() != null) {
                this.mCompilationUnit = this.mJavaType.getCompilationUnit();
                ASTParser c = ASTParser.newParser((int)3);
                c.setSource(this.mCompilationUnit);
                c.setResolveBindings(true);
                this.mCompilationUnitNode = (CompilationUnit)c.createAST(null);
            }
            if (this.mCompilationUnitNode != null) {
                this.mTypeDeclaration = EclipseTypeUtil.findTypeDeclaration((ASTNode)this.mCompilationUnitNode, className);
            }
        }
        catch (JavaModelException jme) {
            LoggingService.logException((String)"oracle.eclipse.tools.webtier.jsp", (CoreException)((Object)jme));
        }
    }

    public IJavaProject getJavaProject() {
        return this.mJavaProject;
    }

    public IType getJavaType() {
        return this.mJavaType;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.mCompilationUnit;
    }

    public CompilationUnit getCompilationUnitNode() {
        return this.mCompilationUnitNode;
    }

    public TypeDeclaration getTypeDeclaration() {
        return this.mTypeDeclaration;
    }
}

