/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.validation;

import java.io.IOException;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.jsp.Activator;
import oracle.eclipse.tools.webtier.jsp.validation.AttributeValidatingStrategy;
import oracle.eclipse.tools.webtier.jsp.validation.OepeValidationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.jsf.common.dom.DOMAdapter;
import org.eclipse.jst.jsf.core.internal.region.Region2AttrAdapter;
import org.eclipse.jst.jsf.core.internal.region.Region2ElementAdapter;
import org.eclipse.jst.jsf.designtime.resolver.IStructuredDocumentSymbolResolverFactory;
import org.eclipse.jst.jsf.designtime.resolver.StructuredDocumentSymbolResolverFactory;
import org.eclipse.jst.jsf.validation.internal.IJSFViewValidator;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class OepeXmlViewDefnValidator {
    static final boolean DEBUG;
    private IStructuredDocumentSymbolResolverFactory _symbolResolverFactory = StructuredDocumentSymbolResolverFactory.getInstance();

    static {
        String value = Platform.getDebugOption((String)"oracle.eclipse.tools.webtier.jsp/validation");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    private void validateTag(IStructuredDocumentRegion container, OepeValidationContext validationContext) {
        try {
            Region2ElementAdapter regionAdapter = new Region2ElementAdapter((ITextRegion)container);
            AttributeValidatingStrategy strategy = new AttributeValidatingStrategy(validationContext);
            for (Region2AttrAdapter attrAdapter : regionAdapter.getAttributes().values()) {
                if (!strategy.isInteresting((DOMAdapter)attrAdapter)) continue;
                strategy.validate((DOMAdapter)attrAdapter);
            }
        }
        catch (Region2ElementAdapter.NoElementException ne) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)ne);
        }
    }

    public void validateView(IFile viewFile, IJSFViewValidator.IValidationReporter reporter) {
        block12: {
            IStructuredModel model = null;
            if (DEBUG) {
                System.out.println("executing JSPSemanticsValidator.validateFile");
            }
            try {
                OepeValidationContext jsfValidationContext = this.createValidationContext(false, viewFile, reporter);
                if (jsfValidationContext == null) {
                    return;
                }
                try {
                    model = StructuredModelManager.getModelManager().getModelForRead(viewFile);
                    if (model != null) {
                        IStructuredDocument structuredDoc = model.getStructuredDocument();
                        IStructuredDocumentRegion[] regions = structuredDoc.getStructuredDocumentRegions();
                        this.validateRegions(regions, jsfValidationContext);
                        break block12;
                    }
                    LoggingService.logInfo((Plugin)Activator.getDefault(), (String)("Attempt to validate non-SSE file: " + viewFile.toString()));
                }
                catch (CoreException e) {
                    LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
                }
                catch (IOException e) {
                    LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
    }

    public void validateView(IFile viewFile, IStructuredDocumentRegion[] regions, IJSFViewValidator.IValidationReporter reporter) {
        OepeValidationContext validationContext = this.createValidationContext(true, viewFile, reporter);
        if (validationContext == null) {
            return;
        }
        this.validateRegions(regions, validationContext);
    }

    private void validateRegions(IStructuredDocumentRegion[] regions, OepeValidationContext context) {
        IStructuredDocumentRegion[] iStructuredDocumentRegionArray = regions;
        int n = regions.length;
        int n2 = 0;
        while (n2 < n) {
            IStructuredDocumentRegion curNode = iStructuredDocumentRegionArray[n2];
            if (curNode.getFirstRegion().getType() == "XML_TAG_OPEN") {
                this.validateTag(curNode, context);
            }
            ++n2;
        }
    }

    private OepeValidationContext createValidationContext(boolean isIncremental, IFile file, IJSFViewValidator.IValidationReporter reporter) {
        DiagnosticFactory diagnosticFactory = new DiagnosticFactory();
        return new OepeValidationContext(isIncremental, diagnosticFactory, file, reporter, this._symbolResolverFactory);
    }
}

