/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import oracle.eclipse.tools.webtier.jsp.descriptor.AttributeType;
import oracle.eclipse.tools.webtier.jsp.descriptor.DescriptionType;
import oracle.eclipse.tools.webtier.jsp.descriptor.DescriptorPackage;
import oracle.eclipse.tools.webtier.jsp.descriptor.TagType;
import oracle.eclipse.tools.webtier.jsp.descriptor.TaglibType;
import oracle.eclipse.tools.webtier.jsp.tools.ExtendedEcoreFactory;
import oracle.eclipse.tools.xml.model.emfbinding.ExtendedEcoreUtil;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;

public abstract class TLDEcoreAdvisor {
    protected static final ExtendedMetaData ExtMD = ExtendedMetaData.INSTANCE;
    protected static final List<EStructuralFeature> URI_FEATURE_PATH;
    protected static final List<EStructuralFeature> SHORT_NAME_FEATURE_PATH;
    protected static final List<EStructuralFeature> TAG_NAME_FEATURE_PATH;
    protected static final List<EStructuralFeature> ATTR_NAME_FEATURE_PATH;

    static {
        ArrayList<Object> featurePath = new ArrayList<Object>(2);
        featurePath.add(DescriptorPackage.Literals.TAGLIB_TYPE__URI);
        featurePath.add(DescriptorPackage.Literals.URI_TYPE__VALUE);
        URI_FEATURE_PATH = Collections.unmodifiableList(featurePath);
        featurePath = new ArrayList(2);
        featurePath.add(DescriptorPackage.Literals.TAGLIB_TYPE__SHORT_NAME);
        featurePath.add(DescriptorPackage.Literals.SHORT_NAME_TYPE__VALUE);
        SHORT_NAME_FEATURE_PATH = Collections.unmodifiableList(featurePath);
        featurePath = new ArrayList(2);
        featurePath.add(DescriptorPackage.Literals.TAG_TYPE__NAME);
        featurePath.add(DescriptorPackage.Literals.NAME_TYPE__VALUE);
        TAG_NAME_FEATURE_PATH = Collections.unmodifiableList(featurePath);
        featurePath = new ArrayList(2);
        featurePath.add(DescriptorPackage.Literals.ATTRIBUTE_TYPE__NAME);
        featurePath.add(DescriptorPackage.Literals.NAME_TYPE__VALUE);
        ATTR_NAME_FEATURE_PATH = Collections.unmodifiableList(featurePath);
    }

    public String getPackageName(TaglibType taglibType) {
        Object packageValue = this.safeGetNDeepFeature((EObject)taglibType, URI_FEATURE_PATH);
        if (packageValue == null) {
            throw new IllegalArgumentException("taglib must have a uri");
        }
        String strValue = this.safeGetString(packageValue, null, "", "");
        return strValue.indexOf(47) != -1 ? strValue.substring(strValue.lastIndexOf(47) + 1) : "defaultPackageName";
    }

    public String getNsPrefixName(TaglibType taglibType, String defaultValue) {
        Object value = this.safeGetNDeepFeature((EObject)taglibType, SHORT_NAME_FEATURE_PATH);
        return this.safeGetString(value, defaultValue, "[\\s]", "_");
    }

    public String getUri(TaglibType taglibType, String defaultValue) {
        Object value = this.safeGetNDeepFeature((EObject)taglibType, URI_FEATURE_PATH);
        return this.safeGetString(value, defaultValue, "[\\s]", "_");
    }

    public String getTagName(TagType tag) {
        Object value = this.safeGetNDeepFeature((EObject)tag, TAG_NAME_FEATURE_PATH);
        return this.safeGetString(value, null, "[\\s]", "_");
    }

    public String getEClassName(TagType tag) {
        String tagName = this.getTagName(tag);
        tagName = tagName.length() > 1 ? tagName.substring(0, 1).toUpperCase(Locale.getDefault()).concat(tagName.substring(1)) : tagName.toUpperCase(Locale.getDefault());
        return tagName;
    }

    public String getAttributeName(AttributeType attribute) {
        Object value = this.safeGetNDeepFeature((EObject)attribute, ATTR_NAME_FEATURE_PATH);
        return this.safeGetString(value, null, "[\\s]", "_");
    }

    public int getMinOccurs(AttributeType attribute) {
        boolean isRequired = attribute.getRequired() == null ? false : attribute.getRequired();
        return isRequired ? 1 : 0;
    }

    public int getMaxOccurs(AttributeType attribute) {
        return 1;
    }

    public boolean isDerived(AttributeType attribute) {
        return false;
    }

    public boolean isTransient(AttributeType attribute) {
        return false;
    }

    public boolean isVolatile(AttributeType attribute) {
        return false;
    }

    public void setExtendedMetaData(EAttribute attribute, String name, AttributeType attribType) {
        String value;
        ExtMD.setName((EStructuralFeature)attribute, name);
        ExtMD.setFeatureKind((EStructuralFeature)attribute, 2);
        DescriptionType description = attribType.getDescription();
        if (description != null && (value = description.getValue()) != null && !"".equals(value = value.trim())) {
            EAnnotation docAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            docAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
            docAnnotation.setEModelElement((EModelElement)attribute);
            docAnnotation.getDetails().put((Object)"documentation", (Object)value);
            attribute.getEAnnotations().add((Object)docAnnotation);
        }
    }

    public void setExtendedMetaData(EClass eclass, TagType tagType) {
        ExtMD.setName((EClassifier)eclass, ExtendedEcoreUtil.INSTANCE.getAnnotationName(this.getTagName(tagType)));
        ExtMD.setContentKind(eclass, 3);
    }

    public EClassifier getEType(AttributeType attribute) {
        return this.doETypeSwitch(attribute.getType());
    }

    public void compressDuplicateAttributes(EPackage ePackage) {
        HashMap<String, List<PossibleDuplicate>> foundAttrs = new HashMap<String, List<PossibleDuplicate>>();
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            ListIterator eAttributeIt = eClass.getEStructuralFeatures().listIterator();
            while (eAttributeIt.hasNext()) {
                EStructuralFeature feature = (EStructuralFeature)eAttributeIt.next();
                if (!(feature instanceof EAttribute)) continue;
                this.findOrAddToMap((EAttribute)feature, foundAttrs);
            }
        }
        ArrayList<EClass> newEClasses = new ArrayList<EClass>();
        int counter = 0;
        for (Map.Entry entry : foundAttrs.entrySet()) {
            if (((List)entry.getValue()).size() <= 0) continue;
            if (((List)entry.getValue()).size() > 1) {
                throw new IllegalStateException("Cannot found duplicates.  Run with foldDuplicates set to false.  Due to attribute name: " + (String)entry.getKey());
            }
            EClass newEClass = null;
            PossibleDuplicate possDup = (PossibleDuplicate)((List)entry.getValue()).get(0);
            if (!possDup.isDuplicate()) continue;
            EAttribute attr = possDup.getAttribute();
            newEClass = ExtendedEcoreFactory.INSTANCE.createEClass("CommonSuperClass" + counter++, true, false);
            newEClasses.add(newEClass);
            attr.getEContainingClass().getESuperTypes().add((Object)newEClass);
            newEClass.getEStructuralFeatures().add((Object)attr);
            for (EClass dupEClass : possDup.getDuplicateClasses()) {
                if (dupEClass == possDup.getAttribute().getEContainingClass()) continue;
                EAttribute me = (EAttribute)dupEClass.getEStructuralFeature(attr.getName());
                dupEClass.getEStructuralFeatures().remove((Object)me);
                dupEClass.getESuperTypes().add((Object)newEClass);
            }
        }
        for (EClass eClass : newEClasses) {
            ePackage.getEClassifiers().add((Object)eClass);
        }
    }

    boolean findOrAddToMap(EAttribute eAttribute, Map<String, List<PossibleDuplicate>> foundAttrs) {
        List<PossibleDuplicate> attributes = foundAttrs.get(eAttribute.getName());
        if (attributes == null) {
            attributes = new ArrayList<PossibleDuplicate>();
            foundAttrs.put(eAttribute.getName(), attributes);
        }
        for (PossibleDuplicate possibleDup : attributes) {
            if (!this.isDuplicate(eAttribute, possibleDup.getAttribute())) continue;
            possibleDup.addDuplicate(eAttribute.getEContainingClass());
            return true;
        }
        attributes.add(new PossibleDuplicate(eAttribute));
        return false;
    }

    boolean isDuplicate(EAttribute attr1, EAttribute attr2) {
        if (attr1 == attr2) {
            return true;
        }
        return attr1.getName().equals(attr2.getName()) && attr1.getEAttributeType().equals(attr2.getEAttributeType()) && ExtMD.getName((EStructuralFeature)attr1).equals(ExtMD.getName((EStructuralFeature)attr2)) && ExtMD.getFeatureKind((EStructuralFeature)attr1) == ExtMD.getFeatureKind((EStructuralFeature)attr2);
    }

    protected EClassifier doETypeSwitch(String type) {
        return XMLTypePackage.eINSTANCE.getString();
    }

    protected final Object safeGetNDeepFeature(EObject owner, List<EStructuralFeature> features) {
        EObject curOwner = owner;
        Iterator<EStructuralFeature> it = features.iterator();
        Object foundValue = null;
        while (it.hasNext()) {
            Object value = curOwner.eGet(it.next());
            if (!it.hasNext()) {
                foundValue = value;
                break;
            }
            curOwner = (EObject)value;
        }
        return foundValue;
    }

    protected final String safeGetString(Object object, String defaultValue, String replacePattern, String withPattern) {
        if (object == null) {
            return defaultValue;
        }
        String str = object.toString().trim();
        if ("".equals(str)) {
            return defaultValue;
        }
        return str.replaceAll(replacePattern, withPattern);
    }

    static class PossibleDuplicate {
        private final EAttribute _attribute;
        private final List<EClass> _duplicates;

        public PossibleDuplicate(EAttribute attribute) {
            this._attribute = attribute;
            this._duplicates = new ArrayList<EClass>();
        }

        public boolean isDuplicate() {
            return !this._duplicates.isEmpty();
        }

        public void addDuplicate(EClass eClass) {
            this._duplicates.add(eClass);
        }

        public List<EClass> getDuplicateClasses() {
            return Collections.unmodifiableList(this._duplicates);
        }

        public EAttribute getAttribute() {
            return this._attribute;
        }
    }
}

