/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.model.jsptagbase;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DateTimePatternType implements Enumerator
{
    EMPTY_VALUE(0, "EMPTY_VALUE", ""),
    MDYYHHMM(1, "Mdyyhhmm", "M/d/yy hh:mm"),
    EEE_MDYYHHMM(2, "EEEMdyyhhmm", "EEE, M/d/yy hh:mm"),
    MMDDYYYY_HHMMSSZ(3, "MMddyyyyHHmmssz", "MM/dd/yyyy HH:mm:ss z"),
    EEEM_MDDYYYY_HHMMSSZ(4, "EEEMMddyyyyHHmmssz", "EEE, MM/dd/yyyy HH:mm:ss z"),
    MM_MDYYYY_HHMMZ(5, "MMMdyyyyHHmmz", "MMM d, yyyy HH:mm z"),
    EEEMM_MDYYYY_HHMMZ(6, "EEEMMMdyyyyHHmmz", "EEE, MMM d, yyyy HH:mm z"),
    MMM_MDYYYY_HHMMZ(7, "MMMMdyyyyHHmmz", "MMMM d, yyyy HH:mm z"),
    EEEEMMM_MDYYYY_HHMMZ(8, "EEEEMMMMdyyyyHHmmz", "EEEE, MMMM d, yyyy HH:mm z");

    public static final int EMPTY_VALUE_VALUE = 0;
    public static final int MDYYHHMM_VALUE = 1;
    public static final int EEE_MDYYHHMM_VALUE = 2;
    public static final int MMDDYYYY_HHMMSSZ_VALUE = 3;
    public static final int EEEM_MDDYYYY_HHMMSSZ_VALUE = 4;
    public static final int MM_MDYYYY_HHMMZ_VALUE = 5;
    public static final int EEEMM_MDYYYY_HHMMZ_VALUE = 6;
    public static final int MMM_MDYYYY_HHMMZ_VALUE = 7;
    public static final int EEEEMMM_MDYYYY_HHMMZ_VALUE = 8;
    private static final DateTimePatternType[] VALUES_ARRAY;
    public static final List<DateTimePatternType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DateTimePatternType[]{EMPTY_VALUE, MDYYHHMM, EEE_MDYYHHMM, MMDDYYYY_HHMMSSZ, EEEM_MDDYYYY_HHMMSSZ, MM_MDYYYY_HHMMZ, EEEMM_MDYYYY_HHMMZ, MMM_MDYYYY_HHMMZ, EEEEMMM_MDYYYY_HHMMZ};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DateTimePatternType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DateTimePatternType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DateTimePatternType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DateTimePatternType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DateTimePatternType get(int value) {
        switch (value) {
            case 0: {
                return EMPTY_VALUE;
            }
            case 1: {
                return MDYYHHMM;
            }
            case 2: {
                return EEE_MDYYHHMM;
            }
            case 3: {
                return MMDDYYYY_HHMMSSZ;
            }
            case 4: {
                return EEEM_MDDYYYY_HHMMSSZ;
            }
            case 5: {
                return MM_MDYYYY_HHMMZ;
            }
            case 6: {
                return EEEMM_MDYYYY_HHMMZ;
            }
            case 7: {
                return MMM_MDYYYY_HHMMZ;
            }
            case 8: {
                return EEEEMMM_MDYYYY_HHMMZ;
            }
        }
        return null;
    }

    private DateTimePatternType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

