/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.metadata;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.application.common.services.metadata.internal.AbstractMetaDataLocator2;
import oracle.eclipse.tools.application.common.services.metadata.internal.AbstractMetaDataSourceModelProvider2;
import oracle.eclipse.tools.application.common.services.metadata.internal.IPathSensitiveMetaDataLocator2;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMDocumentFactoryTLD;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;

public class TaglibMetaDataLocator
extends AbstractMetaDataLocator2
implements IPathSensitiveMetaDataLocator2 {
    private IProject _project;
    private TaglibMetaDataSource _source;

    public List locateMetaDataModelProviders(String uri) {
        ArrayList<TaglibMetaDataSource> ret = new ArrayList<TaglibMetaDataSource>();
        CMDocument doc = null;
        if (uri == null || this._project == null) {
            return ret;
        }
        CMDocumentFactoryTLD factory = new CMDocumentFactoryTLD();
        ITaglibRecord[] tldRecs = TaglibIndex.getAvailableTaglibRecords((IPath)this._project.getFullPath());
        ITaglibRecord tldRec = this.findTLD(tldRecs, uri);
        if (tldRec != null) {
            doc = factory.createCMDocument(tldRec);
        }
        if (doc != null) {
            this._source = new TaglibMetaDataSource(doc, uri);
            ret.add(this._source);
        }
        return ret;
    }

    private ITaglibRecord findTLD(ITaglibRecord[] tldRecs, String uri) {
        int i = 0;
        while (i < tldRecs.length) {
            ITaglibRecord tldRec = tldRecs[i];
            String tldRecURI = CMUtil.getURIFromTaglibRecord((ITaglibRecord)tldRec, (IProject)this._project);
            if (uri.equals(tldRecURI)) {
                return tldRec;
            }
            ++i;
        }
        return null;
    }

    public void startLocating() {
    }

    public void stopLocating() {
    }

    public void setProjectContext(IProject project) {
        this._project = project;
    }

    private class TaglibMetaDataSource
    extends AbstractMetaDataSourceModelProvider2 {
        private CMDocument doc;
        private String uri;

        TaglibMetaDataSource(CMDocument doc, String uri) {
            this.doc = doc;
            this.uri = uri;
        }

        public Object getSourceModel() {
            return this.doc;
        }

        public String getModelIdentifier() {
            return this.uri;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IProject.class) {
                return TaglibMetaDataLocator.this._project;
            }
            return super.getAdapter(adapter);
        }
    }
}

