/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.document;

import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.application.common.services.collection.StringElValueExpressionToResourceBundleKeyPairConverter;
import oracle.eclipse.tools.application.common.services.document.AbstractSimpleDocumentBindingService;
import oracle.eclipse.tools.application.common.services.documentservices.AttributeTypeAdapter;
import oracle.eclipse.tools.application.common.services.resource.ResourceBundleKeyPair;
import oracle.eclipse.tools.application.common.services.resource.ResourceBundleUtil;
import oracle.eclipse.tools.application.common.services.variables.DocumentVariableQuery;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IFilePositionContext;
import oracle.eclipse.tools.common.services.techextservices.IDocumentBinder;
import oracle.eclipse.tools.webtier.javawebapp.resource.ResourceBundleKeyPairToStringLocalizationContextConverter;
import oracle.eclipse.tools.webtier.javawebapp.resource.StringLocalizationContextToResourceBundleKeyPairConverter;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.AbstractBaseTag;
import oracle.eclipse.tools.xml.model.service.IXMLMetadataContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EObjectObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class AbstractDocumentBindingService
extends AbstractSimpleDocumentBindingService
implements IDocumentBinder {
    private AbstractBaseTag _tagElement;
    private EStructuralFeature _tagAttribute;
    private AttributeTypeAdapter _attributeTypeAdapter;

    public AbstractDocumentBindingService(IDocument doc) {
        super(doc);
    }

    public boolean canBind(IObservableValue targetTagAttribute, IObservableValue modelReference) {
        if (targetTagAttribute instanceof EObjectObservableValue) {
            if (((EObjectObservableValue)targetTagAttribute).getObserved() instanceof AbstractBaseTag) {
                this._tagElement = (AbstractBaseTag)((EObjectObservableValue)targetTagAttribute).getObserved();
            }
            this._tagAttribute = (EStructuralFeature)((EObjectObservableValue)targetTagAttribute).getValueType();
            this._attributeTypeAdapter = null;
        }
        if (this._tagElement == null || this._tagAttribute == null || !this.isSupportedTag(this._tagElement)) {
            return false;
        }
        boolean canBind = super.canBind(targetTagAttribute, modelReference);
        if (canBind) {
            return true;
        }
        return modelReference.getValueType() == ResourceBundleKeyPair.class && this.canBindToResourceBundleKeyPair((ResourceBundleKeyPair)modelReference.getValue());
    }

    protected AbstractBaseTag getTag() {
        return this._tagElement;
    }

    protected EStructuralFeature getTagAttribute() {
        return this._tagAttribute;
    }

    protected boolean isRuntimeExprValue() {
        AttributeTypeAdapter adapter = this.getAttrTypeAdapter();
        return adapter.getSupportedExpressions(AttributeTypeAdapter.ExpressionType.JSP_EXPRESSION) != null;
    }

    protected ResolutionTime getExpectedResolutionTime() {
        AttributeTypeAdapter adapter = this.getAttrTypeAdapter();
        List supportedExpressions = adapter.getSupportedExpressions();
        Iterator iterator = supportedExpressions.iterator();
        if (iterator.hasNext()) {
            AttributeTypeAdapter.SupportedExpression supportedExpr = (AttributeTypeAdapter.SupportedExpression)iterator.next();
            return supportedExpr.getResolutionTime();
        }
        return ResolutionTime.NOT_AVAILABLE;
    }

    private AttributeTypeAdapter getAttrTypeAdapter() {
        if (this._attributeTypeAdapter == null) {
            IXMLMetadataContext adapter = (IXMLMetadataContext)this.getDocument().getAdapter(IXMLMetadataContext.class);
            this._attributeTypeAdapter = new AttributeTypeAdapter(adapter, this.getDocument(), this._tagElement.getNamespaceUri(), this._tagElement.getTagName(), this._tagAttribute.getName());
        }
        return this._attributeTypeAdapter;
    }

    protected UpdateValueStrategy getModelToTargetUpdateStrategy(IObservableValue modelReference, IObservableValue targetTagAttribute) {
        UpdateValueStrategy strategy = super.getModelToTargetUpdateStrategy(modelReference, targetTagAttribute);
        if (modelReference.getValueType() == ResourceBundleKeyPair.class) {
            strategy.setConverter((IConverter)new ResourceBundleKeyPairToStringLocalizationContextConverter());
        }
        return strategy;
    }

    protected UpdateValueStrategy getTargetToModelUpdateStrategy(IObservableValue targetTagAttribute, IObservableValue modelReference) {
        UpdateValueStrategy modelToTargetStrategy = super.getTargetToModelUpdateStrategy(targetTagAttribute, modelReference);
        if (modelReference.getValueType() == ResourceBundleKeyPair.class) {
            if (this.isLocalizationContextCase(targetTagAttribute)) {
                modelToTargetStrategy.setConverter((IConverter)new StringLocalizationContextToResourceBundleKeyPairConverter((EObject)this.getTag(), this.getTagAttribute()));
            } else {
                IDocument document = this.getDocument();
                int offset = (int)ResourceBundleUtil.INSTANCE.getOffset((EObject)this.getTag(), this.getTagAttribute());
                DocumentVariableQuery bundleVarQuery = new DocumentVariableQuery(document, offset);
                modelToTargetStrategy.setConverter((IConverter)new StringElValueExpressionToResourceBundleKeyPairConverter((IFilePositionContext)new FilePositionContext(offset, document.getFile()), (VariableQuery)bundleVarQuery));
            }
        }
        return modelToTargetStrategy;
    }

    protected boolean isLocalizationContextCase(IObservableValue targetTagAttribute) {
        return false;
    }

    protected abstract boolean canBindToResourceBundleKeyPair(ResourceBundleKeyPair var1);

    protected abstract boolean isSupportedTag(AbstractBaseTag var1);
}

