/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.collection.AbstractTagCollector;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentCollectionContext;
import oracle.eclipse.tools.application.common.services.collection.StructuredDocumentResourceLocationFactory;
import oracle.eclipse.tools.application.common.services.collection.TagCollector;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.collection.ArtifactException;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IStructuredXMLModelVisitor;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedContentModelUtil;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedTLDCMDocumentManager;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedTaglibController;
import oracle.eclipse.tools.webtier.jsp.Activator;
import oracle.eclipse.tools.webtier.jsp.collection.AbstractJSPCollector;
import oracle.eclipse.tools.webtier.jsp.model.dom.JSPNamespaceContext;
import oracle.eclipse.tools.webtier.jsp.util.wtp.JSPUtil;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.service.IXMLMetadataContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.jst.jsp.core.taglib.ITLDRecord;
import org.eclipse.jst.jsp.core.taglib.ITagDirRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;

public class JSPTagCollector
extends AbstractJSPCollector {
    private static final String ID = "JSP";
    private final INamespaceContext _namespaceContext;
    private JSPVisitor visitor = null;

    public JSPTagCollector() {
        this(ID, JSP_CONTENT_TYPES);
    }

    protected JSPTagCollector(String collectorID, Set<String> contentTypes) {
        super(collectorID, JSP_CONTENT_TYPES);
        this._namespaceContext = new JSPNamespaceContext();
    }

    protected JSPTagCollector(INamespaceContext context) {
        super(ID, JSP_CONTENT_TYPES);
        this._namespaceContext = context;
    }

    @Override
    public boolean visit(IDOMNode node) {
        return this.visitor.visit(node);
    }

    @Override
    public boolean visit(IDOMAttr attribute) {
        return this.visitor.visit(attribute);
    }

    @Override
    public boolean visit(IDOMElement element) {
        return this.visitor.visit(element);
    }

    @Override
    public boolean visit(IDOMDocument domDocument) {
        if (this.isCollectable()) {
            IStructuredDocument structuredDocument = domDocument.getStructuredDocument();
            Map<String, ITagDirRecord> tagDirMap = this.getTagDirRecordMap(structuredDocument, this.getCurrentResource().getFullPath());
            IDocument document = (IDocument)this.getCurrentResource().getAdapter(IDocument.class);
            IXMLMetadataContext mdContext = (IXMLMetadataContext)document.getAdapter(IXMLMetadataContext.class);
            assert (mdContext != null);
            this.visitor = new JSPVisitor(this.structuredContext, this.getID(), tagDirMap, this._namespaceContext, mdContext, this.getCurrentResource());
        }
        return this.isCollectable() && this.visitor.visit(domDocument);
    }

    protected TagCollector createTagCollector(INamespaceContext namespaceContext, IXMLMetadataContext mdContext, IStructuredDocumentCollectionContext collectionContext, AbstractTagCollector.AbstractTagContextUriResolver contextUriResolver, StructuredDocumentResourceLocationFactory locationFactory, IFile baseFile, String collectorID) {
        return new TagCollector(namespaceContext, mdContext, collectionContext, contextUriResolver, locationFactory, baseFile, collectorID);
    }

    private Map<String, ITagDirRecord> getTagDirRecordMap(IStructuredDocument document, IPath fullPath) {
        HashMap<String, ITagDirRecord> map = new HashMap<String, ITagDirRecord>();
        String path = fullPath.toString();
        MergedTLDCMDocumentManager m = MergedTaglibController.getInstance().getTldManager(document);
        if (m == null) {
            return Collections.EMPTY_MAP;
        }
        ArrayList trackers = new ArrayList(m.getTaglibTrackers());
        for (TaglibTracker tracker : trackers) {
            ITaglibRecord tagRecord;
            String uri;
            String prefix = tracker.getPrefix();
            CMDocument cmdoc = tracker.getDocument();
            if (prefix == null || !(cmdoc instanceof TLDDocument) || (uri = tracker.getURI()) == null || (tagRecord = TaglibIndex.resolve((String)path, (String)uri, (boolean)true)) == null || tagRecord.getRecordType() != 8) continue;
            map.put(prefix, (ITagDirRecord)tagRecord);
        }
        if (map.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(map);
    }

    public static class JSPPageTagContextResolver
    extends TagCollector.DefaultTagContextUriResolver {
        public IPath resolve(IFile referringResource, IDOMElement owningElement, IDOMNode referringNode, String originalUri) {
            TagIdentifier tagId = TagIdentifierFactory.createDocumentTagWrapper((Element)owningElement);
            if (tagId != null && JSPUtil.TAG_IDENTIFIER_TAGLIB.isSameTagType(tagId)) {
                return this.resolveTaglibUri(referringResource, owningElement, referringNode, originalUri);
            }
            return super.resolve(referringResource, owningElement, referringNode, originalUri);
        }

        private IPath resolveTaglibUri(IFile referringResource, IDOMElement owningElement, IDOMNode referringNode, String originalUri) {
            ITaglibRecord record;
            if (referringNode.getNodeType() == 2 && "uri".equals(referringNode.getLocalName()) && (record = TaglibIndex.resolve((String)referringResource.getFullPath().toString(), (String)originalUri, (boolean)true)) != null) {
                switch (record.getRecordType()) {
                    case 1: {
                        ITLDRecord tldRecord = (ITLDRecord)record;
                        return tldRecord.getPath();
                    }
                }
            }
            return null;
        }
    }

    private class JSPVisitor
    implements IStructuredXMLModelVisitor {
        private final INamespaceContext _jspNamespaceContext;
        private final IFile _file;
        private final TagCollector _tagCollector;
        private final JSPPageTagContextResolver _resolver;
        private final Map<String, ITagDirRecord> _tagDirRecords;
        private final IStructuredDocumentCollectionContext _collectionContext;
        private final StructuredDocumentResourceLocationFactory _locationFactory;
        private final String _collectorId;

        public JSPVisitor(IStructuredDocumentCollectionContext collectionContext, String collectorId, Map<String, ITagDirRecord> tagDirRecords, INamespaceContext jspNamespaceContext, IXMLMetadataContext mdContext, IResource resource) {
            this._collectionContext = collectionContext;
            this._jspNamespaceContext = jspNamespaceContext;
            this._file = (IFile)resource;
            this._resolver = new JSPPageTagContextResolver();
            this._tagDirRecords = tagDirRecords;
            this._locationFactory = new StructuredDocumentResourceLocationFactory(this._file);
            this._collectorId = collectorId;
            this._tagCollector = JSPTagCollector.this.createTagCollector(this._jspNamespaceContext, mdContext, collectionContext, (AbstractTagCollector.AbstractTagContextUriResolver)this._resolver, this._locationFactory, this._file, this._collectorId);
        }

        public boolean visit(IDOMNode node) {
            return false;
        }

        public boolean visit(IDOMAttr attribute) {
            return false;
        }

        public boolean visit(IDOMElement element) {
            try {
                this._tagCollector.collectArtifacts(element, this._file, null);
                if (this._tagDirRecords != Collections.EMPTY_MAP) {
                    this.checkAndRecordTagFileDep(element);
                }
            }
            catch (ArtifactException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
            }
            return true;
        }

        private void checkAndRecordTagFileDep(IDOMElement element) {
            TLDElementDeclaration elementDeclaration;
            String prefix = element.getPrefix();
            if (this._tagDirRecords.containsKey(prefix) && (elementDeclaration = MergedContentModelUtil.getTLDElementDeclaration((Element)element)) != null) {
                ResourceLocation location;
                String elementName;
                IPath tagDirPath = this._tagDirRecords.get(prefix).getPath();
                IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(tagDirPath);
                IFile file = folder.getFile(String.format("%s.tagx", elementName = elementDeclaration.getElementName()));
                if (!file.isAccessible()) {
                    file = folder.getFile(String.format("%s.tag", elementName));
                }
                if ((location = this._locationFactory.createForEntireElement(element)) != null) {
                    this._collectionContext.addDocumentToResourceDependancy((IResource)file, location, (byte)0, this._collectorId);
                }
            }
        }

        public boolean visit(IDOMDocument document) {
            return true;
        }
    }
}

