/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.el;

import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.List;
import oracle.eclipse.tools.adf.debugger.ui.AdfDebugUITools;
import oracle.eclipse.tools.adf.debugger.ui.views.data.JDIValueStackFrameHolder;
import oracle.eclipse.tools.adf.debugger.ui.views.el.ExpressionContentProposalProvider;
import org.eclipse.debug.internal.ui.VariablesViewModelPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.DebugModelPresentationContext;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIType;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class AdfELEvaluatorView
extends ViewPart {
    public static final String ID = "oracle.eclipse.tools.adf.debugger.ui.AdfElEvaluatorView";
    private TreeModelViewer elResultViewer = null;
    private Text elText = null;
    private Button evalBtn = null;
    protected VariablesViewModelPresentation fModelPresentation;

    public void createPartControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(3, false));
        this.createExpressionInputFields(comp);
        this.elResultViewer = this.createELResultTableViewer(comp);
    }

    private TreeModelViewer createELResultTableViewer(Composite parent) {
        if (this.fModelPresentation == null) {
            this.fModelPresentation = new VariablesViewModelPresentation(){

                public String getText(Object element) {
                    IDebugModelPresentation lp = this.getConfiguredPresentation(element);
                    if (lp != null) {
                        return lp.getText(element);
                    }
                    return this.getDefaultText(element);
                }
            };
        }
        int style = this.getViewerStyle();
        DebugModelPresentationContext fPresentationContext = new DebugModelPresentationContext(this.getPresentationContextId(), (IWorkbenchPart)this, (IDebugModelPresentation)this.fModelPresentation);
        this.elResultViewer = new TreeModelViewer(parent, style, (IPresentationContext)fPresentationContext);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 3;
        this.elResultViewer.getTree().setLayoutData((Object)gd);
        String[] ids = new String[]{"org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME", "org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_VALUE", "org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VALUE_TYPE"};
        this.elResultViewer.setVisibleColumns(ids);
        return this.elResultViewer;
    }

    protected String getPresentationContextId() {
        return "org.eclipse.debug.ui.VariableView";
    }

    protected int getViewerStyle() {
        return 268501770;
    }

    private void createExpressionInputFields(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Resources.expression);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.elText = new Text(parent, 2048);
        this.elText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.elText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                AdfELEvaluatorView.this.evalBtn.setEnabled(AdfDebugUITools.getAdfStackframe() != null);
            }
        });
        this.elText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String elString = AdfELEvaluatorView.this.elText.getText();
                if (this.isELExpression(elString) && AdfDebugUITools.getAdfStackframe() != null) {
                    AdfELEvaluatorView.this.evalBtn.setEnabled(true);
                } else {
                    AdfELEvaluatorView.this.evalBtn.setEnabled(false);
                }
            }

            public boolean isELExpression(String expression) {
                if (expression == null) {
                    return false;
                }
                int start = expression.indexOf("#{");
                return start != -1 && start < expression.indexOf(125);
            }
        });
        this.elText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AdfELEvaluatorView.this.evaluateExpression(AdfELEvaluatorView.this.elText.getText());
                        }
                    });
                    return;
                }
                super.keyPressed(e);
            }
        });
        this.addContentAssist();
        this.evalBtn = new Button(parent, 8);
        this.evalBtn.setEnabled(false);
        this.evalBtn.setText(Resources.evaluate);
        this.evalBtn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.evalBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JDIStackFrame stackFrame = AdfDebugUITools.getAdfStackframe();
                if (stackFrame == null) {
                    AdfELEvaluatorView.this.evalBtn.setEnabled(false);
                    return;
                }
                String elString = AdfELEvaluatorView.this.elText.getText();
                if (elString != null && elString.trim().length() > 0) {
                    AdfELEvaluatorView.this.evaluateExpression(elString);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addContentAssist() {
        try {
            char[] autoActivationCharacters = new char[]{'#', '.'};
            KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            ExpressionContentProposalProvider proposalProvider = new ExpressionContentProposalProvider();
            ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.elText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)proposalProvider, keyStroke, autoActivationCharacters);
            adapter.setPropagateKeys(true);
            adapter.setProposalAcceptanceStyle(2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void evaluateExpression(String elString) {
        JDIStackFrame stackFrame = AdfDebugUITools.getAdfStackframe();
        if (stackFrame == null) {
            return;
        }
        try {
            JDIObjectValue elVal;
            Method method;
            String signature;
            IJavaClassType javaType;
            JDIObjectValue adfContextVal;
            String GET_CURRENT_BINDING_CONTEXT = "getCurrent";
            IJavaThread thread = (IJavaThread)stackFrame.getThread();
            JDIDebugTarget jdiTarget = (JDIDebugTarget)thread.getDebugTarget();
            IJavaType[] types = jdiTarget.getJavaTypes("oracle.adf.share.ADFContext");
            if (types != null && types.length > 0 && (adfContextVal = (JDIObjectValue)(javaType = (IJavaClassType)types[0]).sendMessage("getCurrent", signature = (method = this.getMethod(javaType, GET_CURRENT_BINDING_CONTEXT)).signature(), new IJavaValue[0], thread)) != null && (elVal = (JDIObjectValue)adfContextVal.sendMessage("getExpressionEvaluator", signature = (method = this.getMethod(javaType = (IJavaClassType)adfContextVal.getJavaType(), "getExpressionEvaluator")).signature(), null, thread, false)) != null) {
                javaType = (IJavaClassType)elVal.getJavaType();
                method = this.getMethod(javaType, "evaluate");
                signature = method.signature();
                IJavaValue[] param = new IJavaValue[]{jdiTarget.newValue(elString)};
                JDIObjectValue retVal = (JDIObjectValue)elVal.sendMessage("evaluate", signature, param, thread, false);
                this.elResultViewer.setInput((Object)new JDIValueStackFrameHolder(elString, (JDIValue)retVal));
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.elResultViewer.setInput(new Object());
    }

    private Method getMethod(IJavaClassType javaType, String methodName) {
        JDIType jdiType = (JDIType)javaType;
        ReferenceType clzType = (ReferenceType)jdiType.getUnderlyingType();
        List<Method> methods = clzType.methodsByName(methodName);
        Method method = methods.get(0);
        return method;
    }

    public void disable() {
        if (this.elResultViewer != null) {
            this.elResultViewer.setInput(new Object());
        }
        this.evalBtn.setEnabled(false);
    }

    public void evaluate(String expression) {
        this.elText.setText(expression);
        this.evaluateExpression(expression);
    }

    public void setFocus() {
    }

    private static final class Resources
    extends NLS {
        public static String evaluate;
        public static String expression;

        static {
            Resources.initializeMessages((String)AdfELEvaluatorView.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

