/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.data;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import oracle.adf.share.dt.debug.AdfContextElement;
import oracle.adf.share.dt.debug.AdfViewDebugUtils;
import oracle.adf.share.dt.debug.BaseView;
import oracle.adf.share.dt.debug.ChildViewPortElement;
import oracle.adf.share.dt.debug.FragmentView;
import oracle.adf.share.dt.debug.JspView;
import oracle.adf.share.dt.debug.JspViewContext;
import oracle.adf.share.dt.debug.RegionInfo;
import oracle.adf.share.dt.debug.RegionList;
import oracle.adf.share.dt.debug.RootViewPortElement;
import oracle.adf.share.dt.debug.ViewPortElement;
import oracle.adfdt.debug.common.AdfDebuggerElementAttributes;
import oracle.adfdt.model.debug.structure.BindingContainerElement;
import oracle.eclipse.tools.adf.debugger.ui.views.data.DebuggerEvaluatorUtils;
import oracle.eclipse.tools.adf.debugger.ui.views.data.DefaultStructureContentProvider;
import oracle.eclipse.tools.adf.debugger.ui.views.data.JDIValueDebuggeeDataInfo;
import oracle.ide.Context;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.runner.DebuggeeData;
import oracle.ide.runner.DebuggerEvaluator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class ViewPortHierarchyStructureContentProvider
extends DefaultStructureContentProvider {
    static ViewPortHierarchyStructureContentProvider INSTANCE = new ViewPortHierarchyStructureContentProvider();
    private static final Set<String> TASK_FLOW_REGION_MODEL_FULLY_QUALIFIED_TYPES = new HashSet<String>();
    public static final String GET_ROOT_VIEW_PORT_CONTEXT_DEBUG_SUMMARY = "oracle.adfinternal.controller.debug.DebugFacadeImpl.getRootViewPortContextDebugSummary()";
    private static final String GET_CHILD_VIEW_PORT_CONTEXT_DEBUG_SUMMARIES = "oracle.adfinternal.controller.debug.DebugFacadeImpl.getChildViewPortContextDebugSummaries(\"{0}\")";
    private static final String TASK_FLOW_BINDING_FULL_NAME = "mTaskFlowBindingFullName";
    private static final String VIEW_PORT_CONTEXT_FIELD = "viewPortContext";
    private static final String VIEW_PORT_ID_FIELD = "viewPortId";
    private static final String VIEW_ID_FIELD = "viewId";
    private static final String PAGE_NAME_FIELD = "pageName";
    private static final String CLIENT_ID_FIELD = "clientId";
    private static final String CURRENT_VIEW_PORT_FIELD = "currentViewPort";
    private static final String VIEW_BINDING_CONTAINER_FIELD = "viewBindingContainer";
    private static final String VIEW_BINDING_CONTAINER_DEBUG_CONTEXT_FIELD = "viewBindingContainerDebugContext";
    private static final String CONTEXT_AVAILABLE_FIELD = "contextAvailable";

    static {
        TASK_FLOW_REGION_MODEL_FULLY_QUALIFIED_TYPES.add("oracle.adf.controller.internal.binding.TaskFlowRegionModel");
        TASK_FLOW_REGION_MODEL_FULLY_QUALIFIED_TYPES.add("oracle.adf.controller.internal.binding.DCTaskFlowBinding$InnerTaskFlowRegionModel");
    }

    private ViewPortHierarchyStructureContentProvider() {
    }

    @Override
    public List<Element> getChildren(Element parentElement, Context context, DebuggerEvaluator evaluator) {
        boolean isAdfcPresent = true;
        if (isAdfcPresent) {
            AdfViewDebugUtils.ensureUtilClassLoaded(evaluator);
            if (parentElement instanceof AdfContextElement) {
                DebuggeeData rootViewPortDebugSummaryAsDebuggeeData = evaluator.evaluate(GET_ROOT_VIEW_PORT_CONTEXT_DEBUG_SUMMARY, null);
                if (rootViewPortDebugSummaryAsDebuggeeData != null) {
                    RootViewPortElement rootViewPortElement = new RootViewPortElement();
                    this.evaluateViewPortDebugSummary(rootViewPortElement, rootViewPortDebugSummaryAsDebuggeeData);
                    return Collections.singletonList(rootViewPortElement);
                }
            } else {
                if (parentElement instanceof ViewPortElement) {
                    return this.getChildrenForViewPort(parentElement, context, evaluator);
                }
                if (parentElement instanceof BaseView) {
                    return this.getChildrenForView(parentElement, evaluator);
                }
            }
        }
        return Collections.EMPTY_LIST;
    }

    private List<Element> getChildrenForViewPort(Element parentElement, Context context, DebuggerEvaluator evaluator) {
        ViewPortElement viewPortElement = (ViewPortElement)parentElement;
        String viewId = viewPortElement.getViewId();
        if (viewId != null) {
            BaseView viewElement;
            if (viewPortElement instanceof RootViewPortElement) {
                RootViewPortElement rootViewPortElement = (RootViewPortElement)viewPortElement;
                viewElement = new JspView(viewId);
                JspViewContext jspViewContext = viewElement.getJspViewContext(context);
                rootViewPortElement.setJspViewContext(jspViewContext);
                RegionList regionList = new RegionList();
                Collection<RegionInfo> regionInfos = ((JspView)viewElement).getContainedRegions(evaluator);
                for (RegionInfo regionInfo : regionInfos) {
                    String regionModelActualType;
                    DebuggeeData regionModelAsDebuggeeData = regionInfo.getRegionModel();
                    if (DebuggerEvaluatorUtils.evaluateIsNull(regionModelAsDebuggeeData) || !TASK_FLOW_REGION_MODEL_FULLY_QUALIFIED_TYPES.contains(regionModelActualType = regionModelAsDebuggeeData.getFullyQualifiedActualType())) continue;
                    String taskFlowBindingFullName = DebuggerEvaluatorUtils.evaluateString(regionModelAsDebuggeeData.getField(TASK_FLOW_BINDING_FULL_NAME));
                    regionList.putRegionInfo(taskFlowBindingFullName, regionInfo);
                }
                rootViewPortElement.setRegionList(regionList);
            } else {
                ChildViewPortElement childViewPortElement = (ChildViewPortElement)viewPortElement;
                RootViewPortElement rootViewPortElement = childViewPortElement.getRootViewPortElement();
                JspViewContext jspViewContext = rootViewPortElement.getJspViewContext();
                RegionList regionList = rootViewPortElement.getRegionList();
                String clientId = viewPortElement.getClientId();
                RegionInfo regionInfo = regionList.getRegionInfo(clientId);
                viewElement = new FragmentView(jspViewContext, regionInfo, viewId);
                if (regionInfo == null) {
                    Attributes viewElementAttributes = viewElement.getAttributes();
                    viewElementAttributes.set(AdfDebuggerElementAttributes.CONTEXT_NOT_AVAILABLE);
                }
            }
            String relativePageNameAsString = viewPortElement.getPageName();
            viewElement.setPage(relativePageNameAsString);
            viewElement.setContextualData(viewPortElement);
            Attributes viewPortElementAttributes = viewPortElement.getAttributes();
            if (viewPortElementAttributes.isSet(AdfDebuggerElementAttributes.CONTEXT_NOT_AVAILABLE)) {
                Attributes viewElementAttributes = viewElement.getAttributes();
                viewElementAttributes.set(AdfDebuggerElementAttributes.CONTEXT_NOT_AVAILABLE);
            }
            return Collections.singletonList(viewElement);
        }
        return Collections.EMPTY_LIST;
    }

    private List<Element> getChildrenForView(Element parentElement, DebuggerEvaluator evaluator) {
        BaseView viewElement = (BaseView)parentElement;
        LinkedList<Element> childrenOfViewElement = new LinkedList<Element>();
        ViewPortElement viewPortElement = (ViewPortElement)viewElement.getContextualData();
        DebuggeeData viewBindingContainerAsDebuggeeData = viewPortElement.getViewBindingContainerAsDebuggeeData();
        if (viewBindingContainerAsDebuggeeData != null && !DebuggerEvaluatorUtils.evaluateIsNull(viewBindingContainerAsDebuggeeData)) {
            DebuggeeData viewBindingContainerDebugContextAsDebuggeeData = viewPortElement.getViewBindingContainerDebugContextAsDebuggeeData();
            BindingContainerElement viewBindingContainerElement = new BindingContainerElement(viewBindingContainerAsDebuggeeData, viewBindingContainerDebugContextAsDebuggeeData, evaluator);
            childrenOfViewElement.add(viewBindingContainerElement);
            Attributes viewPortElementElementAttributes = viewPortElement.getAttributes();
            if (viewPortElementElementAttributes.isSet(AdfDebuggerElementAttributes.CONTEXT_NOT_AVAILABLE)) {
                Attributes viewBindingContainerElementAttributes = viewBindingContainerElement.getAttributes();
                viewBindingContainerElementAttributes.set(AdfDebuggerElementAttributes.CONTEXT_NOT_AVAILABLE);
            }
        }
        RootViewPortElement rootViewPortElement = viewPortElement.getRootViewPortElement();
        String viewPortId = viewPortElement.getViewPortId();
        String statement = MessageFormat.format(GET_CHILD_VIEW_PORT_CONTEXT_DEBUG_SUMMARIES, viewPortId);
        DebuggeeData childViewPortDebugSummariesAsDebuggeeData = evaluator.evaluate(statement, null);
        List<? extends DebuggeeData> childViewPortDebugSummariesAsList = childViewPortDebugSummariesAsDebuggeeData.getChildren();
        ArrayList<ChildViewPortElement> childViewPortElements = new ArrayList<ChildViewPortElement>(childViewPortDebugSummariesAsList.size());
        for (DebuggeeData debuggeeData : childViewPortDebugSummariesAsList) {
            ChildViewPortElement childViewPortElement = new ChildViewPortElement();
            this.evaluateViewPortDebugSummary(childViewPortElement, debuggeeData);
            childViewPortElement.setRootViewPortElement(rootViewPortElement);
            childViewPortElements.add(childViewPortElement);
        }
        RegionList regionList = rootViewPortElement.getRegionList();
        Collections.sort(childViewPortElements, regionList);
        childrenOfViewElement.addAll(childViewPortElements);
        return childrenOfViewElement;
    }

    private void evaluateViewPortDebugSummary(ViewPortElement viewPortElement, DebuggeeData viewPortDebugSummaryAsDebuggeeData) {
        List<? extends DebuggeeData> list = viewPortDebugSummaryAsDebuggeeData.getDeclaredFields();
        if (list.size() == 0) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Status sts = new Status(4, "oracle.eclipse.tools.adf.debugger.ui", "Failed to retrieve root ViewPort debug information from ADF runtime. You will not be able to access complete runtime information in ADF Structure and Data View.Please restart the debugger and try again.", null);
                    ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Unable to load view port debug information for the ADF page. ", (IStatus)sts);
                }
            });
        }
        for (JDIValueDebuggeeDataInfo jDIValueDebuggeeDataInfo : list) {
            String fieldName = jDIValueDebuggeeDataInfo.getFieldName();
            if (VIEW_PORT_CONTEXT_FIELD.equals(fieldName)) {
                JDIValueDebuggeeDataInfo viewPortContextAsDebuggeeData = jDIValueDebuggeeDataInfo;
                viewPortElement.setDebuggeeData(viewPortContextAsDebuggeeData);
                continue;
            }
            if (VIEW_PORT_ID_FIELD.equals(fieldName)) {
                String viewPortId = DebuggerEvaluatorUtils.evaluateString(jDIValueDebuggeeDataInfo);
                viewPortElement.setViewPortId(viewPortId);
                continue;
            }
            if (VIEW_ID_FIELD.equals(fieldName)) {
                String viewId = DebuggerEvaluatorUtils.evaluateString(jDIValueDebuggeeDataInfo);
                viewPortElement.setViewId(viewId);
                continue;
            }
            if (PAGE_NAME_FIELD.equals(fieldName)) {
                String pageName = DebuggerEvaluatorUtils.evaluateString(jDIValueDebuggeeDataInfo);
                viewPortElement.setPageName(pageName);
                continue;
            }
            if (CLIENT_ID_FIELD.equals(fieldName)) {
                String clientId = DebuggerEvaluatorUtils.evaluateString(jDIValueDebuggeeDataInfo);
                viewPortElement.setClientId(clientId);
                continue;
            }
            if (CURRENT_VIEW_PORT_FIELD.equals(fieldName)) {
                boolean currentViewPort = DebuggerEvaluatorUtils.evaluateBoolean(jDIValueDebuggeeDataInfo);
                viewPortElement.setCurrentViewPort(currentViewPort);
                continue;
            }
            if (VIEW_BINDING_CONTAINER_FIELD.equals(fieldName)) {
                JDIValueDebuggeeDataInfo viewBindingContainerAsDebuggeeData = jDIValueDebuggeeDataInfo;
                viewPortElement.setViewBindingContainerAsDebuggeeData(viewBindingContainerAsDebuggeeData);
                continue;
            }
            if (VIEW_BINDING_CONTAINER_DEBUG_CONTEXT_FIELD.equals(fieldName)) {
                JDIValueDebuggeeDataInfo viewBindingContainerDebugContextAsDebuggeeData = jDIValueDebuggeeDataInfo;
                viewPortElement.setViewBindingContainerDebugContextAsDebuggeeData(viewBindingContainerDebugContextAsDebuggeeData);
                continue;
            }
            if (!CONTEXT_AVAILABLE_FIELD.equals(fieldName)) continue;
            boolean contextAvailable = DebuggerEvaluatorUtils.evaluateBoolean(jDIValueDebuggeeDataInfo);
            Attributes viewPortElementAttributes = viewPortElement.getAttributes();
            if (contextAvailable) continue;
            viewPortElementAttributes.set(AdfDebuggerElementAttributes.CONTEXT_NOT_AVAILABLE);
        }
    }
}

