/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.data;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import oracle.adf.share.dt.debug.ViewPortElement;
import oracle.adfdt.controller.adfc.debug.pageflowstack.BoundedTaskFlowStackEntryElement;
import oracle.adfdt.controller.adfc.debug.pageflowstack.PageFlowStackEntryElement;
import oracle.adfdt.controller.adfc.debug.pageflowstack.UnboundedTaskFlowStackEntryElement;
import oracle.adfdt.debug.common.AdfDebuggerElementAttributes;
import oracle.adfdt.model.debug.structure.BindingContainerElement;
import oracle.eclipse.tools.adf.debugger.ui.AdfDebugUITools;
import oracle.eclipse.tools.adf.debugger.ui.AdfDebuggerUiPlugin;
import oracle.eclipse.tools.adf.debugger.ui.views.data.DebuggerEvaluatorUtils;
import oracle.eclipse.tools.adf.debugger.ui.views.data.DefaultStructureContentProvider;
import oracle.ide.Context;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.runner.DebuggeeData;
import oracle.ide.runner.DebuggerEvaluator;

class PageFlowStackStructureContentProvider
extends DefaultStructureContentProvider {
    static PageFlowStackStructureContentProvider INSTANCE = new PageFlowStackStructureContentProvider();
    private static final String GET_PAGE_FLOW_STACK_ENTRY_DEBUG_SUMMARIES = "oracle.adfinternal.controller.debug.DebugFacadeImpl.getPageFlowStackEntryDebugSummaries(\"{0}\")";
    private static final String PAGE_FLOW_STACK_ENTRY_FIELD = "pageFlowStackEntry";
    private static final String PAGE_FLOW_STACK_INDEX_FIELD = "pageFlowStackIndex";
    private static final String LOCAL_TASK_FLOW_ID_FIELD = "localTaskFlowId";
    private static final String DOCUMENT_NAME_FIELD = "documentName";
    private static final String FULLY_QUALIFIED_NAME_FIELD = "fullyQualifiedName";
    private static final String ACTIVITY_BINDING_CONTAINER_FIELD = "activityBindingContainer";
    private static final String DATA_CONTROL_FRAME_NAME_FIELD = "dataControlFrameName";

    private PageFlowStackStructureContentProvider() {
    }

    @Override
    public List<Element> getChildren(Element parentElement, Context context, DebuggerEvaluator evaluator) {
        if (parentElement instanceof ViewPortElement) {
            ViewPortElement viewPortElement = (ViewPortElement)parentElement;
            Attributes viewPortElementAttributes = viewPortElement.getAttributes();
            String viewPortId = viewPortElement.getViewPortId();
            if (viewPortId == null || viewPortId.equals("null")) {
                AdfDebuggerUiPlugin.logWarning("Error retrieve view port ID. The value is null", null);
                return Collections.EMPTY_LIST;
            }
            DebuggeeData pageFlowStackEntryDebugSummariesAsDebuggeeData = evaluator.evaluate(MessageFormat.format(GET_PAGE_FLOW_STACK_ENTRY_DEBUG_SUMMARIES, viewPortId), null);
            if (pageFlowStackEntryDebugSummariesAsDebuggeeData != null) {
                List<? extends DebuggeeData> pageFlowStackEntryDebugSummariesAsList = pageFlowStackEntryDebugSummariesAsDebuggeeData.getChildren();
                boolean firstIteration = true;
                PageFlowStackEntryElement nextPageFlowStackEntryElement = null;
                int i = pageFlowStackEntryDebugSummariesAsList.size() - 1;
                while (i >= 0) {
                    PageFlowStackEntryElement pageFlowStackEntryElement = this.evaluatePageFlowStackEntryDebugSummary(viewPortId, pageFlowStackEntryDebugSummariesAsList.get(i), nextPageFlowStackEntryElement);
                    if (firstIteration) {
                        String dataControlFrameName = pageFlowStackEntryElement.getDataControlFrameName();
                        if ((dataControlFrameName == null || dataControlFrameName.length() == 0) && AdfDebugUITools.isDebugMode()) {
                            AdfDebuggerUiPlugin.logInfo("DataControlFrameName is null", null);
                        }
                        viewPortElement.setDataControlFrameName(dataControlFrameName);
                        firstIteration = false;
                    }
                    if (pageFlowStackEntryElement instanceof BoundedTaskFlowStackEntryElement) {
                        BoundedTaskFlowStackEntryElement boundedTaskFlowStackEntryElement = (BoundedTaskFlowStackEntryElement)pageFlowStackEntryElement;
                        String documentName = boundedTaskFlowStackEntryElement.getDocumentName();
                        boolean debug = false;
                        if (debug) {
                            System.out.println(documentName);
                        }
                    }
                    if (viewPortElementAttributes.isSet(AdfDebuggerElementAttributes.CONTEXT_NOT_AVAILABLE)) {
                        Attributes pageFlowStackEntryElementAttributes = pageFlowStackEntryElement.getAttributes();
                        pageFlowStackEntryElementAttributes.set(AdfDebuggerElementAttributes.CONTEXT_NOT_AVAILABLE);
                    }
                    nextPageFlowStackEntryElement = pageFlowStackEntryElement;
                    --i;
                }
                if (nextPageFlowStackEntryElement != null) {
                    return Collections.singletonList(nextPageFlowStackEntryElement);
                }
            }
        } else if (parentElement instanceof PageFlowStackEntryElement) {
            PageFlowStackEntryElement pageFlowStackEntryElement = (PageFlowStackEntryElement)parentElement;
            if (pageFlowStackEntryElement.isTop()) {
                DebuggeeData activityBindingContainerAsDebuggeeData = pageFlowStackEntryElement.getActivityBindingContainerAsDebuggeeData();
                if (activityBindingContainerAsDebuggeeData != null && !DebuggerEvaluatorUtils.evaluateIsNull(activityBindingContainerAsDebuggeeData)) {
                    BindingContainerElement activityBindingContainerElement = new BindingContainerElement(activityBindingContainerAsDebuggeeData, evaluator);
                    Attributes pageFlowStackEntryElementAttributes = pageFlowStackEntryElement.getAttributes();
                    if (pageFlowStackEntryElementAttributes.isSet(AdfDebuggerElementAttributes.CONTEXT_NOT_AVAILABLE)) {
                        Attributes activityBindingContainerElementAttributes = activityBindingContainerElement.getAttributes();
                        activityBindingContainerElementAttributes.set(AdfDebuggerElementAttributes.CONTEXT_NOT_AVAILABLE);
                    }
                    return Collections.singletonList(activityBindingContainerElement);
                }
            } else if (pageFlowStackEntryElement.getChildren().hasNext()) {
                Element e = pageFlowStackEntryElement.getChildren().next();
                return Collections.singletonList(e);
            }
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - void declaration
     */
    private PageFlowStackEntryElement evaluatePageFlowStackEntryDebugSummary(String viewPortId, DebuggeeData pageFlowStackEntryDebugSummaryAsDebuggeeData, PageFlowStackEntryElement nextPageFlowStackEntryElement) {
        void var11_15;
        DebuggeeData pageFlowStackEntryAsDebuggeeData = null;
        int pageFlowStackIndex = -1;
        String localTaskFlowId = null;
        String documentName = null;
        String fullyQualifiedName = null;
        DebuggeeData activityBindingContainerAsDebuggeeData = null;
        String dataControlFrameName = null;
        for (DebuggeeData debuggeeData : pageFlowStackEntryDebugSummaryAsDebuggeeData.getDeclaredFields()) {
            String fieldName = debuggeeData.getShortLabel();
            if (PAGE_FLOW_STACK_ENTRY_FIELD.equals(fieldName)) {
                pageFlowStackEntryAsDebuggeeData = debuggeeData;
                continue;
            }
            if (PAGE_FLOW_STACK_INDEX_FIELD.equals(fieldName)) {
                pageFlowStackIndex = DebuggerEvaluatorUtils.evaluateInt(debuggeeData);
                continue;
            }
            if (LOCAL_TASK_FLOW_ID_FIELD.equals(fieldName)) {
                localTaskFlowId = DebuggerEvaluatorUtils.evaluateString(debuggeeData);
                continue;
            }
            if (DOCUMENT_NAME_FIELD.equals(fieldName)) {
                documentName = DebuggerEvaluatorUtils.evaluateString(debuggeeData);
                continue;
            }
            if (FULLY_QUALIFIED_NAME_FIELD.equals(fieldName)) {
                fullyQualifiedName = DebuggerEvaluatorUtils.evaluateString(debuggeeData);
                continue;
            }
            if (ACTIVITY_BINDING_CONTAINER_FIELD.equals(fieldName)) {
                activityBindingContainerAsDebuggeeData = debuggeeData;
                continue;
            }
            if (!DATA_CONTROL_FRAME_NAME_FIELD.equals(fieldName)) continue;
            dataControlFrameName = DebuggerEvaluatorUtils.evaluateString(debuggeeData);
        }
        if (localTaskFlowId == null) {
            UnboundedTaskFlowStackEntryElement unboundedTaskFlowStackEntryElement = new UnboundedTaskFlowStackEntryElement(viewPortId, pageFlowStackIndex, pageFlowStackEntryAsDebuggeeData, activityBindingContainerAsDebuggeeData, dataControlFrameName, nextPageFlowStackEntryElement);
        } else {
            BoundedTaskFlowStackEntryElement boundedTaskFlowStackEntryElement = new BoundedTaskFlowStackEntryElement(viewPortId, pageFlowStackIndex, pageFlowStackEntryAsDebuggeeData, localTaskFlowId, documentName, fullyQualifiedName, activityBindingContainerAsDebuggeeData, dataControlFrameName, nextPageFlowStackEntryElement);
        }
        return var11_15;
    }
}

