/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.data;

import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.adf.debugger.ui.AdfJavaVariableLabelProvider;
import oracle.eclipse.tools.adf.debugger.ui.views.data.ClickableValue;
import oracle.eclipse.tools.adf.debugger.ui.views.data.LinkableFieldProperty;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaModifiers;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDINullValue;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;

public class JDIPlaceholderVariable
extends PlatformObject
implements IJavaVariable,
IAdaptable {
    private static AdfJavaVariableLabelProvider fVariableLabelProvider = new AdfJavaVariableLabelProvider();
    private String fName;
    private IJavaValue fValue;
    private IJavaValue fLogicalParent;
    private IJavaType javaType;
    private static String ACTIVITY_ID_TYPE = "oracle.adf.controller.internal.metadata.ActivityId";
    private static String TASKFLOW_ID_TYPE = "oracle.adf.controller.TaskFlowId";
    private static String JUAPPLICATION_TYPE = "oracle.jbo.uicli.binding.JUApplication";
    private static String JUFORMBINDING_TYPE = "oracle.jbo.uicli.binding.JUFormBinding";
    private static String JUFORMDEF_TYPE = "oracle.jbo.uicli.binding.JUFormDef";
    private static Map<String, LinkableFieldProperty> LINKABLE_VALUE_MAP = new HashMap<String, LinkableFieldProperty>();

    static {
        LINKABLE_VALUE_MAP.put(ACTIVITY_ID_TYPE, new LinkableFieldProperty("mLocalActivityId", ClickableValue.TYPE.WEB_RESOURCE));
        LINKABLE_VALUE_MAP.put(TASKFLOW_ID_TYPE, new LinkableFieldProperty("mStringForm", ClickableValue.TYPE.WEB_RESOURCE));
        LINKABLE_VALUE_MAP.put(JUAPPLICATION_TYPE, new LinkableFieldProperty("mRootAMDefName", ClickableValue.TYPE.JAVA_RESOURCE));
        LINKABLE_VALUE_MAP.put(JUFORMBINDING_TYPE, new LinkableFieldProperty("mBindingContainerDef", ClickableValue.TYPE.PAGE_DEF));
        LINKABLE_VALUE_MAP.put(JUFORMDEF_TYPE, new LinkableFieldProperty("mName", ClickableValue.TYPE.PAGE_DEF));
    }

    public JDIPlaceholderVariable(String name, IJavaValue value) {
        this.fName = name;
        this.fValue = value;
    }

    public JDIPlaceholderVariable(String name, IJavaValue value, IJavaValue logicalParent) {
        this(name, value);
        this.fLogicalParent = logicalParent;
    }

    public String getSignature() throws DebugException {
        return ((IJavaValue)this.getValue()).getSignature();
    }

    public String getGenericSignature() throws DebugException {
        return ((IJavaValue)this.getValue()).getGenericSignature();
    }

    public IJavaType getJavaType() throws DebugException {
        IJavaValue javaVal = (IJavaValue)this.getValue();
        if (javaVal instanceof JDINullValue) {
            return this.javaType;
        }
        return javaVal.getJavaType();
    }

    public boolean isLocal() {
        return false;
    }

    public IValue getValue() {
        return this.fValue;
    }

    public String getName() {
        return this.fName;
    }

    public String getReferenceTypeName() throws DebugException {
        return ((IJavaValue)this.getValue()).getReferenceTypeName();
    }

    public boolean hasValueChanged() {
        return false;
    }

    public boolean isPublic() {
        return false;
    }

    public boolean isPrivate() {
        return false;
    }

    public boolean isProtected() {
        return false;
    }

    public boolean isPackagePrivate() {
        return false;
    }

    public boolean isFinal() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public String getModelIdentifier() {
        return "oracle.eclipse.tools.weblogic.debugger";
    }

    public IDebugTarget getDebugTarget() {
        if (this.getValue() == null) {
            return null;
        }
        return ((IJavaValue)this.getValue()).getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.getValue().getLaunch();
    }

    public void setValue(String expression) {
    }

    public void setValue(IValue value) {
    }

    public boolean supportsValueModification() {
        return false;
    }

    public void setJavaType(IJavaType returnJavaType) {
        this.javaType = returnJavaType;
    }

    public boolean verifyValue(String expression) {
        return false;
    }

    public boolean verifyValue(IValue value) {
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (IJavaVariable.class.equals((Object)adapter) || IJavaModifiers.class.equals((Object)adapter)) {
            return this;
        }
        if (adapter.equals(IElementLabelProvider.class)) {
            return fVariableLabelProvider;
        }
        if (this.fValue instanceof JDIObjectValue && ClickableValue.class.equals((Object)adapter)) {
            try {
                String typeName;
                this.javaType = this.getJavaType();
                if (this.javaType != null && JDIPlaceholderVariable.isLinkableValueType(typeName = this.javaType.getName())) {
                    JDIObjectValue obj = (JDIObjectValue)this.fValue;
                    String link = JDIPlaceholderVariable.getLinkableFieldValue(obj);
                    LinkableFieldProperty fieldProp = LINKABLE_VALUE_MAP.get(typeName);
                    ClickableValue val = new ClickableValue(obj.getDebugTarget(), link, fieldProp.type);
                    return val;
                }
            }
            catch (Exception exception) {}
        }
        return super.getAdapter(adapter);
    }

    public static boolean isLinkableValueType(String typeName) {
        return LINKABLE_VALUE_MAP.keySet().contains(typeName);
    }

    public static String getLinkableFieldValue(JDIObjectValue obj) {
        block4: {
            try {
                String typeName = obj.getJavaType().getName();
                LinkableFieldProperty fieldProp = LINKABLE_VALUE_MAP.get(typeName);
                IJavaFieldVariable fld = obj.getField(fieldProp.fieldName, false);
                if (fld == null) break block4;
                JDIObjectValue jdiVal = (JDIObjectValue)fld.getValue();
                String type = jdiVal.getReferenceTypeName();
                if (type.equals("oracle.jbo.uicli.binding.JUFormDef")) {
                    IJavaFieldVariable nameFld = jdiVal.getField("mFullName", true);
                    if (nameFld != null) {
                        String val = nameFld.getValue().getValueString();
                        return val;
                    }
                    break block4;
                }
                String val = fld.getValue().getValueString();
                return val;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JDIPlaceholderVariable) {
            boolean valueEqual;
            JDIPlaceholderVariable var = (JDIPlaceholderVariable)((Object)obj);
            if (this.fLogicalParent != null) {
                return var.getName().equals(this.getName()) && this.fLogicalParent.equals(var.fLogicalParent);
            }
            IValue val1 = var.getValue();
            IValue val2 = this.getValue();
            boolean bl = val1 != null ? val1.equals(val2) : (valueEqual = val1 == val2);
            return var.getName().equals(this.getName()) && valueEqual;
        }
        return false;
    }

    public int hashCode() {
        if (this.fLogicalParent != null) {
            return this.fLogicalParent.hashCode() + this.fName.hashCode();
        }
        return this.fName.hashCode() + (this.fValue != null ? this.fValue.hashCode() : 0);
    }
}

