/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.data;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.debugger.ui.AdfDebugUITools;
import oracle.eclipse.tools.adf.debugger.ui.views.data.JDIEvalDebuggeeDataInfo;
import oracle.eclipse.tools.adf.debugger.ui.views.data.JDIValueDebuggeeDataInfo;
import oracle.ide.Context;
import oracle.ide.runner.DebuggeeData;
import oracle.ide.runner.DebuggerEvaluator;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;

public class JDIDebuggerEvaluator
implements DebuggerEvaluator {
    JDIStackFrame jdiStackFrame = null;

    public JDIDebuggerEvaluator(JDIStackFrame jdiStackFrame) {
        this.jdiStackFrame = jdiStackFrame;
    }

    @Override
    public boolean hasExpired() {
        return !this.jdiStackFrame.isSuspended();
    }

    @Override
    public Context getContext() {
        return new Context();
    }

    @Override
    public Object getStackFrame() {
        return this.jdiStackFrame;
    }

    @Override
    public JDIEvalDebuggeeDataInfo evaluate(String expression, DebuggeeData context) {
        if (AdfDebugUITools.isDebugMode()) {
            String eval = expression.indexOf(46) > 0 ? expression : String.valueOf(context.getFullyQualifiedActualType()) + "." + expression;
            System.out.println("[ADF Debugger] Evaluating " + eval);
        }
        JDIEvalDebuggeeDataInfo ret = new JDIEvalDebuggeeDataInfo((JDIValueDebuggeeDataInfo)context, expression, this.jdiStackFrame);
        ret.evaluate();
        return ret;
    }

    @Override
    public List<DebuggeeData> evaluate(List<String> expressions, DebuggeeData context) {
        if (AdfDebugUITools.isDebugMode()) {
            System.out.println("[ADF Debugger] Batch evaluating " + expressions);
        }
        ArrayList<DebuggeeData> ret = new ArrayList<DebuggeeData>();
        for (String expr : expressions) {
            JDIEvalDebuggeeDataInfo data = new JDIEvalDebuggeeDataInfo((JDIValueDebuggeeDataInfo)context, expr, this.jdiStackFrame);
            data.evaluate();
            ret.add(data);
        }
        return ret;
    }

    public void setStackFram(JDIStackFrame jdiStackframe2) {
        this.jdiStackFrame = jdiStackframe2;
    }
}

