/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.data;

import oracle.eclipse.tools.weblogic.server.internal.util.ServerLaunchUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class ClickableValue {
    private IDebugTarget debugTarget;
    private String link;
    private TYPE type = TYPE.WEB_RESOURCE;

    public ClickableValue(IDebugTarget debugTarget, String link, TYPE type) {
        this.link = link;
        this.type = type;
        this.debugTarget = debugTarget;
    }

    public void open() throws CoreException {
        ILaunch launch = this.debugTarget.getLaunch();
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        IServer server = ServerUtil.getServer((ILaunchConfiguration)config);
        if (server != null) {
            for (IProject p : ServerLaunchUtils.findAllWebProject((IServer)server)) {
                IFile f;
                String relPath = this.link.toString();
                if (this.type == TYPE.PAGE_DEF) {
                    try {
                        String pageDefName = String.valueOf(relPath.replace('.', '/')) + ".xml";
                        IFolder afmsrc = p.getFolder("adfmsrc");
                        if (!afmsrc.exists()) {
                            return;
                        }
                        IPath pageDefPath = afmsrc.getFullPath().append(String.valueOf('/') + pageDefName);
                        f = ResourcesPlugin.getWorkspace().getRoot().getFile(pageDefPath);
                        if (f.exists()) {
                            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)f);
                            return;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                if (this.type == TYPE.WEB_RESOURCE) {
                    int n = relPath.indexOf(35);
                    if (n > 0) {
                        relPath = relPath.substring(0, n);
                    }
                    if (this.openFile(p, relPath)) {
                        return;
                    }
                    if (this.openFile(p, String.valueOf(relPath) + ".jspx")) {
                        return;
                    }
                    if (this.openFile(p, String.valueOf(relPath) + ".jsp")) {
                        return;
                    }
                    if (!this.openFile(p, String.valueOf(relPath) + ".jsff")) continue;
                    return;
                }
                if (this.type != TYPE.JAVA_RESOURCE) continue;
                String appXml = relPath.replace('.', '/');
                try {
                    IPath javaSrcPath = this.getJavaSourcePaht(p);
                    IPath path = javaSrcPath.append(String.valueOf(appXml) + ".xml");
                    f = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                    if (!f.exists()) continue;
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)f);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean openFile(IProject p, String name) throws PartInitException {
        IPath path = ClickableValue.getContentPath(p).append("/" + name);
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (f.exists()) {
            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)f);
            return true;
        }
        return false;
    }

    private IPath getJavaSourcePaht(IProject proj) throws JavaModelException {
        IJavaProject jproj = JavaCore.create((IProject)proj);
        IClasspathEntry[] iClasspathEntryArray = jproj.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (cpe.getEntryKind() == 3) {
                return cpe.getPath();
            }
            ++n2;
        }
        return null;
    }

    public static IPath getContentPath(IProject project) {
        IContainer underlyingFolder;
        IVirtualFolder rootFolder;
        IVirtualComponent component;
        if (project != null && (component = ComponentCore.createComponent((IProject)project)) != null && (rootFolder = component.getRootFolder()) != null && (underlyingFolder = rootFolder.getUnderlyingFolder()) != null) {
            return underlyingFolder.getFullPath();
        }
        return null;
    }

    static enum TYPE {
        WEB_RESOURCE,
        JAVA_RESOURCE,
        PAGE_DEF;

    }
}

