/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.data;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.adf.share.dt.debug.DataRootElement;
import oracle.adfdt.model.debug.structure.BindingContainerElement;
import oracle.eclipse.tools.adf.debugger.ui.views.data.AdfDebugDataContentProvider;
import oracle.eclipse.tools.adf.debugger.ui.views.data.AdfDebuggeeDataDecorator;
import oracle.eclipse.tools.adf.debugger.ui.views.data.DebuggerEvaluatorUtils;
import oracle.ide.Context;
import oracle.ide.model.DataColumn;
import oracle.ide.model.Element;
import oracle.ide.runner.DebuggeeData;
import oracle.ide.runner.DebuggerEvaluator;

class BindingContainerDataContentProvider
extends AdfDebugDataContentProvider {
    private static final String GET_DEBUG_DETAIL = "getBindingContainerDebugDetails()";
    private static final String GET_DEBUG_DETAIL2 = "oracle.adfinternal.model.debug.DebuggeeUtils.getBindingContainerDebugDetails(\"{0}\")";
    private static final String PAGEDEF = "Page Definition";

    BindingContainerDataContentProvider() {
    }

    @Override
    public List<Element> getChildren(Element structureElement, Element parentElement, Context context, DebuggerEvaluator evaluator) {
        ArrayList<Element> children = new ArrayList<Element>();
        if (structureElement instanceof BindingContainerElement) {
            BindingContainerElement bce = (BindingContainerElement)structureElement;
            if (parentElement instanceof DataRootElement) {
                DebuggeeData bceData = bce.asDebuggeeData();
                children.add(new PageDefinitionEntry(bce.getURL(), bceData));
                DebuggeeData bcDebugContext = bce.getBCDebugContext();
                if (bcDebugContext != null) {
                    children.addAll(this.evaluateData(evaluator, GET_DEBUG_DETAIL, bcDebugContext));
                } else {
                    String pagedefName = DebuggerEvaluatorUtils.evaluateString(bceData.getField("mName"));
                    children.addAll(this.evaluateData(evaluator, MessageFormat.format(GET_DEBUG_DETAIL2, pagedefName), null));
                }
            } else if (parentElement instanceof AdfDebuggeeDataDecorator) {
                children.addAll(this.getAdfDebuggeeDataChildren((AdfDebuggeeDataDecorator)parentElement, evaluator));
            }
        }
        return children;
    }

    private List<Element> evaluateData(DebuggerEvaluator evaluator, String command, DebuggeeData context) {
        DebuggeeData debugData;
        ArrayList<Element> children = new ArrayList<Element>();
        DebuggeeData debuggeeData = this.evaluateDebuggeeData(evaluator, command, context);
        if (debuggeeData != null && (debugData = debuggeeData.getField("mDebugData")) != null) {
            for (DebuggeeData debuggeeData2 : debugData.getChildren()) {
                children.add(new AdfDebuggeeDataDecorator(debuggeeData2, evaluator));
            }
        }
        return children;
    }

    public boolean includeValueColumn(Element structureElement, Context context, DebuggerEvaluator evaluator) {
        return structureElement instanceof BindingContainerElement;
    }

    @Override
    public List<DataColumn> getAdditionalColumns(Element structureElement, Context context, DebuggerEvaluator evaluator) {
        if (structureElement instanceof BindingContainerElement) {
            return ADDITIONAL_COLUMNS;
        }
        return super.getAdditionalColumns(structureElement, context, evaluator);
    }

    class PageDefinitionEntry
    extends AdfDebugDataContentProvider.LocatableEntry {
        private final DebuggeeData mDebuggeeData;

        PageDefinitionEntry(URL url, DebuggeeData data) {
            super(BindingContainerDataContentProvider.PAGEDEF, "page-definition", url);
            if (url != null) {
                String path = url.getPath();
                this.setValue(path.substring(path.lastIndexOf("/")));
            }
            this.mDebuggeeData = data;
        }

        @Override
        public Object getData() {
            return this.mDebuggeeData;
        }
    }
}

