/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.data;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.adf.share.dt.debug.DataRootElement;
import oracle.adf.share.dt.debug.ViewPortElement;
import oracle.adfdt.model.debug.structure.ApplicationDataElement;
import oracle.eclipse.tools.adf.debugger.ui.views.data.AdfDebugDataContentProvider;
import oracle.eclipse.tools.adf.debugger.ui.views.data.AdfDebuggeeDataDecorator;
import oracle.eclipse.tools.adf.debugger.ui.views.data.JDIValueDebuggeeDataInfo;
import oracle.ide.Context;
import oracle.ide.model.DataColumn;
import oracle.ide.model.Element;
import oracle.ide.runner.DebuggeeData;
import oracle.ide.runner.DebuggerEvaluator;

class ApplicationDataContentProvider
extends AdfDebugDataContentProvider {
    private static final String GET_DEBUG_DETAIL = "oracle.adfinternal.model.debug.DebuggeeUtils.getApplicationDataDebugDetails(\"{0}\")";
    private static final String GET_CURRENT_BINDING_CONTEXT = "oracle.adf.model.BindingContext.getCurrent()";

    ApplicationDataContentProvider() {
    }

    @Override
    public List<Element> getChildren(Element structureElement, Element parentElement, Context context, DebuggerEvaluator evaluator) {
        ArrayList<Element> children = new ArrayList<Element>();
        if (structureElement instanceof ApplicationDataElement) {
            if (parentElement instanceof DataRootElement) {
                DebuggeeData debugData;
                JDIValueDebuggeeDataInfo bindingContext;
                ApplicationDataElement ace = (ApplicationDataElement)structureElement;
                Element structureParentElement = ace.getParentElement();
                String dcFrameName = "";
                if (structureParentElement instanceof ViewPortElement) {
                    dcFrameName = ((ViewPortElement)structureParentElement).getDataControlFrameName();
                }
                if ((bindingContext = (JDIValueDebuggeeDataInfo)this.evaluateDebuggeeData(evaluator, GET_CURRENT_BINDING_CONTEXT, null)).getJDIValue() == null) {
                    return children;
                }
                String statement = MessageFormat.format(GET_DEBUG_DETAIL, dcFrameName);
                DebuggeeData debuggeeData = this.evaluateDebuggeeData(evaluator, statement, null);
                if (debuggeeData != null && (debugData = debuggeeData.getField("mDebugData")) != null) {
                    for (DebuggeeData debuggeeData2 : debugData.getChildren()) {
                        children.add(new AdfDebuggeeDataDecorator(debuggeeData2, evaluator));
                    }
                }
            } else if (parentElement instanceof AdfDebuggeeDataDecorator) {
                children.addAll(this.getAdfDebuggeeDataChildren((AdfDebuggeeDataDecorator)parentElement, evaluator));
            }
        }
        return children;
    }

    public boolean includeValueColumn(Element structureElement, Context context, DebuggerEvaluator evaluator) {
        return structureElement instanceof ApplicationDataElement;
    }

    @Override
    public List<DataColumn> getAdditionalColumns(Element structureElement, Context context, DebuggerEvaluator evaluator) {
        if (structureElement instanceof ApplicationDataElement) {
            return ADDITIONAL_COLUMNS;
        }
        return super.getAdditionalColumns(structureElement, context, evaluator);
    }
}

