/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.data;

import java.util.ArrayList;
import oracle.adf.share.dt.debug.DataRootElement;
import oracle.adf.share.dt.debug.StructureRootElement;
import oracle.adfdt.debug.scope.ScopeElement;
import oracle.eclipse.tools.adf.debugger.ui.views.data.AdfDataContentProvider;
import oracle.eclipse.tools.adf.debugger.ui.views.data.AdfDataTableViewer;
import oracle.eclipse.tools.adf.debugger.ui.views.data.AdfStructureContentProvider;
import oracle.eclipse.tools.adf.debugger.ui.views.data.AdfStructureLabelProvider;
import oracle.eclipse.tools.adf.debugger.ui.views.data.DebuggerEvaluatorUtils;
import oracle.eclipse.tools.adf.debugger.ui.views.data.JDIDebuggerEvaluator;
import oracle.eclipse.tools.adf.debugger.ui.views.data.JDIEvalDebuggeeDataInfo;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.VariablesViewModelPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.DebugModelPresentationContext;
import org.eclipse.debug.internal.ui.views.variables.details.DefaultDetailPane;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ViewPart;

public class AdfStructureDataView
extends ViewPart
implements IDebugContextListener {
    public static final String ID = "oracle.eclipse.tools.adf.debugger.ui.AdfStructureView";
    private TreeViewer adfStructureTreeViewer = null;
    private Label loadingText = null;
    private AdfDataTableViewer adfDataTableViewer = null;
    private AdfDataContentProvider adfDataContentProvider = AdfDataContentProvider.INSTANCE;
    protected VariablesViewModelPresentation fModelPresentation;
    private Composite fDetailsAnchor;
    private SashForm fSashForm;
    private SashForm sashForm;
    private boolean columnInitialized = false;

    protected void becomesVisible() {
        ISelection selection = this.getDebugContext();
        this.contextActivated(selection);
    }

    public void contextActivated(ISelection selection) {
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof JDIStackFrame) {
            JDIStackFrame stackFrame = (JDIStackFrame)obj;
            try {
                JDIDebuggerEvaluator evaluator1 = new JDIDebuggerEvaluator(stackFrame);
                String GET_CURRENT_BINDING_CONTEXT = "oracle.adf.model.BindingContext.getCurrent()";
                JDIEvalDebuggeeDataInfo data1 = evaluator1.evaluate(GET_CURRENT_BINDING_CONTEXT, null);
                JDIValue ret = data1.getJDIValue();
                if (this.adfStructureTreeViewer != null && this.adfStructureTreeViewer.getContentProvider() != null) {
                    DebuggerEvaluatorUtils.setStackFrame(stackFrame);
                    this.adfStructureTreeViewer.setInput((Object)StructureRootElement.INSTANCE);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            this.contextActivated(event.getContext());
        }
    }

    protected ISelection getDebugContext() {
        IViewSite site = (IViewSite)this.getSite();
        IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(site.getWorkbenchWindow());
        return contextService.getActiveContext(site.getId(), site.getSecondaryId());
    }

    protected Viewer createAdfStructureTreeViewer(Composite parent) {
        this.adfStructureTreeViewer = new TreeViewer(parent);
        AdfStructureContentProvider provider = new AdfStructureContentProvider();
        this.adfStructureTreeViewer.setContentProvider((IContentProvider)provider);
        AdfStructureLabelProvider labelProvider = new AdfStructureLabelProvider();
        this.adfStructureTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.adfStructureTreeViewer.setInput((Object)StructureRootElement.INSTANCE);
        return this.adfStructureTreeViewer;
    }

    public void clear() {
        this.adfStructureTreeViewer.setInput((Object)StructureRootElement.INSTANCE);
        this.adfStructureTreeViewer.refresh();
    }

    protected IDebugModelPresentation getModelPresentation() {
        if (this.fModelPresentation == null) {
            this.fModelPresentation = new VariablesViewModelPresentation();
        }
        return this.fModelPresentation;
    }

    protected String getPresentationContextId() {
        return "org.eclipse.debug.ui.VariableView";
    }

    protected TreeModelViewer createVariablesTreeViewer(Composite parent) {
        if (this.fModelPresentation == null) {
            this.fModelPresentation = new VariablesViewModelPresentation(){

                public String getText(Object element) {
                    IDebugModelPresentation lp = this.getConfiguredPresentation(element);
                    if (lp != null) {
                        return lp.getText(element);
                    }
                    return this.getDefaultText(element);
                }
            };
        }
        int style = this.getViewerStyle();
        DebugModelPresentationContext fPresentationContext = new DebugModelPresentationContext(this.getPresentationContextId(), (IWorkbenchPart)this, (IDebugModelPresentation)this.fModelPresentation);
        this.fSashForm = new SashForm(parent, 0);
        this.fSashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fSashForm.setOrientation(512);
        this.adfDataTableViewer = new AdfDataTableViewer((Composite)this.fSashForm, style, (IPresentationContext)fPresentationContext);
        this.adfDataTableViewer.initViewer();
        this.fDetailsAnchor = SWTFactory.createComposite((Composite)this.fSashForm, (Font)parent.getFont(), (int)1, (int)1, (int)1808, (int)0, (int)0);
        DefaultDetailPane detailPane = new DefaultDetailPane();
        detailPane.createControl(this.fDetailsAnchor);
        this.adfDataTableViewer.setDefaultDetailPane(detailPane);
        this.fSashForm.setWeights(new int[]{70, 30});
        this.fSashForm.layout();
        return this.adfDataTableViewer;
    }

    protected int getViewerStyle() {
        return 268501770;
    }

    protected Viewer createAdfDataTableViewer(Composite parent) {
        this.createVariablesTreeViewer(parent);
        this.adfDataTableViewer.setInput(StructureRootElement.INSTANCE);
        return this.adfDataTableViewer;
    }

    public void createPartControl(Composite parent) {
        this.sashForm = new SashForm(parent, 256);
        this.sashForm.setLayout((Layout)new FillLayout());
        this.createAdfStructureTreeViewer((Composite)this.sashForm);
        Composite comp = new Composite((Composite)this.sashForm, 0);
        comp.setLayout((Layout)new GridLayout(1, true));
        this.loadingText = new Label(comp, 0);
        this.loadingText.setText("Loading data...");
        this.loadingText.setVisible(false);
        this.loadingText.setLayoutData((Object)new GridData());
        this.createAdfDataTableViewer(comp);
        this.sashForm.setWeights(new int[]{30, 70});
        this.adfStructureTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection selection = (TreeSelection)event.getSelection();
                Object elm = selection.getFirstElement();
                AdfStructureDataView.this.updateAdfDataTable(elm, selection.getPaths());
            }
        });
        DebugUITools.addPartDebugContextListener((IWorkbenchPartSite)this.getViewSite(), (IDebugContextListener)this);
        this.becomesVisible();
    }

    public void dispose() {
        super.dispose();
        DebugUITools.removePartDebugContextListener((IWorkbenchPartSite)this.getViewSite(), (IDebugContextListener)this);
    }

    private void updateAdfDataTable(Object inputElement, TreePath[] treePaths) {
        if (DebuggerEvaluatorUtils.getDebuggerEvaluator() == null) {
            ArrayList<DataRootElement> list = new ArrayList<DataRootElement>();
            list.add(new DataRootElement());
            this.adfDataTableViewer.setInput(list);
            return;
        }
        final boolean[] updatesComplete = new boolean[]{false};
        this.adfDataTableViewer.addViewerUpdateListener(new IViewerUpdateListener(){

            public void viewerUpdatesComplete() {
                updatesComplete[0] = true;
                AdfStructureDataView.this.loadingText.setVisible(false);
                AdfStructureDataView.this.adfDataTableViewer.getTree().setVisible(true);
            }

            public void viewerUpdatesBegin() {
                updatesComplete[0] = false;
            }

            public void updateStarted(IViewerUpdate update) {
            }

            public void updateComplete(IViewerUpdate update) {
            }
        });
        Object input = this.adfDataContentProvider.getDataTableViewerInput(inputElement, treePaths);
        this.adfDataTableViewer.setInput(input);
        if (inputElement instanceof ScopeElement) {
            this.loadingText.setVisible(true);
            this.adfDataTableViewer.getTree().setVisible(false);
        }
        if (!this.columnInitialized) {
            String[] ids = new String[]{"org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME", "org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_VALUE", "org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VALUE_TYPE"};
            this.adfDataTableViewer.resetColumnSizes(ids);
            this.adfDataTableViewer.setVisibleColumns(ids);
            this.columnInitialized = true;
        }
    }

    public void setFocus() {
    }
}

