/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.data;

import java.util.Iterator;
import java.util.List;
import oracle.adfdt.debug.common.DebuggeeDataDecorator;
import oracle.eclipse.tools.adf.debugger.ui.OracleIcons;
import oracle.eclipse.tools.adf.debugger.ui.views.data.DebuggerEvaluatorUtils;
import oracle.ide.model.Element;
import oracle.ide.runner.DebuggeeData;
import oracle.ide.runner.DebuggerEvaluator;
import org.eclipse.swt.graphics.Image;

public class AdfDebuggeeDataDecorator
extends DebuggeeDataDecorator {
    String _type;
    String _typeTip;
    String _value;
    String _origValue;
    DebuggeeData _childrenData;
    String _iconName = null;
    String _shortLabel = null;
    String _evaluationCommand = null;
    boolean _bCurrentRow = false;
    boolean _bUpdated = false;
    boolean _bDelayEvaluation = false;
    boolean _bDisplayDebugObjectAsChildren = false;
    DebuggerEvaluator _evaluator;
    DebuggeeData _evaluationContext;

    public AdfDebuggeeDataDecorator(DebuggeeData data, DebuggerEvaluator evaluator) {
        super(DebuggerEvaluatorUtils.evaluateString(data.getField("mName")), DebuggerEvaluatorUtils.evaluateString(data.getField("mIconName")) != null ? OracleIcons.getIcon(DebuggerEvaluatorUtils.evaluateString(data.getField("mIconName"))) : null, data.getField("mDebugObject"));
        this._evaluator = evaluator;
        this._type = DebuggerEvaluatorUtils.evaluateString(data.getField("mType"));
        this._typeTip = DebuggerEvaluatorUtils.evaluateString(data.getField("mFullType"));
        this._value = DebuggerEvaluatorUtils.evaluateString(data.getField("mValue"));
        this._origValue = DebuggerEvaluatorUtils.evaluateString(data.getField("mOrigValue"));
        this._childrenData = data.getField("mChildren");
        this._evaluationCommand = DebuggerEvaluatorUtils.evaluateString(data.getField("mEvaluationCommand"));
        this._bCurrentRow = DebuggerEvaluatorUtils.evaluateBoolean(data.getField("bCurrentRow"));
        this._bUpdated = DebuggerEvaluatorUtils.evaluateBoolean(data.getField("bUpdated"));
        this._bDelayEvaluation = DebuggerEvaluatorUtils.evaluateBoolean(data.getField("bDelayEvaluation"));
        this._bDisplayDebugObjectAsChildren = DebuggerEvaluatorUtils.evaluateBoolean(data.getField("bDisplayDebugObjectAsChildren"));
        this._evaluationContext = data.getField("mEvaluationContext");
        String defObjectType = DebuggerEvaluatorUtils.evaluateString(data.getField("mDefObjectType"));
        if (defObjectType != null) {
            String defObjectName = DebuggerEvaluatorUtils.evaluateString(data.getField("mDefObjectName"));
            if ("JBO".equals(defObjectType)) {
                this.setJboObject(defObjectName);
            } else if ("TF".equals(defObjectType)) {
                this.setTaskflowObject(defObjectName);
            } else if ("PD".equals(defObjectType)) {
                this.setPageDefObject(defObjectName);
            }
        }
    }

    private void setJboObject(String defObjectName) {
    }

    private void setTaskflowObject(String defObjectName) {
    }

    private void setPageDefObject(String defObjectName) {
    }

    public void setLongLabel(String value) {
        this._value = value;
    }

    public boolean isChanged() {
        return this._origValue != null || this._bUpdated;
    }

    public boolean isCurrentRow() {
        return this._bCurrentRow;
    }

    public boolean isDelayEvaluation() {
        return this._bDelayEvaluation;
    }

    @Override
    public String getShortLabel() {
        String label = this._shortLabel;
        if (label == null) {
            label = super.getShortLabel();
        }
        if (label == null) {
            label = "";
        }
        return label;
    }

    @Override
    public String getLongLabel() {
        if (this._bDelayEvaluation && this._evaluationCommand != null) {
            this._value = DebuggerEvaluatorUtils.evaluateString(this._evaluator.evaluate(this._evaluationCommand, this._evaluationContext));
            this._bDelayEvaluation = false;
        }
        if (this._origValue != null) {
            return new StringBuffer(this._value == null ? "null" : this._value).append(" (was: ").append(this._origValue).append(")").toString();
        }
        return this._value == null ? "null" : this._value;
    }

    @Override
    public boolean mayHaveChildren() {
        return this._childrenData != null;
    }

    @Override
    public Image getIcon() {
        if (this._iconName != null) {
            return OracleIcons.getIcon(this._iconName);
        }
        return super.getIcon();
    }

    public String getType() {
        return this._type;
    }

    public String getTypeTip() {
        return this._typeTip;
    }

    public DebuggeeData getEvaluationContext() {
        return this._evaluationContext;
    }

    public String getEvaluationCommand() {
        return this._evaluationCommand;
    }

    @Override
    public Iterator<Element> getChildren() {
        if (!this._bDisplayDebugObjectAsChildren || !this.isDelayEvaluation() && this.getEvaluationCommand() != null) {
            return NO_CHILDREN.iterator();
        }
        return this._childrenData == null || this._childrenData.getChildren() == null || this._childrenData.getChildren().size() == 0 ? super.getChildren() : NO_CHILDREN.iterator();
    }

    public List<? extends DebuggeeData> getChildrenData() {
        DebuggeeData debuggeeData;
        if (!this.isDelayEvaluation() && this.getEvaluationCommand() != null) {
            return null;
        }
        if (this._childrenData != null) {
            return this._childrenData.getChildren();
        }
        if (this._bDisplayDebugObjectAsChildren && (debuggeeData = super.asDebuggeeData()) != null) {
            return debuggeeData.getChildren();
        }
        return null;
    }
}

