/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.ui.views.data;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.adf.share.dt.debug.AdfViewDebugUtils;
import oracle.adfdt.debug.common.AdfDebuggerElementAttributes;
import oracle.eclipse.tools.adf.debugger.ui.OracleIcons;
import oracle.eclipse.tools.adf.debugger.ui.views.data.AdfDebuggeeDataDecorator;
import oracle.eclipse.tools.adf.debugger.ui.views.data.DefaultDataContentProvider;
import oracle.ide.Context;
import oracle.ide.model.AdfDataTypeColumn;
import oracle.ide.model.Attributes;
import oracle.ide.model.DataColumn;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.runner.DebuggeeData;
import oracle.ide.runner.DebuggerEvaluator;
import org.eclipse.swt.graphics.Image;

abstract class AdfDebugDataContentProvider
extends DefaultDataContentProvider {
    private static final DataColumn DATA_TYPE_COLUMN = new AdfDataTypeColumn();
    protected static final List<DataColumn> ADDITIONAL_COLUMNS = Collections.singletonList(DATA_TYPE_COLUMN);

    AdfDebugDataContentProvider() {
    }

    protected List<Element> getAdfDebuggeeDataChildren(AdfDebuggeeDataDecorator entry, DebuggerEvaluator evaluator) {
        List<? extends DebuggeeData> dcList;
        ArrayList<Element> children = new ArrayList<Element>();
        String debugDetailCommand = entry.getEvaluationCommand();
        if (debugDetailCommand != null && !entry.isDelayEvaluation()) {
            DebuggeeData context = entry.getEvaluationContext();
            children.addAll(this.evaluateChildrenData(evaluator, debugDetailCommand, context));
        }
        if ((dcList = entry.getChildrenData()) != null) {
            for (DebuggeeData debuggeeData : dcList) {
                children.add(this.getDataDecorator(debuggeeData, evaluator));
            }
        }
        return children;
    }

    private List<Element> evaluateChildrenData(DebuggerEvaluator evaluator, String command, DebuggeeData context) {
        ArrayList<Element> children = new ArrayList<Element>();
        DebuggeeData debuggeeData = this.evaluateDebuggeeData(evaluator, command, context);
        if (debuggeeData != null) {
            List<? extends DebuggeeData> cc;
            DebuggeeData debugData = debuggeeData.getField("mDebugData");
            if (debugData != null) {
                debuggeeData = debugData;
            }
            if ((cc = debuggeeData.getChildren()) != null) {
                for (DebuggeeData debuggeeData2 : debuggeeData.getChildren()) {
                    children.add(this.getDataDecorator(debuggeeData2, evaluator));
                }
            }
        }
        return children;
    }

    private AdfDebuggeeDataDecorator getDataDecorator(DebuggeeData data, DebuggerEvaluator evaluator) {
        AdfDebuggeeDataDecorator debuggeeData = new AdfDebuggeeDataDecorator(data, evaluator);
        Attributes debuggeeDataAttributes = debuggeeData.getAttributes();
        if (debuggeeData.isChanged()) {
            debuggeeDataAttributes.set(AdfDebuggerElementAttributes.CHANGED_VALUE);
        }
        if (debuggeeData.isCurrentRow()) {
            debuggeeDataAttributes.set(AdfDebuggerElementAttributes.CURRENT_SELECTION);
        }
        if (debuggeeData.isDelayEvaluation()) {
            debuggeeDataAttributes.set(AdfDebuggerElementAttributes.DEFERRED_VALUE);
        }
        return debuggeeData;
    }

    protected DebuggeeData evaluateDebuggeeData(DebuggerEvaluator evaluator, String expression, DebuggeeData context) {
        AdfViewDebugUtils.ensureUtilClassLoaded(evaluator);
        return evaluator.evaluate(expression, context);
    }

    public List<DataColumn> getAdditionalColumns(Element structureElement, Context context, DebuggerEvaluator evaluator) {
        return Collections.EMPTY_LIST;
    }

    protected class LocatableEntry
    extends DefaultElement
    implements Locatable {
        private String _name;
        private String _value;
        private String _iconName;
        private URL _url;

        public LocatableEntry() {
        }

        public LocatableEntry(String name, String iconName, URL url) {
            this(name, null, iconName, url);
        }

        public LocatableEntry(String name, String value, String iconName, URL url) {
            this._name = name;
            this._value = value;
            this._iconName = iconName;
            this._url = url;
        }

        public void setShortLabel(String name) {
            this._name = name;
        }

        @Override
        public String getShortLabel() {
            return this._name;
        }

        @Override
        public String getLongLabel() {
            return this._value != null ? this._value : super.getLongLabel();
        }

        @Override
        public void setURL(URL url) {
            this._url = url;
        }

        @Override
        public URL getURL() {
            return this._url;
        }

        public void setValue(String value) {
            this._value = value;
        }

        @Override
        public Image getIcon() {
            return OracleIcons.getIcon(this._iconName);
        }
    }
}

